/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.util.RendererHelper;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class SimpleStorageBoxEntityRenderer
implements BlockEntityRenderer<SimpleStorageBoxEntity> {
    protected final BlockEntityRendererProvider.Context context;

    public SimpleStorageBoxEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public static void renderFromContraptionContext(MovementContext context, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double distance;
        BlockState state = context.state;
        CompoundTag tag = context.blockEntityData;
        if (tag == null || state == null) {
            return;
        }
        int amount = tag.m_128451_("StoredAmount");
        int totalSpace = tag.m_128451_("MaxItemCapacity");
        int percentUsed = (int)Math.round((double)amount / (double)totalSpace * 100.0);
        String line1 = Util.formatNumber(amount);
        String line2 = percentUsed + "% Used";
        Direction side = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        PoseStack poseStack = matrices.getModelViewProjection();
        poseStack.m_85836_();
        poseStack.m_252880_((float)context.localPos.m_123341_() + 0.5f, (float)context.localPos.m_123342_() + 0.5f, (float)context.localPos.m_123343_() + 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(RendererHelper.SIDE_ROT_Y[side.ordinal()]));
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        double d = distance = context.position != null ? Math.sqrt(player.m_20238_(context.position)) : Math.sqrt(player.m_20238_(context.contraption.entity.toGlobalVector(Vec3.m_82512_((Vec3i)context.localPos), 1.0f)));
        if (distance >= 10.0) {
            poseStack.m_85849_();
            return;
        }
        ItemRenderer itemRenderer = mc.m_91291_();
        int color = RendererHelper.getColorForDistance(distance);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color);
        RendererHelper.renderLine(line2, -4.0f, poseStack, buffer, color);
        if (tag.m_128441_("FilterItem")) {
            ItemStack filterItem;
            ItemStack itemStack = filterItem = tag.m_128469_("FilterItem").m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)tag.m_128469_("FilterItem"));
            if (!filterItem.m_41619_()) {
                RendererHelper.renderItem(itemRenderer, filterItem, poseStack, buffer, tag.m_128471_("VoidUpgrade"));
            }
        }
        poseStack.m_85849_();
    }

    public void render(@NotNull SimpleStorageBoxEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        Screen currentScreen = mc.f_91080_;
        boolean isPonderScene = currentScreen instanceof AbstractSimiScreen;
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        int amount = blockEntity.getStoredAmount();
        int totalSpace = blockEntity.getMaxItemCapacity();
        int percentUsed = (int)Math.round((double)amount / (double)totalSpace * 100.0);
        String line1 = Util.formatNumber(amount);
        String line2 = percentUsed + "% Used";
        float distance = (float)Math.sqrt(blockEntity.m_58899_().m_203193_((Position)player.m_20182_()));
        if (distance > 10.0f && !isPonderScene) {
            return;
        }
        if (isPonderScene) {
            distance = 3.0f;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction side = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252931_(new Matrix4f().rotateYXZ(RendererHelper.SIDE_ROT_Y[side.ordinal()], 0.0f, 0.0f));
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        int color = RendererHelper.getColorForDistance(distance);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color);
        RendererHelper.renderLine(line2, -4.0f, poseStack, buffer, color);
        ItemStack filterItem = blockEntity.getFilterItem();
        if (!filterItem.m_41619_() || blockEntity.voidUpgrade) {
            RendererHelper.renderItem(Minecraft.m_91087_().m_91291_(), filterItem, poseStack, buffer, blockEntity.voidUpgrade);
        }
    }
}

