/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import java.util.Objects;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxUpgradeSlot;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxVoidSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class SimpleStorageBoxMenu
extends AbstractContainerMenu {
    public final SimpleStorageBoxEntity blockEntity;
    public final Player player;

    public SimpleStorageBoxMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, Objects.requireNonNull(inventory.f_35978_.m_9236_().m_7702_(buf.m_130135_())));
    }

    public SimpleStorageBoxMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MENU.get(), containerId);
        this.player = inventory.f_35978_;
        this.blockEntity = (SimpleStorageBoxEntity)entity;
        this.initSlots();
    }

    public void initSlots() {
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.m_38897_((Slot)new SimpleStorageBoxVoidSlot((IItemHandler)itemHandler, 1, 8, 20));
            for (int i = 0; i < 9; ++i) {
                int slot = i + 2;
                int y = 58;
                int x = 8;
                this.m_38897_((Slot)new SimpleStorageBoxUpgradeSlot((IItemHandler)itemHandler, slot, x + 18 * i, y));
            }
        });
        Inventory playerInventory = this.player.m_150109_();
        int xOffset = 8;
        int yOffset = 94;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset = yOffset + 54 + 4;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean m_6875_(Player player) {
        return !this.blockEntity.m_58901_() && Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)player, (double)(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) + 0.5));
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(this.player);
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        int upgrades;
        ItemStack itemStack;
        this.blockEntity.setPlayerInteraction(true);
        int playerStartSlot = 10;
        if (pSlotId >= 0 && pSlotId < playerStartSlot && (itemStack = ((Slot)this.f_38839_.get(pSlotId)).m_7993_()).m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get()) && (upgrades = this.blockEntity.getCapacityUpgrades()) > 0) {
            int capacityCheck;
            int storedAmount = this.blockEntity.getStoredAmount();
            int stackSize = 64;
            if (!this.blockEntity.filterItem.m_41619_()) {
                stackSize = this.blockEntity.filterItem.m_41741_();
            }
            if ((capacityCheck = (32 << upgrades - 1) * stackSize) < storedAmount) {
                return;
            }
        }
        super.m_150399_(pSlotId, pButton, pClickType, this.player);
        this.blockEntity.setPlayerInteraction(false);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack slotStack = ((Slot)this.f_38839_.get(index)).m_7993_();
        int playerStartSlot = 10;
        if (index < playerStartSlot) {
            int playerSlot = player.m_150109_().m_36050_(slotStack);
            if (playerSlot == -1) {
                playerSlot = player.m_150109_().m_36062_();
            }
            if (playerSlot > -1) {
                ItemStack playerStack = player.m_150109_().m_8020_(playerSlot);
                if (playerStack.m_41619_()) {
                    player.m_150109_().m_6836_(playerSlot, slotStack.m_255036_(1));
                } else {
                    playerStack.m_41769_(1);
                }
                slotStack.m_41774_(1);
                this.blockEntity.m_6596_();
                player.m_150109_().m_6596_();
                return ItemStack.f_41583_;
            }
        } else if (slotStack.m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
            if (!((Slot)this.f_38839_.get(0)).m_6657_()) {
                ((Slot)this.f_38839_.get(0)).m_5852_(slotStack.m_255036_(1));
                slotStack.m_41774_(1);
                this.blockEntity.m_6596_();
                player.m_150109_().m_6596_();
                return slotStack;
            }
        } else if (slotStack.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            for (int i = 1; i <= 9; ++i) {
                if (((Slot)this.f_38839_.get(i)).m_6657_()) continue;
                ((Slot)this.f_38839_.get(i)).m_5852_(slotStack.m_255036_(1));
                slotStack.m_41774_(1);
                this.blockEntity.m_6596_();
                player.m_150109_().m_6596_();
                return slotStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        int playerStartSlot = 10;
        if (slot.f_40219_ < playerStartSlot) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }
}

