/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage.mounted;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.menu.StorageInteractionWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.utility.CreateCodecs;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMountedStorageTypes;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.registry.ContraptionStorageFilters;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageBoxMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler>
implements ContraptionStorageFilters.FilteredMountedStorage {
    public static final Codec<SimpleStorageBoxMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(SimpleStorageBoxMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped);
    public boolean initialized = false;
    private boolean dirty = false;
    private ItemStack filterItem = ItemStack.f_41583_;
    @Nullable
    private FilterItemStack lastRegisteredFilter = null;
    @Nullable
    private Contraption currentContraption = null;

    protected SimpleStorageBoxMountedStorage(MountedItemStorageType<?> type, ItemStackHandler handler) {
        super(type, (IItemHandlerModifiable)handler);
    }

    protected SimpleStorageBoxMountedStorage(ItemStackHandler handler) {
        this((MountedItemStorageType)ModMountedStorageTypes.SIMPLE_STORAGE_BOX_MOUNTED.get(), handler);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        if (player.m_5833_()) {
            return false;
        }
        ItemStack itemInHand = player.m_21205_();
        if (!itemInHand.m_41619_()) {
            if (itemInHand.m_41720_().equals(this.filterItem.m_41720_()) || this.filterItem.m_41619_()) {
                if (!itemInHand.m_204117_(AllTags.AllItemTags.WRENCH.tag)) {
                    ItemStack remain = ((ItemStackHandler)this.wrapped).insertItem(1, itemInHand, false);
                    player.m_21008_(InteractionHand.MAIN_HAND, remain);
                }
            } else if (itemInHand.m_204117_(ModTags.Items.STORAGE_BOX_UPGRADE)) {
                if (itemInHand.m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
                    if (!this.hasVoidUpgrade()) {
                        ((ItemStackHandler)this.wrapped).setStackInSlot(1, itemInHand.m_255036_(1));
                        if (!player.m_7500_()) {
                            itemInHand.m_41774_(1);
                            player.m_150109_().m_6596_();
                        }
                    } else {
                        ItemStack voidStack = ((ItemStackHandler)this.wrapped).getStackInSlot(1);
                        int slot = player.m_150109_().m_36050_(voidStack);
                        if (slot > -1) {
                            player.m_150109_().m_8020_(slot).m_41769_(1);
                            player.m_150109_().m_6596_();
                        } else {
                            slot = player.m_150109_().m_36062_();
                            if (slot > -1) {
                                player.m_150109_().m_6836_(slot, voidStack);
                                player.m_150109_().m_6596_();
                            } else {
                                player.m_36176_(voidStack, false);
                            }
                        }
                        ((ItemStackHandler)this.wrapped).setStackInSlot(1, ItemStack.f_41583_);
                    }
                } else if (itemInHand.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
                    boolean canAddUpgrade = false;
                    for (int i = 2; i < 11; ++i) {
                        if (!((ItemStackHandler)this.wrapped).getStackInSlot(i).m_41619_()) continue;
                        ((ItemStackHandler)this.wrapped).setStackInSlot(i, itemInHand.m_255036_(1));
                        canAddUpgrade = true;
                        break;
                    }
                    if (!player.m_7500_() && canAddUpgrade) {
                        itemInHand.m_41774_(1);
                        player.m_150109_().m_6596_();
                    } else if (!canAddUpgrade) {
                        player.m_5661_((Component)Component.m_237115_((String)"fxntstorage.storage_box_capacity_upgrade_max"), true);
                    }
                }
            }
            this.markDirty();
            return false;
        }
        ServerLevel level = player.m_284548_();
        BlockPos localPos = info.f_74675_();
        Vec3 localPosVec = Vec3.m_82512_((Vec3i)localPos);
        Predicate<Player> stillValid = p -> {
            Vec3 currentPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            return this.isMenuValid(player, contraption, currentPos);
        };
        MutableComponent blockName = Component.m_237115_((String)"container.fxntstorage.simple_storage_box_title");
        MutableComponent menuName = CreateLang.translateDirect((String)"contraptions.moving_container", (Object[])new Object[]{blockName});
        Consumer<Player> onClose = p -> {
            Vec3 newPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.playClosingSound(level, newPos);
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this.createMenu((Component)menuName, this.wrapped, stillValid, onClose, contraption.entity.m_19879_(), localPos, info.f_74677_()), buf -> {
            buf.writeInt(contraption.entity.m_19879_());
            buf.m_130064_(localPos);
            buf.m_130079_(info.f_74677_());
        });
        return true;
    }

    private boolean hasVoidUpgrade() {
        return ((ItemStackHandler)this.wrapped).getStackInSlot(1).m_150930_(ModItems.STORAGE_BOX_VOID_UPGRADE.m_5456_());
    }

    private int getMaxItemCapacity() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!((ItemStackHandler)this.wrapped).getStackInSlot(i).m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        int maxCapacity = 32 << upgradeCount;
        int stackSize = this.filterItem.m_41619_() ? 64 : this.filterItem.m_41741_();
        return maxCapacity * stackSize;
    }

    @Nullable
    protected MenuProvider createMenu(Component name, IItemHandlerModifiable handler, Predicate<Player> stillValid, Consumer<Player> onClose, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        StorageInteractionWrapper wrapper = new StorageInteractionWrapper(handler, stillValid, onClose);
        return new SimpleMenuProvider((arg_0, arg_1, arg_2) -> SimpleStorageBoxMountedStorage.lambda$createMenu$4((Container)wrapper, contraptionId, localPos, nbt, arg_0, arg_1, arg_2), name);
    }

    public static SimpleStorageBoxMountedStorage fromStorage(SimpleStorageBoxEntity simpleStorageBox) {
        return new SimpleStorageBoxMountedStorage(SimpleStorageBoxMountedStorage.copyToItemStackHandler((IItemHandler)simpleStorageBox.getItemHandler()));
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof SimpleStorageBoxEntity) {
            SimpleStorageBoxEntity simpleStorageBox = (SimpleStorageBoxEntity)be;
            simpleStorageBox.applyInventoryToBlock((ItemStackHandler)this.wrapped, this.filterItem);
        }
        this.currentContraption = null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot > 0) {
            return stack;
        }
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = ((ItemStackHandler)this.wrapped).getStackInSlot(slot);
        int limit = this.getMaxItemCapacity();
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return this.hasVoidUpgrade() ? ItemStack.f_41583_ : stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                ((ItemStackHandler)this.wrapped).setStackInSlot(slot, reachedLimit ? stack.m_255036_(limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
        }
        if (this.filterItem.m_41619_()) {
            this.filterItem = stack.m_255036_(1);
        }
        this.markDirty();
        if (reachedLimit) {
            return this.hasVoidUpgrade() ? ItemStack.f_41583_ : stack.m_255036_(stack.m_41613_() - limit);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = super.extractItem(slot, amount, simulate);
        if (!stack.m_41619_() && !simulate) {
            this.markDirty();
        }
        return stack;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        ContraptionStorageFilters registry;
        if (this.currentContraption != null && (registry = ContraptionStorageFilters.getOrCreate(this.currentContraption)).matches(this.currentContraption.entity.m_9236_(), stack) && this.filterItem.m_41619_()) {
            return false;
        }
        if (this.filterTest(stack)) {
            boolean voidUpgrade = this.hasVoidUpgrade();
            if (slot > 0) {
                return false;
            }
            if (voidUpgrade) {
                return true;
            }
            return ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41613_() < this.getMaxItemCapacity();
        }
        return false;
    }

    private float getPercent() {
        return (float)((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41613_() / (float)this.getMaxItemCapacity() * 100.0f;
    }

    public boolean filterTest(ItemStack stack) {
        return this.filterItem.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.filterItem);
    }

    private EnumProperties.StorageUsed calculateFillLevel() {
        EnumProperties.StorageUsed fillLevel = EnumProperties.StorageUsed.EMPTY;
        int stored = ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41613_();
        if (stored >= this.getMaxItemCapacity()) {
            fillLevel = EnumProperties.StorageUsed.FULL;
        } else if (stored > 0) {
            fillLevel = EnumProperties.StorageUsed.HAS_ITEMS;
        }
        return fillLevel;
    }

    public void updateClientStorageData(MovementContext context) {
        boolean voidUpgrade;
        int amount = ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41613_();
        int maxCapacity = this.getMaxItemCapacity();
        boolean bl = voidUpgrade = !((ItemStackHandler)this.wrapped).getStackInSlot(1).m_41619_();
        if (!((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41619_() && this.filterItem.m_41619_()) {
            this.filterItem = ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_255036_(1);
        }
        context.blockEntityData.m_128365_("FilterItem", (Tag)this.filterItem.m_41739_(new CompoundTag()));
        EnumProperties.StorageUsed fillLevel = this.calculateFillLevel();
        context.blockEntityData.m_128405_("StoredAmount", amount);
        context.blockEntityData.m_128379_("VoidUpgrade", voidUpgrade);
        context.blockEntityData.m_128405_("MaxItemCapacity", maxCapacity);
        context.blockEntityData.m_128350_("PercentageUsed", this.getPercent());
        if (!((EnumProperties.StorageUsed)((Object)context.state.m_61143_(SimpleStorageBox.STORAGE_USED))).equals((Object)fillLevel)) {
            BlockState updatedState = (BlockState)context.state.m_61124_(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)fillLevel));
            StructureTemplate.StructureBlockInfo updatedInfo = new StructureTemplate.StructureBlockInfo(context.localPos, updatedState, context.blockEntityData);
            context.contraption.getBlocks().put(context.localPos, updatedInfo);
        }
        ModNetwork.sendToAllTracking((Entity)context.contraption.entity, new SyncMountedStoragePacket(context.contraption.entity.m_19879_(), context.localPos, fillLevel, context.blockEntityData));
        this.markClean();
    }

    public void initBlockEntityData(MovementContext context) {
        if (this.initialized) {
            return;
        }
        CompoundTag itemsTag = context.blockEntityData.m_128469_("Items");
        int oldSize = itemsTag.m_128451_("Size");
        if (oldSize != SimpleStorageBoxEntity.SLOT_COUNT) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Simple Storage Box mounted on contraption {} at {}", (Object)context.contraption.entity.m_19879_(), (Object)context.localPos);
            if (oldSize == 0) {
                ListTag existingItems = context.blockEntityData.m_128437_("Items", 10);
                oldSize = context.blockEntityData.m_128451_("slotCount");
                CompoundTag newTag = new CompoundTag();
                newTag.m_128405_("Size", oldSize);
                newTag.m_128365_("Items", (Tag)existingItems);
                itemsTag = newTag;
            }
            CompoundTag migratedNbt = this.migrateSlotItems(itemsTag, oldSize);
            context.blockEntityData.m_128365_("Items", (Tag)migratedNbt);
            ItemStackHandler newWrapped = this.createItemHandler(SimpleStorageBoxEntity.SLOT_COUNT);
            newWrapped.deserializeNBT(migratedNbt);
            for (int i = 0; i < ((ItemStackHandler)this.wrapped).getSlots(); ++i) {
                if (i < newWrapped.getSlots()) {
                    ((ItemStackHandler)this.wrapped).setStackInSlot(i, newWrapped.getStackInSlot(i));
                    continue;
                }
                ((ItemStackHandler)this.wrapped).setStackInSlot(i, ItemStack.f_41583_);
            }
        }
        this.filterItem = ItemStack.m_41712_((CompoundTag)context.blockEntityData.m_128469_("FilterItem")).m_255036_(1);
        this.currentContraption = context.contraption.entity.getContraption();
        if (this.currentContraption != null && !this.filterItem.m_41619_()) {
            FilterItemStack filterWrapper = FilterItemStack.of((ItemStack)this.filterItem);
            ContraptionStorageFilters registry = ContraptionStorageFilters.getOrCreate(this.currentContraption);
            registry.register((ContraptionStorageFilters.FilteredMountedStorage)this, filterWrapper);
            this.lastRegisteredFilter = filterWrapper;
        }
        ModNetwork.sendToAllTracking((Entity)context.contraption.entity, new SyncMountedStoragePacket(context.contraption.entity.m_19879_(), context.localPos, this.calculateFillLevel(), context.blockEntityData));
        this.initialized = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void markDirty() {
        FilterItemStack newFilter;
        this.dirty = true;
        if (this.currentContraption == null) {
            return;
        }
        ContraptionStorageFilters registry = ContraptionStorageFilters.getOrCreate(this.currentContraption);
        ItemStack candidate = ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_41619_() ? this.filterItem : ((ItemStackHandler)this.wrapped).getStackInSlot(0).m_255036_(1);
        FilterItemStack filterItemStack = newFilter = candidate.m_41619_() ? null : FilterItemStack.of((ItemStack)candidate);
        if (this.lastRegisteredFilter != null && newFilter != null && ItemStack.m_150942_((ItemStack)this.lastRegisteredFilter.item(), (ItemStack)newFilter.item())) {
            return;
        }
        if (this.lastRegisteredFilter != null) {
            registry.unregister(this);
        }
        if (newFilter != null) {
            registry.register((ContraptionStorageFilters.FilteredMountedStorage)this, this.filterItem);
        }
        this.lastRegisteredFilter = newFilter;
    }

    private CompoundTag migrateSlotItems(CompoundTag itemsTag, int oldSize) {
        ItemStackHandler oldHandler = this.createItemHandler(oldSize);
        ItemStackHandler newHandler = this.createItemHandler(SimpleStorageBoxEntity.SLOT_COUNT);
        oldHandler.deserializeNBT(itemsTag);
        ItemStack slot0 = oldHandler.getStackInSlot(0);
        ItemStack slot1 = oldHandler.getStackInSlot(1);
        if (!slot0.m_41619_() || !slot1.m_41619_()) {
            ItemStack merged = slot0.m_41777_();
            int totalCount = slot0.m_41613_() + slot1.m_41613_();
            merged.m_41764_(Math.min(totalCount, this.getMaxItemCapacity()));
            newHandler.setStackInSlot(0, merged);
        }
        newHandler.setStackInSlot(1, oldHandler.getStackInSlot(3).m_41777_());
        for (int oldSlot = 4; oldSlot <= 12; ++oldSlot) {
            int newSlot = oldSlot - 4 + 2;
            if (newSlot >= newHandler.getSlots()) continue;
            newHandler.setStackInSlot(newSlot, oldHandler.getStackInSlot(oldSlot).m_41777_());
        }
        return newHandler.serializeNBT();
    }

    private ItemStackHandler createItemHandler(int slotCount) {
        return new ItemStackHandler(slotCount){

            public CompoundTag serializeNBT() {
                ListTag nbtTagList = new ListTag();
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.m_128405_("Slot", i);
                    itemTag.m_128405_("ActualCount", ((ItemStack)this.stacks.get(i)).m_41613_());
                    ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
                    nbtTagList.add((Object)itemTag);
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Items", (Tag)nbtTagList);
                nbt.m_128405_("Size", this.stacks.size());
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
                ListTag tagList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.m_128728_(i);
                    int slot = itemTags.m_128451_("Slot");
                    ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
                    if (itemTags.m_128425_("ActualCount", 3)) {
                        slotStack.m_41764_(itemTags.m_128451_("ActualCount"));
                    }
                    this.stacks.set(slot, (Object)slotStack);
                }
                this.onLoad();
            }
        };
    }

    private static /* synthetic */ AbstractContainerMenu lambda$createMenu$4(Container wrapper, int contraptionId, BlockPos localPos, CompoundTag nbt, int id, Inventory inv, Player player) {
        return new SimpleStorageBoxMountedMenu(id, inv, wrapper, contraptionId, localPos, nbt);
    }
}

