/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.backpack.util.BackpackNetworkHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedMenu;
import net.fxnt.fxntstorage.container.util.StorageBoxNetworkHelper;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fxntstorage", value={Dist.CLIENT})
public class ClientEventHandler {
    private static double lastforwardImpulse = -99.0;
    private static double lastleftImpulse = -99.0;

    @SubscribeEvent
    public static void onMovementInputUpdate(MovementInputUpdateEvent event) {
        Vec2 movement = event.getInput().m_108575_();
        float forwardImpulse = movement.f_82471_;
        float leftImpulse = movement.f_82470_;
        Player player = event.getEntity();
        if ((double)forwardImpulse != lastforwardImpulse || (double)leftImpulse != lastleftImpulse) {
            ModNetwork.sendToServer(new PlayerInputPacket(forwardImpulse, -leftImpulse));
            JetpackManager.getJetpackHandler(player).processPlayerInputPacket(forwardImpulse, -leftImpulse);
            lastforwardImpulse = forwardImpulse;
            lastleftImpulse = leftImpulse;
        }
    }

    @SubscribeEvent
    public static void onMiddleClickBlock(InputEvent.MouseButton.Pre event) {
        if (event.getButton() != 2) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_7500_() || player.m_5833_() || !player.m_9236_().f_46443_ || !player.m_6084_() || player.m_5803_() || player.m_21224_() || event.getAction() != 1) {
            return;
        }
        if (mc.f_91080_ != null) {
            return;
        }
        if (!BackpackHelper.isWearingBackpack((Player)player)) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)hitResult).m_82425_();
            BlockState state = player.m_9236_().m_8055_(blockPos);
            ItemStack stack = state.getCloneItemStack(hitResult, (BlockGetter)player.m_9236_(), blockPos, (Player)player);
            BackpackNetworkHelper.doPickBlock(stack);
        }
    }

    @SubscribeEvent
    public static void onMiddleClickSort(InputEvent.MouseButton event) {
        block9: {
            AbstractContainerMenu menu;
            AbstractContainerScreen containerScreen;
            LocalPlayer player;
            block11: {
                block10: {
                    if (event.getButton() != 2) {
                        return;
                    }
                    Minecraft mc = Minecraft.m_91087_();
                    player = mc.f_91074_;
                    if (player == null || player.m_5833_() || !player.m_9236_().f_46443_ || !player.m_6084_() || player.m_5803_() || player.m_21224_()) {
                        return;
                    }
                    if (event.getAction() != 1 || !(player.f_36096_ instanceof BackpackMenu) && !(player.f_36096_ instanceof StorageBoxMenu) && !(player.f_36096_ instanceof StorageBoxMountedMenu)) break block9;
                    event.setCanceled(true);
                    Screen screen = mc.f_91080_;
                    if (!(screen instanceof AbstractContainerScreen)) break block10;
                    containerScreen = (AbstractContainerScreen)screen;
                    if (!(screen instanceof CreativeModeInventoryScreen)) break block11;
                }
                return;
            }
            Slot slot = containerScreen.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof BackpackMenu) {
                menu = (BackpackMenu)abstractContainerMenu;
                BackpackNetworkHelper.sortBackpack(slot.f_40219_, menu.getSortOrder());
            }
            if ((abstractContainerMenu = player.f_36096_) instanceof StorageBoxMenu) {
                menu = (StorageBoxMenu)abstractContainerMenu;
                StorageBoxNetworkHelper.sortStorageBox(slot.f_40219_, menu.getContainerSize(), menu.getSortOrder());
            }
            if ((abstractContainerMenu = player.f_36096_) instanceof StorageBoxMountedMenu) {
                menu = (StorageBoxMountedMenu)abstractContainerMenu;
                StorageBoxNetworkHelper.sortStorageBox(slot.f_40219_, menu.getContainerSize(), menu.getSortOrder());
            }
        }
    }

    @SubscribeEvent
    public static void onServerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            ConfigManager.ClientConfig.sendSettings((Player)player);
            JetpackManager.addPlayer((Player)player);
        }
    }

    @SubscribeEvent
    public static void onClientRespawn(ClientPlayerNetworkEvent.Clone event) {
        JetpackManager.addPlayer((Player)event.getNewPlayer());
    }
}

