/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import net.fxnt.fxntstorage.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;

public class RendererHelper {
    public static final int MAX_DISTANCE = 10;
    public static final int DEFAULT_LIGHT = 250;
    public static final float[] SIDE_ROT_Y = new float[]{0.0f, 0.0f, (float)Math.PI, 0.0f, 4.712389f, 1.5707964f};

    public static void renderLine(String text, float yOffset, PoseStack poseStack, MultiBufferSource buffer, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        float zOffset = 15.05f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, yOffset / 16.0f, zOffset / 16.0f);
        poseStack.m_85841_(0.015625f, -0.015625f, 1.0f);
        float x = (float)(-font.m_92895_(text)) / 2.0f;
        font.m_271703_(text, x, 0.0f, color, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 250);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemRenderer itemRenderer, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, boolean voidUpgrade) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.175f, 0.940625f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        boolean flatItem = !model.m_7539_();
        float scale = (flatItem ? 0.25f : 0.5f) + 0.01f;
        float zOffset = (flatItem ? -0.025f : 0.068f) + RendererHelper.customZOffset(stack.m_41720_());
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(0.0f, 0.0f, zOffset);
        itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, 250, OverlayTexture.f_118083_, poseStack, buffer, (Level)level, 0);
        poseStack.m_85849_();
        if (voidUpgrade) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.5f, 0.940625f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_252880_(-0.3f, -0.2f, 0.0f);
            scale = 0.265625f;
            poseStack.m_85841_(scale, scale, scale);
            ItemStack icon = new ItemStack((ItemLike)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
            itemRenderer.m_269128_(icon, ItemDisplayContext.FIXED, 250, OverlayTexture.f_118083_, poseStack, buffer, (Level)level, 0);
            poseStack.m_85849_();
        }
    }

    public static int getColorForDistance(double distance) {
        int START = 255;
        int END = 50;
        double MAX_DISTANCE = 10.0;
        double clamped = Math.min(distance, 10.0);
        double factor = clamped / 10.0;
        int val = (int)(255.0 + -205.0 * factor);
        return val << 16 | val << 8 | val;
    }

    private static float customZOffset(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).m_40614_()) instanceof AbstractSimpleShaftBlock || block instanceof FenceBlock || block.m_49966_().m_204336_(BlockTags.f_13093_) || block == Blocks.f_50489_)) {
            return -0.1f;
        }
        return 0.0f;
    }
}

