/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import java.util.List;
import java.util.Objects;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class Util {
    public static final int SLOTS_PER_ROW = 12;
    public static final int CARDBOARD_STORAGE_BOX_SIZE = 48;
    public static final int IRON_STORAGE_BOX_SIZE = 60;
    public static final int ANDESITE_STORAGE_BOX_SIZE = 84;
    public static final int COPPER_STORAGE_BOX_SIZE = 108;
    public static final int BRASS_STORAGE_BOX_SIZE = 132;
    public static final int HARDENED_STORAGE_BOX_SIZE = 156;
    public static final int IRON_BACKPACK_STACK_MULTIPLIER = 2;
    public static final int ANDESITE_BACKPACK_STACK_MULTIPLIER = 4;
    public static final int COPPER_BACKPACK_STACK_MULTIPLIER = 8;
    public static final int BRASS_BACKPACK_STACK_MULTIPLIER = 16;
    public static final int HARDENED_BACKPACK_STACK_MULTIPLIER = 32;
    public static final String BLANK_UPGRADE = "backpack_blank_upgrade";
    public static final String STORAGE_BOX_VOID_UPGRADE = "storage_box_void_upgrade";
    public static final String STORAGE_BOX_CAPACITY_UPGRADE = "storage_box_capacity_upgrade";
    public static final String MAGNET_UPGRADE = "backpack_magnet_upgrade";
    public static final String MAGNET_UPGRADE_DEACTIVATED = "backpack_magnet_upgrade_deactivated";
    public static final String PICKBLOCK_UPGRADE = "backpack_pickblock_upgrade";
    public static final String PICKBLOCK_UPGRADE_DEACTIVATED = "backpack_pickblock_upgrade_deactivated";
    public static final String ITEMPICKUP_UPGRADE = "backpack_itempickup_upgrade";
    public static final String ITEMPICKUP_UPGRADE_DEACTIVATED = "backpack_itempickup_upgrade_deactivated";
    public static final String FLIGHT_UPGRADE = "backpack_flight_upgrade";
    public static final String FLIGHT_UPGRADE_DEACTIVATED = "backpack_flight_upgrade_deactivated";
    public static final String REFILL_UPGRADE = "backpack_refill_upgrade";
    public static final String REFILL_UPGRADE_DEACTIVATED = "backpack_refill_upgrade_deactivated";
    public static final String FEEDER_UPGRADE = "backpack_feeder_upgrade";
    public static final String FEEDER_UPGRADE_DEACTIVATED = "backpack_feeder_upgrade_deactivated";
    public static final String TOOLSWAP_UPGRADE = "backpack_toolswap_upgrade";
    public static final String TOOLSWAP_UPGRADE_DEACTIVATED = "backpack_toolswap_upgrade_deactivated";
    public static final String FALLDAMAGE_UPGRADE = "backpack_falldamage_upgrade";
    public static final String FALLDAMAGE_UPGRADE_DEACTIVATED = "backpack_falldamage_upgrade_deactivated";
    public static final String OREMINING_UPGRADE = "backpack_oremining_upgrade";
    public static final String OREMINING_UPGRADE_DEACTIVATED = "backpack_oremining_upgrade_deactivated";
    public static final String TORCHDEPLOYER_UPGRADE = "backpack_torchdeployer_upgrade";
    public static final String TORCHDEPLOYER_UPGRADE_DEACTIVATED = "backpack_torchdeployer_upgrade_deactivated";
    public static final byte BACKPACK_ON_BACK = 1;
    public static final byte BACKPACK_IN_HAND = 2;
    public static final byte BACKPACK_AS_BLOCK = 3;
    public static final int ITEM_SLOT_START_RANGE = 0;
    public static final int ITEM_SLOT_END_RANGE;
    public static final int TOOL_SLOT_START_RANGE;
    public static final int TOOL_SLOT_END_RANGE;
    public static final int UPGRADE_SLOT_START_RANGE;
    public static final int UPGRADE_SLOT_END_RANGE;
    public static final int SLOT_SIZE = 18;
    public static final int CONTAINER_HEADER_HEIGHT = 17;
    public static final byte JETPACK_KEY_PRESS = 0;
    public static final byte JETPACK_KEY_RELEASE = 1;
    public static final byte OPEN_BACKPACK = 2;
    public static final byte CLOSE_BACKPACK = 3;
    public static final byte BACKPACK_MENU_CTRL = 4;
    public static final byte TOGGLE_HOVER = 5;
    public static final byte MINE_ALL_BLOCKS = 6;
    public static final byte INV_TYPE_BACKPACK = 0;
    public static final byte INV_TYPE_STORAGE_BOX = 1;

    public static String formatNumber(int number) {
        if (number < 10000) {
            return String.valueOf(number);
        }
        if (number < 1000000) {
            return number % 1000 == 0 ? String.format("%dk", number / 1000) : String.format("%.1fk", (double)number / 1000.0);
        }
        return number % 1000000 == 0 ? String.format("%dM", number / 1000000) : String.format("%.2fM", (double)number / 1000000.0);
    }

    public static boolean isVowel(char c) {
        return "AEIOUaeiou".indexOf(c) != -1;
    }

    public static CompoundTag getOrCreateSubTag(CompoundTag root, String key) {
        if (!root.m_128425_(key, 10)) {
            root.m_128365_(key, (Tag)new CompoundTag());
        }
        return root.m_128469_(key);
    }

    public static <T> boolean isSymmetrical(int width, int height, List<T> list) {
        if (width != 1) {
            int i = width / 2;
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < i; ++k) {
                    T t1;
                    int l = width - 1 - k;
                    T t = list.get(k + j * width);
                    if (t.equals(t1 = list.get(l + j * width))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        TOOL_SLOT_START_RANGE = ITEM_SLOT_END_RANGE = BackpackBlock.getItemSlotCount();
        UPGRADE_SLOT_START_RANGE = TOOL_SLOT_END_RANGE = TOOL_SLOT_START_RANGE + BackpackBlock.getToolSlotCount();
        UPGRADE_SLOT_END_RANGE = UPGRADE_SLOT_START_RANGE + BackpackBlock.getUpgradeSlotCount();
    }

    public record ItemWithNBT(Item item, CompoundTag tag) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ItemWithNBT that = (ItemWithNBT)obj;
            return this.item == that.item && Objects.equals(this.tag, that.tag);
        }

        public Component getDisplayName() {
            String jsonName;
            MutableComponent parsed;
            CompoundTag display;
            if (this.tag != null && this.tag.m_128425_("display", 10) && (display = this.tag.m_128469_("display")).m_128425_("Name", 8) && (parsed = Component.Serializer.m_130701_((String)(jsonName = display.m_128461_("Name")))) != null) {
                return parsed;
            }
            return Component.m_237119_();
        }

        public String getDisplayNameString() {
            return this.getDisplayName().getString();
        }
    }
}

