/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage;

import com.simibubi.create.foundation.data.CreateRegistrate;
import java.util.Objects;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackScreen;
import net.fxnt.fxntstorage.backpack.renderer.BackpackRenderPlayer;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackClientTooltip;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackAirOverlay;
import net.fxnt.fxntstorage.compat.CuriosCompat;
import net.fxnt.fxntstorage.compat.constructionstick.ConstructionStickCompat;
import net.fxnt.fxntstorage.compat.everycomp.EveryCompCompat;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBoxEntityRenderer;
import net.fxnt.fxntstorage.container.StorageBoxScreen;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedScreen;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModLootConditionTypes;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.init.ModRecipes;
import net.fxnt.fxntstorage.init.ModTabs;
import net.fxnt.fxntstorage.init.ModUnpackers;
import net.fxnt.fxntstorage.network.PacketHandler;
import net.fxnt.fxntstorage.passer.PasserEntityRenderer;
import net.fxnt.fxntstorage.ponder.CsPonderPlugin;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntityRenderer;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxScreen;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedScreen;
import net.fxnt.fxntstorage.util.KeybindHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fxntstorage")
public class FXNTStorage {
    public static final String MOD_ID = "fxntstorage";
    public static final Logger LOGGER = LogManager.getLogger(FXNTStorage.class);
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"fxntstorage").defaultCreativeTab((ResourceKey)null);
    public static boolean curiosLoaded;

    public FXNTStorage(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.ClientConfig.CLIENT_SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigManager.CommonConfig.COMMON_SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(FXNTStorage::registerTooltipComponent);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.register((Object)new PacketHandler());
        ModBlocks.register();
        ModBlockEntities.register();
        ModItems.register();
        ModTabs.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModLootConditionTypes.register(modEventBus);
        REGISTRATE.registerEventListeners(modEventBus);
        curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            FXNTStorage.loadCuriosCompat(modEventBus);
        }
        if (ModList.get().isLoaded("constructionstick")) {
            ConstructionStickCompat.init();
        }
        if (ModList.get().isLoaded("everycomp")) {
            EveryCompCompat.init();
        }
    }

    private static void loadCuriosCompat(IEventBus bus) {
        NeoForge.EVENT_BUS.addListener(CuriosCompat::keepBackpack);
        bus.addListener(CuriosCompat::registerCapabilities);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModUnpackers::registerHandlers);
    }

    private static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltip.class, BackpackClientTooltip::new);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get(), (e, d) -> e.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get(), (e, d) -> e.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.BACKPACK_ENTITY.get(), (e, d) -> e.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.STORAGE_CONTROLLER_ENTITY.get(), (e, d) -> e.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.STORAGE_INTERFACE_ENTITY.get(), (e, d) -> e.getItemHandler());
        event.registerItem(Capabilities.ItemHandler.ITEM, (itemStack, context) -> new BackpackContainer((ItemStack)itemStack, null).getItemHandler(), new ItemLike[]{(ItemLike)ModBlocks.BACKPACK.get(), (ItemLike)ModBlocks.ANDESITE_BACKPACK.get(), (ItemLike)ModBlocks.COPPER_BACKPACK.get(), (ItemLike)ModBlocks.BRASS_BACKPACK.get(), (ItemLike)ModBlocks.HARDENED_BACKPACK.get()});
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @EventBusSubscriber(modid="fxntstorage", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            if (Objects.equals(event.getConfig().getModId(), FXNTStorage.MOD_ID) && event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT) && Minecraft.getInstance().getConnection() != null && Minecraft.getInstance().player != null) {
                ConfigManager.ClientConfig.sendSettings((Player)Minecraft.getInstance().player);
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            PonderIndex.addPlugin((PonderPlugin)new CsPonderPlugin());
        }

        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            ClientModEvents.addPlayerLayer(event, PlayerSkin.Model.WIDE);
            ClientModEvents.addPlayerLayer(event, PlayerSkin.Model.SLIM);
        }

        private static void addPlayerLayer(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skinType) {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skinType);
            if (playerRenderer != null) {
                playerRenderer.addLayer((RenderLayer)new BackpackRenderPlayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer));
            }
        }

        @SubscribeEvent
        public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get(), StorageBoxEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get(), SimpleStorageBoxEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SMART_PASSER_ENTITY.get(), PasserEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MENU.get(), SimpleStorageBoxScreen::createScreen);
            event.register((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MOUNTED_MENU.get(), SimpleStorageBoxMountedScreen::createScreen);
            event.register((MenuType)ModMenuTypes.STORAGE_BOX_MENU.get(), StorageBoxScreen::createScreen);
            event.register((MenuType)ModMenuTypes.STORAGE_BOX_MOUNTED_MENU.get(), StorageBoxMountedScreen::createScreen);
            event.register((MenuType)ModMenuTypes.BACKPACK_ITEM_MENU.get(), BackpackScreen::new);
            event.register((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), BackpackScreen::new);
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeybindHandler.TOGGLE_BACKPACK_KEY);
            event.register(KeybindHandler.TOGGLE_JETPACK_HOVER_KEY);
            event.register(KeybindHandler.CLEAR_BACKPACK_SHAPE_CACHE);
            event.register(KeybindHandler.OREMINE_ANY_BLOCK);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerAbove(VanillaGuiLayers.AIR_LEVEL, ResourceLocation.fromNamespaceAndPath((String)FXNTStorage.MOD_ID, (String)"remaining_air"), (LayeredDraw.Layer)JetpackAirOverlay.INSTANCE);
        }
    }

    @EventBusSubscriber(modid="fxntstorage")
    public static class ModEvents {
        @SubscribeEvent
        public static void register(RegisterEvent event) {
            event.register(BuiltInRegistries.RECIPE_SERIALIZER.key(), ModRecipes::register);
        }
    }
}

