/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackBlockMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackAsBlockUpgradeHandler;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BackpackEntity
extends BlockEntity
implements IBackpackContainer,
MenuProvider,
Nameable {
    private int slotCount;
    private final BlockPos pos;
    private int lastTick = 0;
    private boolean doTick = false;
    private Component customName;
    private boolean initializedBlock = false;
    private boolean isGhostSlotLocked = false;
    private final Block block;
    public int stackMultiplier;
    private SortOrder sortOrder;
    public NonNullList<String> upgrades = NonNullList.create();
    public boolean isPlayerInteraction = false;
    private final ItemStackHandler itemHandler;
    private final int GHOST_SLOT;

    public BackpackEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.pos = pPos;
        this.block = pBlockState.getBlock();
        this.sortOrder = SortOrder.COUNT;
        Block block = this.block;
        if (block instanceof BackpackBlock) {
            BackpackBlock backpackBlock = (BackpackBlock)block;
            this.stackMultiplier = backpackBlock.getStackMultiplier();
            this.slotCount = BackpackBlock.getSlotCount();
        }
        this.itemHandler = this.createItemHandler();
        this.GHOST_SLOT = this.itemHandler.getSlots() - 1;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this.slotCount + 1){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (BackpackEntity.this.isPlayerInteraction || slot < Util.ITEM_SLOT_END_RANGE) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (BackpackEntity.filterTest(stack)) {
                    return false;
                }
                if (BackpackEntity.this.isPlayerInteraction) {
                    return true;
                }
                if (slot != BackpackEntity.this.GHOST_SLOT || !BackpackEntity.this.itemHandler.getStackInSlot(BackpackEntity.this.GHOST_SLOT).isEmpty() || BackpackEntity.this.isGhostSlotLocked) {
                    return false;
                }
                return BackpackEntity.this.hasEmptyOrNonMaxSlot(stack);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BackpackEntity.this.setChanged();
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<String> getUpgrades() {
        return this.upgrades;
    }

    public void setCustomName(Component hoverName) {
        this.customName = hoverName;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @NotNull
    public Component getName() {
        return this.getDisplayName();
    }

    @NotNull
    public Component getDisplayName() {
        if (this.customName != null) {
            return this.customName;
        }
        Level blockLevel = this.level;
        if (blockLevel != null) {
            return this.block.getCloneItemStack((LevelReader)this.level, this.pos, this.getBlockState()).getHoverName();
        }
        return new ItemStack((ItemLike)ModBlocks.BACKPACK.get()).getHoverName();
    }

    public void setData(int slotCount, int stackMultiplier) {
        this.slotCount = slotCount;
        this.stackMultiplier = stackMultiplier;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        if (this.level != null && this.level.isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSortOrderPacket(sortOrder), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setChanged();
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    public void readInventory(ItemContainerContents contents) {
        List itemStacks = contents.stream().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemStacks.get(i));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        componentInput.get(ModDataComponents.BACKPACK_STACK_MULTIPLIER);
        componentInput.get(ModDataComponents.BACKPACK_UPGRADES);
        componentInput.getOrDefault(ModDataComponents.INVENTORY_SORT_ORDER, (Object)SortOrder.COUNT);
        this.readInventory((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ModDataComponents.BACKPACK_STACK_MULTIPLIER, (Object)this.stackMultiplier);
        components.set(ModDataComponents.BACKPACK_UPGRADES, this.upgrades);
        components.set(ModDataComponents.INVENTORY_SORT_ORDER, (Object)this.sortOrder);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getStacks()));
    }

    public ItemStack saveToItemStack(ItemStack stack) {
        stack.set(ModDataComponents.BACKPACK_STACK_MULTIPLIER, (Object)this.stackMultiplier);
        stack.set(ModDataComponents.BACKPACK_UPGRADES, this.upgrades);
        stack.set(ModDataComponents.INVENTORY_SORT_ORDER, (Object)this.sortOrder);
        stack.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getStacks()));
        return stack;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        ListTag upgradesList = new ListTag();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            upgradesList.add(i, (Tag)StringTag.valueOf((String)((String)this.upgrades.get(i))));
        }
        tag.put("Upgrades", (Tag)upgradesList);
        tag.putInt("StackMultiplier", this.stackMultiplier);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        tag.putString("SortOrder", this.sortOrder.name());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("Items"));
        if (tag.contains("Upgrades")) {
            this.upgrades.clear();
            ListTag upgradesList = tag.getList("Upgrades", 8);
            for (int i = 0; i < upgradesList.size(); ++i) {
                this.upgrades.add(i, (Object)upgradesList.getString(i));
            }
        }
        int n = this.stackMultiplier = tag.contains("StackMultiplier") ? tag.getInt("StackMultiplier") : this.stackMultiplier;
        if (tag.contains("CustomName", 8)) {
            this.customName = BackpackEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        this.sortOrder = tag.contains("SortOrder", 8) ? SortOrder.valueOf(tag.getString("SortOrder")) : SortOrder.COUNT;
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.getItem();
            if (!(item instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)item).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putString("SortOrder", this.sortOrder.name());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.itemHandler.deserializeNBT(lookupProvider, tag.getCompound("Items"));
        if (tag.contains("SortOrder", 8)) {
            this.sortOrder = SortOrder.valueOf(tag.getString("SortOrder"));
        }
    }

    private boolean hasEmptyOrNonMaxSlot(ItemStack pStack) {
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)pStack) || stack.getCount() >= this.stackMultiplier * pStack.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    public static boolean filterTest(ItemStack stack) {
        return stack.getItem() instanceof BackpackItem;
    }

    public void serverTick(Level level) {
        if (!level.isClientSide) {
            this.moveItems();
            ++this.lastTick;
            int updateEveryXTicks = 30;
            if (this.lastTick >= updateEveryXTicks) {
                this.lastTick = 0;
                this.doTick = true;
            }
            if (!this.doTick) {
                return;
            }
            if (!this.initializedBlock) {
                level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                this.initializedBlock = true;
            }
            if (this.upgrades.contains((Object)"backpack_magnet_upgrade")) {
                BackpackAsBlockUpgradeHandler upgradeHandler = new BackpackAsBlockUpgradeHandler(this);
                upgradeHandler.applyMagnetUpgrade();
            }
            this.doTick = false;
        }
    }

    public void moveItems() {
        ItemStack ghostSlot = this.itemHandler.getStackInSlot(this.GHOST_SLOT);
        if (ghostSlot.isEmpty()) {
            return;
        }
        this.isGhostSlotLocked = true;
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack mergeSlot = this.itemHandler.getStackInSlot(i);
            if (mergeSlot.isEmpty()) {
                this.doMove(i, mergeSlot, ghostSlot);
                break;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)mergeSlot, (ItemStack)ghostSlot) || mergeSlot.getCount() >= this.stackMultiplier * ghostSlot.getMaxStackSize()) continue;
            this.doMove(i, mergeSlot, ghostSlot);
            break;
        }
    }

    private void doMove(int mergeSlotId, ItemStack mergeStack, ItemStack ghostStack) {
        if (mergeStack.isEmpty()) {
            this.itemHandler.setStackInSlot(mergeSlotId, ghostStack.copy());
            ghostStack.shrink(ghostStack.getCount());
        } else {
            int mergeSlotFreeSpace = this.stackMultiplier * mergeStack.getMaxStackSize() - mergeStack.getCount();
            int amountToMove = Math.min(ghostStack.getCount(), mergeSlotFreeSpace);
            mergeStack.grow(amountToMove);
            ghostStack.shrink(amountToMove);
        }
        this.setChanged();
        this.isGhostSlotLocked = false;
    }

    @Override
    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    @Override
    public void setPlayerInteraction(boolean isPlayer) {
        this.isPlayerInteraction = isPlayer;
    }

    @Override
    public void setDataChanged() {
        this.setChanged();
    }

    public void setChanged() {
        this.refreshUpgrades();
        super.setChanged();
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int calcRedstoneFromInventory() {
        int itemsFound = 0;
        float proportion = 0.0f;
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            proportion += (float)itemstack.getCount() / (float)(itemstack.getMaxStackSize() * this.stackMultiplier);
            ++itemsFound;
        }
        return Mth.floor((float)((proportion /= (float)Util.ITEM_SLOT_END_RANGE) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraData.writeBlockPos(this.pos);
        return new BackpackBlockMenu(i, inventory, extraData);
    }
}

