/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackSlot;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.main.ToolSlot;
import net.fxnt.fxntstorage.backpack.main.UpgradeSlot;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
@ParametersAreNonnullByDefault
public class BackpackMenu
extends AbstractContainerMenu {
    public IBackpackContainer container;
    public final Player player;
    public byte backpackType;
    public final int ITEM_SLOT_COUNT = BackpackBlock.getItemSlotCount();
    public final int TOOL_SLOT_COUNT = BackpackBlock.getToolSlotCount();
    public final int UPGRADE_SLOT_COUNT = BackpackBlock.getUpgradeSlotCount();
    public final int TOTAL_SLOT_COUNT = this.ITEM_SLOT_COUNT + this.TOOL_SLOT_COUNT + this.UPGRADE_SLOT_COUNT;
    public boolean ctrlKeyDown = false;

    public BackpackMenu(MenuType<?> type, int containerId, Inventory playerInventory, IBackpackContainer container, byte backpackType) {
        super(type, containerId);
        this.player = playerInventory.player;
        this.backpackType = backpackType;
        this.container = container;
        this.initSlots();
    }

    public void initSlots() {
        int i;
        Inventory playerInventory = this.player.getInventory();
        final IBackpackContainer finalContainer = this.container;
        ItemStackHandler itemHandler = this.container.getItemHandler();
        int index = 0;
        for (i = 0; i < this.ITEM_SLOT_COUNT; ++i) {
            this.addSlot((Slot)new BackpackSlot(this, (IItemHandler)itemHandler, index, index * 18, 0){

                public boolean mayPlace(ItemStack pStack) {
                    if (pStack.getItem() instanceof BackpackItem) {
                        return false;
                    }
                    return super.mayPlace(pStack);
                }

                public int getMaxStackSize() {
                    return finalContainer.getStackMultiplier() * 64;
                }

                public int getMaxStackSize(ItemStack stack) {
                    return Math.max(finalContainer.getStackMultiplier() * stack.getMaxStackSize(), stack.getMaxStackSize());
                }

                public void setChanged() {
                    super.setChanged();
                    finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        for (i = 0; i < this.TOOL_SLOT_COUNT; ++i) {
            this.addSlot((Slot)new ToolSlot(this, (IItemHandler)itemHandler, index, index * 18, 0){

                public boolean mayPlace(ItemStack pStack) {
                    if (pStack.getItem() instanceof BackpackItem) {
                        return false;
                    }
                    return super.mayPlace(pStack);
                }

                public void onTake(Player pPlayer, ItemStack pStack) {
                    super.onTake(pPlayer, pStack);
                }

                public int getMaxStackSize(ItemStack stack) {
                    return Math.min(super.getMaxStackSize(stack), stack.getMaxStackSize());
                }

                public void setChanged() {
                    super.setChanged();
                    finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        for (i = 0; i < this.UPGRADE_SLOT_COUNT; ++i) {
            this.addSlot((Slot)new UpgradeSlot((IItemHandler)itemHandler, index, index * 18, 0, (IItemHandler)itemHandler, finalContainer){
                final /* synthetic */ IItemHandler val$itemHandler;
                final /* synthetic */ IBackpackContainer val$finalContainer;
                {
                    this.val$itemHandler = iItemHandler;
                    this.val$finalContainer = iBackpackContainer;
                    super(arg0, arg1, arg2, arg3);
                }

                @Override
                public boolean mayPlace(ItemStack pStack) {
                    if (pStack.is(ModTags.Items.BACKPACK_UPGRADE)) {
                        UpgradeItem item = (UpgradeItem)pStack.getItem();
                        return BackpackMenu.this.isUniqueUpgrade(this.val$itemHandler, item);
                    }
                    return false;
                }

                public void setChanged() {
                    super.setChanged();
                    this.val$finalContainer.setDataChanged();
                }
            });
            ++index;
        }
        int yOffset = 0;
        int xOffset = 61;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset += 58;
        for (int i2 = 0; i2 < 9; ++i2) {
            this.addSlot(new Slot((Container)playerInventory, i2, xOffset + i2 * 18, yOffset));
        }
    }

    public boolean stillValid(Player player) {
        IBackpackContainer iBackpackContainer;
        if (this.backpackType == 2) {
            ItemStack selectedStack = player.getInventory().getSelected();
            return selectedStack.getItem() instanceof BackpackItem;
        }
        if (this.backpackType == 1) {
            return BackpackHelper.isWearingBackpack(player);
        }
        if (this.backpackType == 3 && (iBackpackContainer = this.container) instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iBackpackContainer;
            return !be.isRemoved() && Container.stillValidBlockEntity((BlockEntity)be, (Player)player, (float)0.0f);
        }
        return false;
    }

    private boolean isUniqueUpgrade(IItemHandler itemHandler, Item upgradeItem) {
        for (int i = Util.UPGRADE_SLOT_START_RANGE; i < Util.UPGRADE_SLOT_END_RANGE; ++i) {
            if (itemHandler.getStackInSlot(i).getItem() != upgradeItem) continue;
            return false;
        }
        return true;
    }

    public SortOrder getSortOrder() {
        return this.container.getSortOrder();
    }

    public void setSortOrder(SortOrder order) {
        this.container.setSortOrder(order);
    }

    public int getSlotsSize() {
        return this.slots.size();
    }

    @NotNull
    public Slot getSlot(int slotIndex) {
        return (Slot)this.slots.get(slotIndex);
    }

    public Slot getPlayerSlot(int slotIndex) {
        return (Slot)this.slots.get(this.getSlotsSize() - 36 + slotIndex);
    }

    public Slot getHotbarSlot(int slotIndex) {
        return (Slot)this.slots.get(this.getSlotsSize() - 36 + 27 + slotIndex);
    }

    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 0 && this.backpackType == 2) {
            int selectedHotBarSlot = pPlayer.getInventory().selected;
            ItemStack selectedStack = pPlayer.getInventory().getSelected();
            if (pSlotId == this.getSlotsSize() - 36 + 27 + selectedHotBarSlot && selectedStack.getItem() instanceof BackpackItem) {
                return;
            }
        }
        if (pSlotId >= Util.UPGRADE_SLOT_START_RANGE && pSlotId < Util.UPGRADE_SLOT_END_RANGE) {
            this.toggleUpgrade(pSlotId, this.ctrlKeyDown);
            if (this.ctrlKeyDown) {
                return;
            }
            if (this.player.level().isClientSide && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341)) {
                return;
            }
        }
        this.container.setPlayerInteraction(true);
        if (pClickType == ClickType.PICKUP && pButton == 1 || pClickType == ClickType.QUICK_MOVE && pButton == 0) {
            ClickAction clickaction;
            ClickAction clickAction = clickaction = pButton == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            if (pSlotId == -999) {
                if (!this.getCarried().isEmpty()) {
                    this.player.drop(this.getCarried().split(1), true);
                }
            } else if (pClickType == ClickType.QUICK_MOVE) {
                if (pSlotId < 0) {
                    return;
                }
                slot = (Slot)this.slots.get(pSlotId);
                if (!slot.mayPickup(this.player)) {
                    return;
                }
                ItemStack stack2 = this.quickMoveStack(this.player, pSlotId);
                while (!stack2.isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)stack2)) {
                    stack2 = ItemStack.EMPTY;
                }
            } else {
                if (pSlotId < 0) {
                    return;
                }
                slot = (Slot)this.slots.get(pSlotId);
                ItemStack slotItem = slot.getItem();
                ItemStack carried = this.getCarried();
                this.player.updateTutorialInventoryAction(carried, slot.getItem(), clickaction);
                if (!super.tryItemClickBehaviourOverride(this.player, clickaction, slot, slotItem, carried)) {
                    if (slotItem.isEmpty()) {
                        if (!carried.isEmpty()) {
                            this.setCarried(slot.safeInsert(carried, 1));
                        }
                    } else if (slot.mayPickup(this.player)) {
                        if (carried.isEmpty()) {
                            Optional tryRemove = slot.tryRemove(slotItem.getCount() > slotItem.getMaxStackSize() ? (slotItem.getMaxStackSize() + 1) / 2 : (slotItem.getCount() + 1) / 2, Integer.MAX_VALUE, this.player);
                            tryRemove.ifPresent(stack -> {
                                this.setCarried((ItemStack)stack);
                                slot.onTake(this.player, stack);
                            });
                        } else if (slot.mayPlace(carried)) {
                            if (ItemStack.isSameItemSameComponents((ItemStack)slotItem, (ItemStack)carried)) {
                                this.setCarried(slot.safeInsert(carried, 1));
                            } else if (carried.getCount() <= slot.getMaxStackSize(carried)) {
                                this.setCarried(slotItem);
                                slot.setByPlayer(carried);
                            }
                        } else if (ItemStack.isSameItemSameComponents((ItemStack)slotItem, (ItemStack)carried)) {
                            Optional tryRemove = slot.tryRemove(slotItem.getCount(), carried.getMaxStackSize() - carried.getCount(), this.player);
                            tryRemove.ifPresent(stack -> {
                                carried.grow(stack.getCount());
                                slot.onTake(this.player, stack);
                            });
                        }
                    }
                }
                slot.setChanged();
            }
        } else {
            super.clicked(pSlotId, pButton, pClickType, pPlayer);
        }
        this.container.setPlayerInteraction(false);
    }

    private boolean isUpgradeItem(ItemStack itemStack) {
        return itemStack.is(ModTags.Items.BACKPACK_UPGRADE);
    }

    private boolean isToolItem(ItemStack itemStack) {
        return itemStack.is(Tags.Items.TOOLS) || itemStack.is(Items.WARPED_FUNGUS_ON_A_STICK) || itemStack.is(Items.CARROT_ON_A_STICK) || itemStack.is(Items.ELYTRA) || itemStack.is(AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag) || itemStack.is((Holder)AllItems.CARDBOARD_SWORD) || itemStack.is((Holder)AllItems.POTATO_CANNON);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotItem = slot.getItem();
        if (this.isUpgradeItem(slotItem)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetCarriedPacket(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (index > Util.UPGRADE_SLOT_END_RANGE) {
                for (int i = Util.UPGRADE_SLOT_START_RANGE; i < Util.UPGRADE_SLOT_END_RANGE; ++i) {
                    if (!((Slot)this.slots.get(i)).getItem().isEmpty()) continue;
                    ((Slot)this.slots.get(i)).safeInsert(slotItem);
                    return ItemStack.EMPTY;
                }
            } else {
                this.toggleUpgrade(index, false);
            }
        }
        if (this.isToolItem(slotItem) && index >= Util.UPGRADE_SLOT_END_RANGE) {
            Map<TagKey, Integer> toolSlotMap = Map.of(ItemTags.SWORDS, 0, ItemTags.PICKAXES, 1, ItemTags.AXES, 2, ItemTags.SHOVELS, 3, ItemTags.HOES, 4);
            for (Map.Entry<TagKey, Integer> entry : toolSlotMap.entrySet()) {
                int slotIndex;
                if (!slotItem.is(entry.getKey()) || !((Slot)this.slots.get(slotIndex = Util.TOOL_SLOT_START_RANGE + entry.getValue())).getItem().isEmpty()) continue;
                ((Slot)this.slots.get(slotIndex)).safeInsert(slotItem);
                return ItemStack.EMPTY;
            }
            for (int i = Util.TOOL_SLOT_START_RANGE + toolSlotMap.size(); i < Util.TOOL_SLOT_END_RANGE; ++i) {
                if (!((Slot)this.slots.get(i)).getItem().isEmpty()) continue;
                ((Slot)this.slots.get(i)).safeInsert(slotItem);
                return ItemStack.EMPTY;
            }
        }
        if (index >= 0 && index < this.slots.size()) {
            ItemStack itemStack = ItemStack.EMPTY;
            if (slot.hasItem()) {
                ItemStack itemStack2 = slot.getItem();
                itemStack = itemStack2.copy();
                if (index < Util.UPGRADE_SLOT_END_RANGE) {
                    if (!this.moveItemStack(itemStack2, Util.UPGRADE_SLOT_END_RANGE, Util.UPGRADE_SLOT_END_RANGE + 36, true)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    if (this.moveItemStack(itemStack2, 0, Util.ITEM_SLOT_END_RANGE, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (this.moveItemStack(itemStack2, Util.TOOL_SLOT_START_RANGE + 5, Util.TOOL_SLOT_END_RANGE, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (this.moveItemStack(itemStack2, Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE, false)) {
                        return ItemStack.EMPTY;
                    }
                }
                if (itemStack2.isEmpty()) {
                    slot.setByPlayer(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                if (itemStack2.getCount() == itemStack.getCount()) {
                    return ItemStack.EMPTY;
                }
                slot.onTake(player, itemStack2);
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    private boolean moveItemStack(ItemStack newStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!newStack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.getCount() + newStack.getCount();
                if (j <= (k = slot.getMaxStackSize(itemstack))) {
                    newStack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < k) {
                    newStack.shrink(k - itemstack.getCount());
                    itemstack.setCount(k);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        if (!newStack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(newStack)) {
                    int l = slot1.getMaxStackSize(newStack);
                    slot1.setByPlayer(newStack.split(Math.min(newStack.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    private void toggleUpgrade(int slotId, boolean ctrlKeyDown) {
        Item item;
        ItemStackHandler itemStackHandler = this.container.getItemHandler();
        ItemStack itemStack = itemStackHandler.getStackInSlot(slotId);
        if (itemStack.isEmpty()) {
            return;
        }
        if (itemStack.is(ModTags.Items.BACKPACK_UPGRADE) && (item = itemStack.getItem()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            String itemName = upgradeItem.getUpgradeName();
            String baseItemName = itemName.replace("backpack_", "").replace("_upgrade", "").replace("_deactivated", "");
            if (ctrlKeyDown) {
                if (itemName.contains("_deactivated")) {
                    itemStackHandler.setStackInSlot(slotId, this.getActivatedItem(baseItemName));
                } else {
                    itemStackHandler.setStackInSlot(slotId, this.getDeactivatedItem(baseItemName));
                }
                this.container.setDataChanged();
            } else if (itemName.contains("_deactivated")) {
                ItemStack stack = this.getActivatedItem(baseItemName);
                itemStackHandler.setStackInSlot(slotId, stack);
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetCarriedPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    private ItemStack getActivatedItem(String baseItemName) {
        return switch (baseItemName) {
            case "magnet" -> new ItemStack((ItemLike)ModItems.BACKPACK_MAGNET_UPGRADE.get());
            case "pickblock" -> new ItemStack((ItemLike)ModItems.BACKPACK_PICKBLOCK_UPGRADE.get());
            case "itempickup" -> new ItemStack((ItemLike)ModItems.BACKPACK_ITEMPICKUP_UPGRADE.get());
            case "flight" -> new ItemStack((ItemLike)ModItems.BACKPACK_FLIGHT_UPGRADE.get());
            case "refill" -> new ItemStack((ItemLike)ModItems.BACKPACK_REFILL_UPGRADE.get());
            case "feeder" -> new ItemStack((ItemLike)ModItems.BACKPACK_FEEDER_UPGRADE.get());
            case "toolswap" -> new ItemStack((ItemLike)ModItems.BACKPACK_TOOLSWAP_UPGRADE.get());
            case "falldamage" -> new ItemStack((ItemLike)ModItems.BACKPACK_FALLDAMAGE_UPGRADE.get());
            case "oremining" -> new ItemStack((ItemLike)ModItems.BACKPACK_OREMINING_UPGRADE.get());
            case "torchdeployer" -> new ItemStack((ItemLike)ModItems.BACKPACK_TORCHDEPLOYER_UPGRADE.get());
            default -> ItemStack.EMPTY;
        };
    }

    private ItemStack getDeactivatedItem(String baseItemName) {
        return switch (baseItemName) {
            case "magnet" -> new ItemStack((ItemLike)ModItems.BACKPACK_MAGNET_UPGRADE_DEACTIVATED.get());
            case "pickblock" -> new ItemStack((ItemLike)ModItems.BACKPACK_PICKBLOCK_UPGRADE_DEACTIVATED.get());
            case "itempickup" -> new ItemStack((ItemLike)ModItems.BACKPACK_ITEMPICKUP_UPGRADE_DEACTIVATED.get());
            case "flight" -> new ItemStack((ItemLike)ModItems.BACKPACK_FLIGHT_UPGRADE_DEACTIVATED.get());
            case "refill" -> new ItemStack((ItemLike)ModItems.BACKPACK_REFILL_UPGRADE_DEACTIVATED.get());
            case "feeder" -> new ItemStack((ItemLike)ModItems.BACKPACK_FEEDER_UPGRADE_DEACTIVATED.get());
            case "toolswap" -> new ItemStack((ItemLike)ModItems.BACKPACK_TOOLSWAP_UPGRADE_DEACTIVATED.get());
            case "falldamage" -> new ItemStack((ItemLike)ModItems.BACKPACK_FALLDAMAGE_UPGRADE_DEACTIVATED.get());
            case "oremining" -> new ItemStack((ItemLike)ModItems.BACKPACK_OREMINING_UPGRADE_DEACTIVATED.get());
            case "torchdeployer" -> new ItemStack((ItemLike)ModItems.BACKPACK_TORCHDEPLOYER_UPGRADE_DEACTIVATED.get());
            default -> ItemStack.EMPTY;
        };
    }

    public void sortBackpackItems(int startIndex, int endIndex, SortOrder sortOrder) {
        DataComponentPatch patch;
        int stackMultiplier = this.container.getStackMultiplier();
        ServerPlayer sp = (ServerPlayer)this.player;
        HashMap<Util.ItemWithComponent, Integer> itemCompMap = new HashMap<Util.ItemWithComponent, Integer>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = this.getSlot(i).getItem();
            if (stack.isEmpty()) continue;
            DataComponentPatch patch2 = stack.getComponentsPatch();
            Util.ItemWithComponent key = new Util.ItemWithComponent(stack.getItem(), patch2);
            itemCompMap.merge(key, stack.getCount(), Integer::sum);
        }
        ArrayList sortedItems = new ArrayList(itemCompMap.entrySet());
        switch (sortOrder) {
            case MOD: {
                sortedItems.sort(Comparator.comparing(entry -> BuiltInRegistries.ITEM.getKey((Object)((Util.ItemWithComponent)entry.getKey()).item()).toString()).thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).item().getName(new ItemStack((ItemLike)((Util.ItemWithComponent)entry.getKey()).item())).getString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            case NAME: {
                sortedItems.sort(Comparator.comparing(entry -> ((Util.ItemWithComponent)entry.getKey()).item().getName(new ItemStack((ItemLike)((Util.ItemWithComponent)entry.getKey()).item())).getString()).thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).getCustomName()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            default: {
                sortedItems.sort(Map.Entry.comparingByValue().reversed().thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).toString()));
            }
        }
        NonNullList compactedList = NonNullList.withSize((int)(endIndex - startIndex), (Object)ItemStack.EMPTY);
        if (startIndex == Util.TOOL_SLOT_START_RANGE && endIndex == Util.TOOL_SLOT_END_RANGE) {
            List<Class<HoeItem>> toolOrder = List.of(SwordItem.class, PickaxeItem.class, AxeItem.class, ShovelItem.class, HoeItem.class);
            for (int t = 0; t < toolOrder.size(); ++t) {
                Class<HoeItem> clazz = toolOrder.get(t);
                Map.Entry best = sortedItems.stream().filter(e -> toolClass.isInstance(((Util.ItemWithComponent)e.getKey()).item())).max(Comparator.comparingInt(e -> BackpackMenu.getVanillaTierIndex(new ItemStack((ItemLike)((Util.ItemWithComponent)e.getKey()).item())))).orElse(null);
                if (best == null) continue;
                Util.ItemWithComponent key = (Util.ItemWithComponent)best.getKey();
                patch = key.patch();
                ItemStack stack = new ItemStack((ItemLike)key.item(), 1);
                if (!patch.isEmpty()) {
                    stack.applyComponents(patch);
                }
                compactedList.set(t, (Object)stack);
                int remaining = (Integer)best.getValue() - 1;
                sortedItems.remove(best);
                if (remaining <= 0) continue;
                sortedItems.add(Map.entry(key, remaining));
            }
        }
        int idx = startIndex == Util.TOOL_SLOT_START_RANGE ? 5 : 0;
        for (Map.Entry entry2 : sortedItems) {
            int totalCount;
            int stackSize;
            int maxStackSize;
            Util.ItemWithComponent key = (Util.ItemWithComponent)entry2.getKey();
            Item item = key.item();
            patch = key.patch();
            ItemStack tempStack = new ItemStack((ItemLike)item, 1);
            int n = maxStackSize = endIndex == Util.ITEM_SLOT_END_RANGE ? stackMultiplier * tempStack.getMaxStackSize() : tempStack.getMaxStackSize();
            for (totalCount = ((Integer)entry2.getValue()).intValue(); totalCount > 0 && idx < compactedList.size(); totalCount -= stackSize) {
                stackSize = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (!patch.isEmpty()) {
                    stack.applyComponents(patch);
                }
                compactedList.set(idx++, (Object)stack);
            }
            if (totalCount <= 0 || startIndex != Util.TOOL_SLOT_START_RANGE) continue;
            for (int t = 0; t < 5 && totalCount > 0; ++t) {
                if (!((ItemStack)compactedList.get(t)).isEmpty()) continue;
                int stackSize2 = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize2);
                if (!patch.isEmpty()) {
                    stack.applyComponents(patch);
                }
                compactedList.set(t, (Object)stack);
                totalCount -= stackSize2;
            }
        }
        for (int i = 0; i < compactedList.size(); ++i) {
            ItemStack itemStack = (ItemStack)compactedList.get(i);
            Slot slot = this.player.containerMenu.getSlot(i + startIndex);
            slot.set(itemStack);
            if (startIndex < Util.UPGRADE_SLOT_END_RANGE) continue;
            sp.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.getStateId(), i + startIndex, itemStack));
        }
    }

    /*
     * Exception decompiling
     */
    public static int getVanillaTierIndex(ItemStack stack) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=12,1049
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

