/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.renderer.BackpackModelBase;
import net.fxnt.fxntstorage.backpack.renderer.BackpackModelPlayer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BackpackRenderPlayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final BackpackModelPlayer<AbstractClientPlayer> model;

    public BackpackRenderPlayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer) {
        super(pRenderer);
        ModelPart modelPart = BackpackModelBase.createModel(true).bakeRoot();
        this.model = new BackpackModelPlayer(modelPart);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull AbstractClientPlayer livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)livingEntity);
        if (backpack.isEmpty()) {
            return;
        }
        if (FXNTStorage.curiosLoaded) {
            boolean isBackpackVisible = BackpackHelper.isBackpackCuriosSlotVisible((Player)livingEntity);
            if (!(livingEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof BackpackItem) && !isBackpackVisible) {
                return;
            }
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.65f, -0.3f);
        poseStack.scale(0.85f, 0.85f, 0.85f);
        if (livingEntity.isCrouching()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-58.0f));
            poseStack.translate(0.0, 0.15, -0.1);
        }
        ((PlayerModel)this.getParentModel()).copyPropertiesTo(this.model);
        this.model.setupAnim((HumanoidModel<AbstractClientPlayer>)((HumanoidModel)this.getParentModel()));
        String backpackType = ResourceLocation.read((String)backpack.getItem().toString()).result().map(ResourceLocation::getPath).orElse("backpack");
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)("textures/block/" + backpackType + ".png"));
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)textureLocation));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

