/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.tooltip;

import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BackpackClientTooltip
implements ClientTooltipComponent {
    private static final int ICONS_PER_ROW = 9;
    private static final int ICON_SIZE = 18;
    private final BackpackTooltip component;
    private final int width;
    private final int height;

    public BackpackClientTooltip(BackpackTooltip tooltip) {
        this.component = tooltip;
        this.width = this.calculateWidth();
        this.height = this.calculateHeight();
    }

    private int calculateWidth() {
        Minecraft mc = Minecraft.getInstance();
        int upgradesWidth = this.component.upgrades.size() * 18;
        int contentsWidth = this.component.storage.stream().limit(9L).mapToInt(stack -> Math.max(this.getStackCountWidth(mc.font, (ItemStack)stack), 18)).sum();
        int tooltipTextWidth = this.component.tooltipText.stream().mapToInt(text -> mc.font.width(text.getVisualOrderText())).max().orElse(0);
        return Math.max(Math.max(upgradesWidth, contentsWidth), tooltipTextWidth);
    }

    private int calculateHeight() {
        int upgradesHeight = this.component.upgrades.isEmpty() ? 0 : 32;
        int storageRows = (this.component.storage.size() + 9 - 1) / 9;
        int inventoryHeight = this.component.storage.isEmpty() ? 0 : 12 + storageRows * 20;
        int textHeight = this.component.tooltipText.size() * 10;
        return Math.max(upgradesHeight + inventoryHeight + textHeight, 12);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth(@NotNull Font font) {
        return this.width;
    }

    public void renderImage(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
        for (Component line : this.component.tooltipText) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, line);
        }
        this.renderContents(pFont, pX, pY, pGuiGraphics);
    }

    private void renderContents(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        if (!this.component.upgrades.isEmpty()) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, (Component)Component.literal((String)"Upgrades:").withStyle(FontHelper.Palette.STANDARD_CREATE.highlight()));
            pY = this.renderItemList(pFont, pX, pY, pGuiGraphics, this.component.upgrades, false);
        }
        if (!this.component.storage.isEmpty()) {
            pY = this.renderTooltipText(pGuiGraphics, pX, pY, pFont, (Component)Component.literal((String)"Inventory:").withStyle(FontHelper.Palette.STANDARD_CREATE.highlight()));
            this.renderItemList(pFont, pX, pY, pGuiGraphics, this.component.storage, true);
        }
    }

    private int renderItemList(Font font, int xStart, int yStart, GuiGraphics guiGraphics, List<ItemStack> items, boolean multiline) {
        int x = xStart;
        int y = yStart;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (multiline && i > 0 && i % 9 == 0) {
                x = xStart;
                y += 20;
            }
            int stackWidth = Math.max(this.getStackCountWidth(font, stack), 18);
            int xOffset = stackWidth - 18;
            guiGraphics.renderItem(stack, x + xOffset, y);
            if (stack.getCount() > 1) {
                guiGraphics.renderItemDecorations(font, stack, x + xOffset, y, this.formatNumber(stack.getCount()));
            }
            x += multiline ? stackWidth : 18;
        }
        return multiline ? y + 20 : y + (items.isEmpty() ? 0 : 20);
    }

    private int getStackCountWidth(Font font, ItemStack stack) {
        return font.width(this.formatNumber(stack.getCount())) + 2;
    }

    private int renderTooltipText(GuiGraphics guiGraphics, int x, int y, Font font, Component tooltip) {
        guiGraphics.drawString(font, tooltip, x, y, 0xFFFFFF, true);
        return y + 10;
    }

    private String formatNumber(int number) {
        if (number < 1000) {
            return String.valueOf(number);
        }
        if (number < 1000000) {
            return String.format("%.1fk", (double)number / 1000.0);
        }
        return String.format("%.2fM", (double)number / 1000000.0);
    }
}

