/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.tooltip;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.container.StorageBoxItem;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;

public class BackpackTooltip
implements TooltipComponent {
    protected List<ItemStack> storage = new ArrayList<ItemStack>();
    protected List<ItemStack> upgrades = new ArrayList<ItemStack>();
    protected List<Component> tooltipText = new ArrayList<Component>();
    public final Item item;

    public BackpackTooltip(ItemStack stack) {
        this.item = stack.getItem();
        this.loadComponentData(stack);
    }

    private void loadComponentData(ItemStack stack) {
        if (stack.has(DataComponents.CONTAINER)) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            List contents = Optional.ofNullable((ItemContainerContents)stack.get(DataComponents.CONTAINER)).orElse(ItemContainerContents.EMPTY).stream().toList();
            for (ItemStack item : contents) {
                if (item.is(ModTags.Items.BACKPACK_UPGRADE) || item.is(ModTags.Items.STORAGE_BOX_UPGRADE)) continue;
                boolean merged = false;
                for (ItemStack existingStack : list) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)item)) continue;
                    existingStack.grow(item.getCount());
                    merged = true;
                    break;
                }
                if (merged || item.isEmpty()) continue;
                list.add(item);
            }
            list.sort((stack1, stack2) -> {
                int countCompare = Integer.compare(stack2.getCount(), stack1.getCount());
                if (countCompare != 0) {
                    return countCompare;
                }
                return stack1.getItem().toString().compareTo(stack2.getItem().toString());
            });
            this.storage = list;
            if (this.item instanceof SimpleStorageBoxItem) {
                ItemStack capUpgrades = new ItemStack((ItemLike)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get()).copyWithCount(0);
                for (int i = 1; i < contents.size(); ++i) {
                    if (((ItemStack)contents.get(i)).isEmpty()) continue;
                    if (i == 1) {
                        this.upgrades.add((ItemStack)contents.get(i));
                    }
                    if (i <= 1) continue;
                    capUpgrades.grow(1);
                }
                if (capUpgrades.getCount() > 0) {
                    this.upgrades.add(capUpgrades);
                }
            }
        }
        if (stack.has(ModDataComponents.BACKPACK_UPGRADES)) {
            List upgradeItems = Optional.ofNullable((List)stack.get(ModDataComponents.BACKPACK_UPGRADES)).orElse(List.of()).stream().toList();
            for (String upgrade : upgradeItems) {
                this.upgrades.add(((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)upgrade))).getDefaultInstance());
            }
        }
        if ((this.item instanceof BackpackItem || this.item instanceof SimpleStorageBoxItem) && this.upgrades.isEmpty() && this.storage.isEmpty()) {
            this.tooltipText.add((Component)Component.translatable((String)"tooltip.fxntstorage.no_inventory_or_upgrades").withStyle(FontHelper.Palette.STANDARD_CREATE.highlight()));
        }
        if (this.item instanceof StorageBoxItem && this.storage.isEmpty()) {
            this.tooltipText.add((Component)Component.translatable((String)"tooltip.fxntstorage.no_inventory").withStyle(FontHelper.Palette.STANDARD_CREATE.highlight()));
        }
    }
}

