/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.List;
import net.fxnt.fxntstorage.backpack.BackpackEntity;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class BackpackAsBlockUpgradeHandler {
    private final IBackpackContainer container;
    private final BlockEntity blockEntity;
    private final Level level;
    private final BlockPos pos;
    private static final int magnetUpgradeRange = (Integer)ConfigManager.CommonConfig.BACKPACK_MAGNET_RANGE.get();

    public BackpackAsBlockUpgradeHandler(BackpackEntity backpackBlockEntity) {
        this.container = backpackBlockEntity;
        this.blockEntity = backpackBlockEntity;
        this.level = this.blockEntity.getLevel();
        this.pos = this.blockEntity.getBlockPos();
    }

    public void applyMagnetUpgrade() {
        AABB boundingBox;
        List nearbyItems;
        if (this.blockEntity != null && !this.level.isClientSide && !(nearbyItems = this.level.getEntitiesOfClass(ItemEntity.class, boundingBox = new AABB(this.pos).inflate((double)magnetUpgradeRange))).isEmpty()) {
            ArmorStand stand = (ArmorStand)EntityType.ARMOR_STAND.create(this.level);
            for (ItemEntity itemEntity : nearbyItems) {
                if (itemEntity.getItem().getItem() instanceof BackpackItem) continue;
                new BackpackHelper().itemEntityToBackpack(this.container, itemEntity, 0, Util.ITEM_SLOT_END_RANGE);
                if (stand == null) continue;
                stand.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() - 0.75, (double)this.pos.getZ() + 0.5);
                stand.noPhysics = true;
                stand.setInvisible(true);
                this.level.addFreshEntity((Entity)stand);
                ((ServerLevel)this.level).getChunkSource().broadcast((Entity)itemEntity, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.getId(), stand.getId(), itemEntity.getItem().getCount()));
            }
            if (stand != null) {
                stand.discard();
            }
        }
    }
}

