/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.NotNull;

public class JetpackAirOverlay
implements LayeredDraw.Layer {
    public static final JetpackAirOverlay INSTANCE = new JetpackAirOverlay();

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || Objects.requireNonNull(mc.gameMode).getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        if (!((Boolean)ConfigManager.ClientConfig.DISPLAY_JETPACK_AIR_OVERLAY.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        if (!player.getPersistentData().contains("VisualJetpackAir")) {
            return;
        }
        int timeLeft = player.getPersistentData().getInt("VisualJetpackAir");
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        ItemStack backtank = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        poseStack.translate((double)guiGraphics.guiWidth() / 2.0 + 93.2, (double)(guiGraphics.guiHeight() - 29), 0.0);
        float scale = 0.6f;
        poseStack.scale(scale, scale, scale);
        GuiGameElement.of((ItemStack)backtank).at(0.0f, 0.0f).render(guiGraphics);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((float)guiGraphics.guiWidth() / 2.0f + 90.0f, (float)(guiGraphics.guiHeight() - 33), 0.0f);
        MutableComponent text = Component.literal((String)StringUtil.formatTickDuration((int)(Math.max(0, timeLeft - 1) * 20), (float)mc.level.tickRateManager().tickrate()));
        int color = -1;
        if (timeLeft < 60 && timeLeft % 2 == 0) {
            color = Color.mixColors((int)-65536, (int)color, (float)Math.max((float)timeLeft / 60.0f, 0.25f));
        }
        guiGraphics.drawString(mc.font, (Component)text, 16, 5, color);
        poseStack.popPose();
    }
}

