/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackOnBackUpgradeHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.fxnt.fxntstorage.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class JetpackHandler {
    private static final int MAX_ALLOWED_HEIGHT = 32;
    private static final double GRAVITY = -0.44;
    private static final long FUEL_SYNC_INTERVAL = 1000L;
    private static final long MAX_INTERPOLATION_TIME = 200L;
    private static final int MAX_MISSED_PACKETS = 5;
    private final Player player;
    private double hoverHeight = 0.0;
    private float jetPackFuelRemaining;
    private long lastRuntime = 0L;
    private long airGaugeLastCleared = 0L;
    private boolean airGaugeCleared = false;
    private boolean isJumping = false;
    private boolean isHovering = false;
    private float forward = 0.0f;
    private float left = 0.0f;
    private boolean playedSoundThisJump = false;
    private float predictedFuelRemaining;
    private long lastFuelSync = 0L;
    private Vec3 lastValidVelocity = Vec3.ZERO;
    private long lastServerUpdate = 0L;
    private double lastKnownY = 0.0;
    private static final double TELEPORT_THRESHOLD = 5.0;
    private long lastPacketTime = 0L;
    private int missedPackets = 0;
    private IBackpackContainer itemHandler;

    public JetpackHandler(Player player) {
        this.player = player;
    }

    public void execute() {
        if (this.player == null) {
            return;
        }
        if (this.player.level().isClientSide) {
            this.executeClient();
        } else {
            this.executeServer();
        }
    }

    private void executeClient() {
        this.updatePredictedFuel();
        if (this.isHovering && this.wasTeleported()) {
            this.hoverHeight = this.player.getY();
        }
        if (this.isJumping) {
            if (this.predictedFuelRemaining <= 0.0f) {
                this.endHovering(false);
                return;
            }
            this.player.setNoGravity(true);
            this.player.resetFallDistance();
            if (this.player.isShiftKeyDown()) {
                this.startHovering(true);
            } else if (this.isHovering) {
                this.endHovering(true);
            }
            this.updateClientMovementWithInterpolation();
            if (this.player.onGround() && this.isHovering) {
                this.endHovering(true);
            }
            if (!this.player.isInWater() && !this.player.isInLava()) {
                this.handleThrustSound();
            }
        } else {
            boolean bl = this.playedSoundThisJump = !this.player.onGround();
            if (this.isHovering) {
                if (this.player.onGround()) {
                    this.endHovering(true);
                }
                if (this.predictedFuelRemaining <= 0.0f) {
                    this.endHovering(false);
                    return;
                }
                this.updateClientMovementWithInterpolation();
            } else {
                this.player.setNoGravity(false);
                this.fadeOutVisualAirOverlay();
            }
        }
    }

    private void executeServer() {
        if (this.isHovering && this.wasTeleported()) {
            this.hoverHeight = this.player.getY();
        }
        this.jetPackFuelRemaining = (float)this.calculateJetPackFuel(this.player);
        if ((this.isJumping || this.isHovering) && this.jetPackFuelRemaining > 0.0f) {
            this.depleteJetPackFuel(this.player);
            this.validatePlayerMovement();
            this.player.resetFallDistance();
            if (this.player.tickCount % 5 == 0) {
                this.validateAndCorrectPosition();
            }
            if (BackpackHelper.isWearingBackpack(this.player, true)) {
                ParticleHelper.jetPackParticles(this.player);
            }
        } else if (this.isHovering && this.jetPackFuelRemaining <= 0.0f) {
            this.endHovering(false);
        }
        this.syncFuelToClient();
        this.fadeOutVisualAirOverlay();
    }

    private boolean wasTeleported() {
        double yDifference = Math.abs(this.player.getY() - this.lastKnownY);
        boolean teleported = yDifference > 5.0 && this.lastKnownY != 0.0;
        this.lastKnownY = this.player.getY();
        return teleported;
    }

    private void updatePredictedFuel() {
        long currentTime = this.player.level().getGameTime();
        if (this.lastFuelSync == 0L || currentTime - this.lastFuelSync > 2000L) {
            this.predictedFuelRemaining = this.jetPackFuelRemaining;
        } else if (this.isJumping) {
            long timeSinceSync = currentTime - this.lastFuelSync;
            float estimatedConsumption = (float)((double)timeSinceSync / 1000.0);
            this.predictedFuelRemaining = Math.max(this.jetPackFuelRemaining - estimatedConsumption, 0.0f);
        }
    }

    public void onFuelSync(float serverFuel, long serverTime) {
        this.jetPackFuelRemaining = serverFuel;
        this.predictedFuelRemaining = serverFuel;
        this.lastFuelSync = this.player.level().getGameTime();
        long clientTime = this.player.level().getGameTime();
        long estimatedLatency = Math.max(0L, clientTime - serverTime);
        if (this.isJumping && estimatedLatency > 0L) {
            float latencyConsumption = (float)estimatedLatency / 1000.0f;
            this.predictedFuelRemaining = Math.max(serverFuel - latencyConsumption, 0.0f);
        }
        this.missedPackets = 0;
        this.lastPacketTime = clientTime;
    }

    private void validatePlayerMovement() {
        Vec3 velocity = this.player.getDeltaMovement();
        double maxHorizontalSpeed = 2.0;
        double maxVerticalSpeed = 1.0;
        boolean needsCorrection = false;
        double newX = velocity.x;
        double newY = velocity.y;
        double newZ = velocity.z;
        double horizontalSpeed = Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
        if (horizontalSpeed > maxHorizontalSpeed) {
            double scale = maxHorizontalSpeed / horizontalSpeed;
            newX *= scale;
            newZ *= scale;
            needsCorrection = true;
        }
        if (Math.abs(velocity.y) > maxVerticalSpeed) {
            newY = Math.copySign(maxVerticalSpeed, velocity.y);
            needsCorrection = true;
        }
        if (needsCorrection) {
            this.player.setDeltaMovement(newX, newY, newZ);
        }
    }

    private void validateAndCorrectPosition() {
        double distanceToGround = JetpackHandler.getDistanceToGround(this.player);
        if (distanceToGround > 37.0) {
            Vec3 velocity = this.player.getDeltaMovement();
            this.player.setDeltaMovement(velocity.x, Math.min(velocity.y, -0.1), velocity.z);
        }
    }

    private void handleThrustSound() {
        if (this.player.onGround()) {
            this.playedSoundThisJump = false;
        } else if (!this.playedSoundThisJump) {
            if (this.player.level().isClientSide) {
                this.player.level().playLocalSound(this.player.getX(), this.player.getY(), this.player.getZ(), AllSoundEvents.STEAM.getMainEvent(), SoundSource.PLAYERS, 0.1f, 1.0f, false);
            }
            this.playedSoundThisJump = true;
        }
    }

    public void fadeOutVisualAirOverlay() {
        if (this.player.onGround() && !this.airGaugeCleared) {
            long currentTime;
            if (this.airGaugeLastCleared == 0L) {
                this.airGaugeLastCleared = this.player.level().getGameTime();
            }
            if ((currentTime = this.player.level().getGameTime()) - this.airGaugeLastCleared >= 25L) {
                if (!this.player.level().isClientSide) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new VisualJetpackAirPacket(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.airGaugeCleared = true;
            }
        } else if (!this.player.onGround() || !this.isJumping && !this.isHovering) {
            this.airGaugeLastCleared = 0L;
        }
    }

    private static double getDistanceToGround(@NotNull Player player) {
        Vec3 start = player.position();
        Vec3 end = start.add(0.0, (double)(-player.getBlockY() - 256), 0.0);
        BlockHitResult hitResult = player.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            return start.y - hitResult.getLocation().y;
        }
        return (Boolean)ConfigManager.CommonConfig.JETPACK_ALLOW_VOID_FLIGHT.get() != false ? -1.0 : Double.MAX_VALUE;
    }

    public void toggleHover() {
        if (this.player.onGround()) {
            this.endHovering(false);
            return;
        }
        if (!this.isHovering) {
            this.startHovering(true);
        } else {
            this.player.setNoGravity(false);
            this.endHovering(true);
        }
    }

    public void startHovering(boolean announce) {
        this.isHovering = true;
        this.hoverHeight = this.player.getY();
        if (announce) {
            this.displayHoverMessage(true);
        }
    }

    public void endHovering(boolean announce) {
        this.isHovering = false;
        this.hoverHeight = 0.0;
        if (announce) {
            this.displayHoverMessage(false);
        }
        if (this.player.onGround()) {
            this.airGaugeLastCleared = 0L;
        }
    }

    private void displayHoverMessage(boolean isStarting) {
        boolean isElytraBoost;
        boolean bl = isElytraBoost = this.player.getItemBySlot(EquipmentSlot.CHEST).getItem().equals(Items.ELYTRA) && this.player.isFallFlying() && (Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get() != false;
        String messageKey = isStarting ? (isElytraBoost ? "item.fxntstorage.jetpack.elytra_boost_enabled" : "item.fxntstorage.jetpack.hover_enabled") : (isElytraBoost ? "item.fxntstorage.jetpack.elytra_boost_disabled" : "item.fxntstorage.jetpack.hover_disabled");
        this.player.displayClientMessage((Component)Component.translatable((String)messageKey), true);
    }

    private void updateClientMovementWithInterpolation() {
        long currentTime = this.player.level().getGameTime();
        if (this.lastPacketTime > 0L && currentTime - this.lastPacketTime > 100L) {
            ++this.missedPackets;
        }
        Vec3 calculatedVelocity = this.calculateMovementVelocity();
        if (this.shouldUseInterpolation()) {
            calculatedVelocity = this.applyVelocityInterpolation(calculatedVelocity);
        }
        this.applyVelocityToPlayer(calculatedVelocity);
    }

    private boolean shouldUseInterpolation() {
        long timeSinceServerUpdate = this.player.level().getGameTime() - this.lastServerUpdate;
        return timeSinceServerUpdate < 200L && this.missedPackets < 5 && !this.lastValidVelocity.equals((Object)Vec3.ZERO);
    }

    private Vec3 applyVelocityInterpolation(Vec3 calculatedVelocity) {
        long currentTime = this.player.level().getGameTime();
        long timeSinceUpdate = currentTime - this.lastServerUpdate;
        if (timeSinceUpdate < 200L) {
            float interpolationAlpha = Math.min(1.0f, (float)timeSinceUpdate / 200.0f);
            Vec3 interpolatedVelocity = this.lastValidVelocity.lerp(calculatedVelocity, (double)interpolationAlpha);
            double velocityDifference = calculatedVelocity.distanceTo(this.lastValidVelocity);
            if (velocityDifference > 0.5) {
                float smoothingFactor = Math.min(0.3f, 1.0f / (float)(this.missedPackets + 1));
                return this.lastValidVelocity.lerp(calculatedVelocity, (double)smoothingFactor);
            }
            return interpolatedVelocity;
        }
        return calculatedVelocity;
    }

    private Vec3 calculateMovementVelocity() {
        Vec3 lookVec = this.player.getLookAngle();
        Vec3 flatLookDirection = new Vec3(lookVec.x, 0.0, lookVec.z);
        Vec3 strafeDirection = flatLookDirection.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        double forwardWeight = this.isHovering ? 1.0 : 1.5;
        double leftWeight = this.isHovering ? 0.2 : 0.6;
        Vec3 movementDirection = flatLookDirection.scale((double)this.forward * forwardWeight).add(strafeDirection.scale((double)this.left * leftWeight));
        double horizontalSpeed = this.calculateHorizontalSpeed();
        double acceleration = this.isHovering ? 0.02 * (horizontalSpeed / 0.33) : 0.25;
        Vec3 horizontalVelocity = this.applyMovementPhysics(this.player.getDeltaMovement(), movementDirection.normalize(), acceleration, horizontalSpeed);
        double verticalSpeed = this.isHovering ? this.calculateVerticalHoveringSpeed(this.hoverHeight) : this.calculateVerticalSpeed();
        return new Vec3(horizontalVelocity.x, verticalSpeed, horizontalVelocity.z);
    }

    private void applyVelocityToPlayer(Vec3 velocity) {
        float fuelToCheck = this.player.level().isClientSide ? this.predictedFuelRemaining : this.jetPackFuelRemaining;
        double distanceToGround = JetpackHandler.getDistanceToGround(this.player);
        if ((fuelToCheck < 10.0f || distanceToGround > 32.0) && this.isJumping) {
            velocity = new Vec3(velocity.x, Mth.lerp((double)velocity.y, (double)-0.044, (double)0.5), velocity.z);
        }
        if (!this.player.level().isClientSide) {
            this.lastValidVelocity = velocity;
            this.lastServerUpdate = this.player.level().getGameTime();
        }
        if (this.player.isSwimming() && this.isJumping) {
            Vec3 lookDirection = this.player.getLookAngle();
            Vec3 deltaMovement = this.player.getDeltaMovement();
            this.player.setDeltaMovement(deltaMovement.x + lookDirection.x * 0.08, deltaMovement.y + lookDirection.y * 0.08, deltaMovement.z + lookDirection.z * 0.08);
        } else if (this.player.isFallFlying() && ((Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get()).booleanValue()) {
            this.applyElytraBoost();
        } else {
            this.player.setDeltaMovement(velocity);
        }
    }

    private void applyElytraBoost() {
        Vec3 motion = this.player.getDeltaMovement();
        Vec3 look = this.player.getLookAngle();
        double horizontalBoost = 0.12;
        double verticalBoost = 0.1;
        double newX = motion.x + look.x * horizontalBoost;
        double newY = motion.y + look.y * verticalBoost;
        double newZ = motion.z + look.z * horizontalBoost;
        double maxSpeed = (Double)ConfigManager.CommonConfig.ELYTRA_BOOST_SPEED_MULTIPLIER.get();
        Vec3 newMotion = new Vec3(newX, newY, newZ);
        if (newMotion.length() > maxSpeed) {
            newMotion = newMotion.normalize().scale(maxSpeed);
        }
        this.player.setDeltaMovement(newMotion);
    }

    private void syncFuelToClient() {
        if (this.player.tickCount % 20 != 0) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)this.player;
        int totalAir = (int)this.jetPackFuelRemaining;
        if (!this.player.onGround() && this.jetPackFuelRemaining > 0.0f) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new VisualJetpackAirPacket(totalAir), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.airGaugeCleared = false;
        } else {
            this.fadeOutVisualAirOverlay();
        }
        long serverTime = this.player.level().getGameTime();
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new JetpackFuelSyncPacket(this.jetPackFuelRemaining, serverTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private Vec3 applyMovementPhysics(@NotNull Vec3 currentVelocity, @NotNull Vec3 direction, double acceleration, double maxSpeed) {
        Vec3 targetVelocity = currentVelocity.add(direction.scale(acceleration));
        double speed = Math.sqrt(targetVelocity.x * targetVelocity.x + targetVelocity.z * targetVelocity.z);
        if (speed > maxSpeed) {
            double scale = maxSpeed / speed;
            targetVelocity = new Vec3(targetVelocity.x * scale, currentVelocity.y, targetVelocity.z * scale);
        }
        return targetVelocity;
    }

    private double calculateHorizontalSpeed() {
        double baseFlySpeedBoost = 0.375;
        double defaultPlayerSneakSpeed = 0.08;
        double defaultPlayerWaterSpeed = 0.08;
        double defaultPlayerSprintSpeed = 0.13;
        double defaultPlayerWalkSpeed = 0.1;
        double baseHoverSpeedBoost = 0.25;
        ItemEnchantments enchantments = (ItemEnchantments)this.player.getItemBySlot(EquipmentSlot.LEGS).get(DataComponents.ENCHANTMENTS);
        Holder holder = this.player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SWIFT_SNEAK).orElse(null);
        double enchantedSpeedMultiplier = enchantments == null || holder == null ? 0.0 : (double)((float)enchantments.getLevel(holder) * 0.15f);
        double mobEffectSpeedMultiplier = this.player.hasEffect(MobEffects.MOVEMENT_SPEED) ? (double)Objects.requireNonNull(this.player.getEffect(MobEffects.MOVEMENT_SPEED)).getAmplifier() : 0.0;
        double baseSpeed = defaultPlayerWalkSpeed;
        if (this.player.isInWater() && !this.player.isSwimming()) {
            return this.player.isSwimming() ? defaultPlayerWaterSpeed * 0.5 : defaultPlayerWaterSpeed;
        }
        if (this.player.isSprinting()) {
            baseSpeed = defaultPlayerSprintSpeed;
        } else if (this.isHovering) {
            baseSpeed = defaultPlayerSneakSpeed;
        }
        double horizontalSpeed = baseSpeed + baseFlySpeedBoost + mobEffectSpeedMultiplier / 10.0;
        if (this.isHovering) {
            horizontalSpeed = (baseSpeed + baseHoverSpeedBoost) * (1.0 + enchantedSpeedMultiplier) + mobEffectSpeedMultiplier / 10.0;
        }
        return horizontalSpeed;
    }

    private double calculateVerticalSpeed() {
        double currentVerticalSpeed = this.player.getDeltaMovement().y;
        double dampingFactor = currentVerticalSpeed < 0.0 && !this.isJumping ? 0.05 : 0.15;
        double verticalTarget = -0.44;
        if (this.isJumping) {
            verticalTarget = 0.42;
        } else if (this.player.isInWater()) {
            verticalTarget = -0.0275;
        } else if (this.player.isSwimming()) {
            return 0.0;
        }
        return currentVerticalSpeed * (1.0 - dampingFactor) + verticalTarget * dampingFactor;
    }

    private double calculateVerticalHoveringSpeed(double targetHeight) {
        boolean bobbingEnabled = this.player.getPersistentData().getCompound("fxntstorageSettings").getBoolean("JetpackHoverBobbing");
        double currentY = this.player.getY();
        double yDifference = targetHeight - currentY;
        double adjustmentForce = yDifference * 0.3;
        double newYVelocity = this.player.getDeltaMovement().y * 0.8 + adjustmentForce;
        if (bobbingEnabled && this.player.level().isClientSide()) {
            float time = (float)this.player.level().getGameTime() + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            double period = 20.0;
            double angle = (double)time % period / period * (Math.PI * 2);
            double bob = Math.sin(angle) * 0.008;
            newYVelocity += bob;
        }
        return Mth.clamp((double)newYVelocity, (double)-0.2, (double)0.2);
    }

    public double calculateJetPackFuel(Player player) {
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        if (backpack.isEmpty()) {
            return 0.0;
        }
        List<ItemStack> backtanks = this.getBacktanksFromPlayer(player, backpack);
        return backtanks.stream().map(BacktankUtil::getAir).reduce(0, Integer::sum).intValue();
    }

    private void depleteJetPackFuel(Player player) {
        if (player.level().isClientSide || player.isCreative()) {
            return;
        }
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        Level world = player.level();
        long currRuntime = world.getGameTime();
        int elytraMultiplier = (Integer)ConfigManager.CommonConfig.ELYTRA_BOOST_MULTIPLIER.get();
        if (player.isFallFlying() && (Boolean)ConfigManager.CommonConfig.ELYTRA_BOOST_ENABLED.get() != false ? this.lastRuntime != 0L && currRuntime - this.lastRuntime < (long)(20 / elytraMultiplier) : this.lastRuntime != 0L && currRuntime - this.lastRuntime < 20L) {
            return;
        }
        this.lastRuntime = currRuntime;
        List<ItemStack> backtanks = this.getBacktanksFromPlayer(player, backpack);
        if (backtanks.isEmpty()) {
            return;
        }
        backtanks.sort((a, b) -> Float.compare(BacktankUtil.getAir((ItemStack)a), BacktankUtil.getAir((ItemStack)b)));
        int totalAir = backtanks.stream().map(BacktankUtil::getAir).reduce(0, Integer::sum);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new VisualJetpackAirPacket(totalAir), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.airGaugeCleared = false;
        int air = BacktankUtil.getAir((ItemStack)backtanks.getFirst());
        int newAir = Math.max(air - 1, 0);
        backtanks.getFirst().set(AllDataComponents.BACKTANK_AIR, (Object)newAir);
        this.itemHandler.setDataChanged();
        JetpackHandler.sendFuelWarning(player, totalAir, totalAir - 1, 90.0f);
        JetpackHandler.sendFuelWarning(player, totalAir, totalAir - 1, 1.0f);
    }

    private static IBackpackContainer getBackpackContainer(Player player, ItemStack backpack) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackMenu) {
            BackpackMenu backpackMenu = (BackpackMenu)abstractContainerMenu;
            if (backpackMenu.backpackType == 1) {
                return backpackMenu.container;
            }
        }
        return new BackpackContainer(backpack, player);
    }

    private List<ItemStack> getBacktanksFromPlayer(Player player, ItemStack backpack) {
        ArrayList<ItemStack> backtanks = new ArrayList<ItemStack>();
        ItemStack chestItem = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!chestItem.isEmpty() && AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(chestItem) && BacktankUtil.hasAirRemaining((ItemStack)chestItem)) {
            backtanks.add(chestItem);
        }
        if (!backpack.isEmpty()) {
            IBackpackContainer container = JetpackHandler.getBackpackContainer(player, backpack);
            ItemStackHandler inventory = container.getItemHandler();
            this.itemHandler = container;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack slotItem = inventory.getStackInSlot(i);
                if (!AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(slotItem) || !BacktankUtil.hasAirRemaining((ItemStack)slotItem)) continue;
                backtanks.add(slotItem);
            }
        }
        return backtanks;
    }

    private static void sendFuelWarning(Player player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        MutableComponent component = Component.translatable((String)(depleted ? "item.fxntstorage.jetpack.fuel_depleted" : "item.fxntstorage.jetpack.fuel_low"));
        AllSoundEvents.DENY.play(player.level(), null, (Vec3i)player.blockPosition(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.level(), null, (Vec3i)player.blockPosition(), 0.5f, 0.5f);
        ServerPlayer sp = (ServerPlayer)player;
        sp.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        sp.connection.send((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.literal((String)"\u26a0 ").withStyle(depleted ? ChatFormatting.RED : ChatFormatting.GOLD).append((Component)component.withStyle(ChatFormatting.GRAY))));
        sp.connection.send((Packet)new ClientboundSetTitleTextPacket(CommonComponents.EMPTY));
    }

    public void processPlayerInputPacket(float forward, float left) {
        this.forward = forward;
        this.left = left;
    }

    public void processPlayerFlyingPacket(boolean flying, boolean hovering) {
        this.isJumping = flying;
        this.isHovering = hovering;
    }

    public void flyingOnKeyPress() {
        if (new BackpackOnBackUpgradeHandler(this.player).hasUpgrade("backpack_flight_upgrade")) {
            this.isJumping = true;
        }
    }

    public void flyingOnKeyRelease() {
        this.isJumping = false;
    }

    public void resetState() {
        this.isJumping = false;
        this.isHovering = false;
        this.hoverHeight = 0.0;
        this.playedSoundThisJump = false;
        this.lastRuntime = 0L;
        this.airGaugeLastCleared = 0L;
        this.airGaugeCleared = false;
        this.lastValidVelocity = Vec3.ZERO;
        this.predictedFuelRemaining = 0.0f;
        this.lastFuelSync = 0L;
    }
}

