/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.ArrayList;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolSwapHandler {
    private final Player player;
    private final IBackpackContainer container;
    private final int startIndex;
    private final int endIndex;
    private static BlockState lastBlockState;
    private static ItemStack lastTool;
    private static LivingEntity lastEntity;
    private static ItemStack lastWeapon;

    public ToolSwapHandler(Player player, IBackpackContainer container, int startIndex, int endIndex) {
        this.player = player;
        this.container = container;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public void doToolSwap(@Nullable BlockPos blockPos, @Nullable LivingEntity entity) {
        ItemStack currentItem;
        if (blockPos != null && entity == null) {
            ToolInfo bestTool;
            currentItem = this.player.getMainHandItem();
            BlockState blockState = this.player.level().getBlockState(blockPos);
            if (!(blockState == lastBlockState && currentItem == lastTool || (bestTool = this.findBestToolForBreakingBlock(blockState)) == null || bestTool.itemStack.equals(currentItem))) {
                this.swapBlockTool(bestTool);
            }
            lastBlockState = blockState;
            lastTool = currentItem;
        }
        if (entity != null && blockPos == null) {
            WeaponInfo bestWeapon;
            currentItem = this.player.getMainHandItem();
            if (!(entity == lastEntity && currentItem == lastWeapon || (bestWeapon = this.findBestWeaponForAttackingEntity(entity)) == null || bestWeapon.itemStack.equals(currentItem))) {
                this.swapEntityTool(bestWeapon);
            }
            lastEntity = entity;
            lastWeapon = currentItem;
        }
    }

    public void swapBlockTool(ToolInfo bestTool) {
        ItemStack selectedStack;
        int selectedSlot;
        if (!bestTool.itemStack.isEmpty() && (selectedSlot = this.player.getInventory().selected) != bestTool.slot && !(selectedStack = this.player.getInventory().getSelected().copy()).isEmpty()) {
            this.player.setItemInHand(InteractionHand.MAIN_HAND, bestTool.itemStack.copy());
            this.container.getItemHandler().setStackInSlot(bestTool.slot, selectedStack.copy());
            this.container.setDataChanged();
        }
    }

    @Nullable
    private ToolInfo findBestToolForBreakingBlock(BlockState blockState) {
        boolean currentToolMeetsSilkTouchRequirement;
        NonNullList suitableItems = NonNullList.create();
        boolean requiresSilkTouch = this.requiresSilkTouch(blockState);
        boolean prefersSilkTouch = this.prefersSilkTouch(blockState);
        boolean needsSilkTouch = requiresSilkTouch || prefersSilkTouch;
        ItemStack currentTool = this.player.getMainHandItem();
        boolean canUseAnyTool = this.canUseAnyToolForDrops(blockState);
        boolean currentToolIsCorrect = currentTool.isCorrectToolForDrops(blockState) || canUseAnyTool;
        boolean currentToolHasSilkTouch = currentTool.getEnchantmentLevel(this.player.level().registryAccess().holderOrThrow(Enchantments.SILK_TOUCH)) > 0;
        boolean bl = currentToolMeetsSilkTouchRequirement = currentToolIsCorrect && (!needsSilkTouch || currentToolHasSilkTouch);
        if (currentToolMeetsSilkTouchRequirement && canUseAnyTool) {
            return null;
        }
        if (canUseAnyTool || currentToolIsCorrect) {
            suitableItems.add((Object)new ToolInfo(currentTool, this.player.getInventory().selected, currentTool.getDestroySpeed(blockState), currentTool.getDamageValue(), currentToolHasSilkTouch));
        }
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            int durability;
            double speed;
            boolean isItemTool;
            ItemStack itemStack = this.container.getItemHandler().getStackInSlot(i);
            boolean hasSilkTouch = itemStack.getEnchantmentLevel(this.player.level().registryAccess().holderOrThrow(Enchantments.SILK_TOUCH)) > 0;
            boolean bl2 = isItemTool = itemStack.is(Tags.Items.TOOLS) || itemStack.is(Tags.Items.TOOLS_SHEAR);
            if (canUseAnyTool && isItemTool) {
                speed = itemStack.getDestroySpeed(blockState);
                durability = itemStack.getDamageValue();
                suitableItems.add((Object)new ToolInfo(itemStack, i, speed, durability, hasSilkTouch));
                continue;
            }
            if (!itemStack.isCorrectToolForDrops(blockState)) continue;
            speed = itemStack.getDestroySpeed(blockState);
            durability = itemStack.getDamageValue();
            suitableItems.add((Object)new ToolInfo(itemStack, i, speed, durability, hasSilkTouch));
        }
        if (suitableItems.isEmpty()) {
            return new ToolInfo(ItemStack.EMPTY, -1, 0.0, 0, false);
        }
        ToolSwapHandler.sortTools((NonNullList<ToolInfo>)suitableItems, needsSilkTouch);
        for (ToolInfo tool : suitableItems) {
            if (suitableItems.size() == 1) {
                return tool;
            }
            if (tool.silkTouch && prefersSilkTouch) {
                return tool;
            }
            if (tool.silkTouch && requiresSilkTouch) {
                return tool;
            }
            if (tool.silkTouch) continue;
            return tool;
        }
        return null;
    }

    public void swapEntityTool(WeaponInfo bestWeapon) {
        ItemStack selectedStack;
        int selectedSlot;
        if (!bestWeapon.itemStack.isEmpty() && (selectedSlot = this.player.getInventory().selected) != bestWeapon.slot && !(selectedStack = this.player.getInventory().getSelected().copy()).isEmpty()) {
            this.player.setItemInHand(InteractionHand.MAIN_HAND, bestWeapon.itemStack.copy());
            this.container.getItemHandler().setStackInSlot(bestWeapon.slot, selectedStack.copy());
            this.container.setDataChanged();
        }
    }

    public WeaponInfo findBestWeaponForAttackingEntity(LivingEntity entity) {
        NonNullList suitableItems = NonNullList.create();
        ItemStack currentItem = this.player.getInventory().getSelected();
        double currentItemDamage = ToolSwapHandler.getAttackDamage(currentItem, entity);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            ItemStack itemStack = this.container.getItemHandler().getStackInSlot(i);
            if (!itemStack.canPerformAction(ItemAbilities.SWORD_SWEEP) && !itemStack.is(ItemTags.SWORDS) && !itemStack.is(ItemTags.AXES)) continue;
            double itemDamage = ToolSwapHandler.getAttackDamage(itemStack, entity);
            int durability = itemStack.getDamageValue();
            if (!(itemDamage > currentItemDamage)) continue;
            suitableItems.add((Object)new WeaponInfo(itemStack, i, durability, itemDamage));
        }
        if (suitableItems.isEmpty()) {
            return new WeaponInfo(ItemStack.EMPTY, -1, 0, 0.0);
        }
        ToolSwapHandler.sortWeapons((NonNullList<WeaponInfo>)suitableItems);
        return (WeaponInfo)suitableItems.getFirst();
    }

    public static double getAttackDamage(ItemStack weapon, LivingEntity target) {
        double baseDamage = ToolSwapHandler.getBaseAttackDamage(weapon);
        double enchantmentDamage = ToolSwapHandler.calculateEnchantmentDamage(weapon, target);
        return baseDamage + enchantmentDamage;
    }

    public static double getBaseAttackDamage(ItemStack itemStack) {
        return 1.0 + itemStack.getAttributeModifiers().modifiers().stream().filter(e -> e.attribute().is(Attributes.ATTACK_DAMAGE)).mapToDouble(e -> e.modifier().amount()).findFirst().orElse(0.0);
    }

    public static double calculateEnchantmentDamage(ItemStack weapon, LivingEntity target) {
        int sharpnessLevel = weapon.getEnchantmentLevel(target.level().registryAccess().holderOrThrow(Enchantments.SHARPNESS));
        int smiteLevel = weapon.getEnchantmentLevel(target.level().registryAccess().holderOrThrow(Enchantments.SMITE));
        int baneLevel = weapon.getEnchantmentLevel(target.level().registryAccess().holderOrThrow(Enchantments.BANE_OF_ARTHROPODS));
        double additionalDamage = 0.0;
        if (sharpnessLevel > 0) {
            additionalDamage += 0.5 * (double)sharpnessLevel + 0.5;
        }
        if (smiteLevel > 0 && target.getType().is(EntityTypeTags.SENSITIVE_TO_SMITE)) {
            additionalDamage += (double)smiteLevel * 2.5;
        }
        if (baneLevel > 0 && target.getType().is(EntityTypeTags.SENSITIVE_TO_BANE_OF_ARTHROPODS)) {
            additionalDamage += (double)baneLevel * 2.5;
        }
        return additionalDamage;
    }

    public static void sortTools(@NotNull NonNullList<ToolInfo> tools, boolean sortSilkTouchFirst) {
        tools.sort((o1, o2) -> {
            int silkTouchComparison;
            if (sortSilkTouchFirst && (silkTouchComparison = Boolean.compare(o2.silkTouch, o1.silkTouch)) != 0) {
                return silkTouchComparison;
            }
            int speedComparison = Double.compare(o2.speed, o1.speed);
            if (speedComparison != 0) {
                return speedComparison;
            }
            return Integer.compare(o1.slot, o2.slot);
        });
    }

    public static void sortWeapons(@NotNull NonNullList<WeaponInfo> tools) {
        tools.sort((o1, o2) -> {
            int damageComparison = Double.compare(o2.damage, o1.damage);
            if (damageComparison != 0) {
                return damageComparison;
            }
            return Double.compare(o2.durability, o1.durability);
        });
    }

    public boolean requiresSilkTouch(BlockState blockState) {
        Block block = blockState.getBlock();
        return block == Blocks.BEE_NEST || blockState.is(BlockTags.CORALS) || block == Blocks.AMETHYST_CLUSTER || block == Blocks.CHISELED_BOOKSHELF || blockState.is(Tags.Blocks.GLASS_BLOCKS) || blockState.is(Tags.Blocks.GLASS_PANES) || blockState.is(BlockTags.ICE) || block == Blocks.TURTLE_EGG;
    }

    public boolean prefersSilkTouch(BlockState state) {
        CompoundTag pData = this.player.getPersistentData().getCompound("fxntstorageSettings");
        if (pData.contains("PreferSilkTouch") && pData.getBoolean("PreferSilkTouch")) {
            if (pData.contains("PrefersSilkTouchList")) {
                ListTag blockListTag = pData.getList("PrefersSilkTouchList", 8);
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                ArrayList<String> blockList = new ArrayList<String>();
                for (int i = 0; i < blockListTag.size(); ++i) {
                    blockList.add(blockListTag.getString(i));
                }
                if (!blockList.isEmpty()) {
                    return blockList.contains(blockId.toString());
                }
            }
            return false;
        }
        return false;
    }

    public boolean canUseAnyToolForDrops(BlockState state) {
        return state.is(ModTags.Blocks.BREAKABLE_WITH_ANY_TOOL);
    }

    public record ToolInfo(ItemStack itemStack, int slot, double speed, int durability, boolean silkTouch) {
    }

    public record WeaponInfo(ItemStack itemStack, int slot, int durability, double damage) {
    }
}

