/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.constructionstick;

import mrbysco.constructionstick.api.IContainerHandler;
import mrbysco.constructionstick.basics.StickUtil;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.ItemStackHandler;

public class HandlerBackpack
implements IContainerHandler {
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCount() == 1 && Block.byItem((Item)inventoryStack.getItem()) instanceof BackpackBlock;
    }

    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        BackpackContainer container = new BackpackContainer(inventoryStack, player);
        int count = 0;
        for (ItemStack stack : container.getItems()) {
            if (!StickUtil.stackEquals((ItemStack)stack, (ItemStack)itemStack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        BackpackContainer container = new BackpackContainer(inventoryStack, player);
        boolean changed = false;
        for (ItemStack stack : container.getItems()) {
            if (!StickUtil.stackEquals((ItemStack)stack, (ItemStack)itemStack)) continue;
            int toTake = Math.min(count, stack.getCount());
            stack.shrink(toTake);
            changed = true;
            if ((count -= toTake) != 0) continue;
            break;
        }
        if (changed) {
            this.setItems(container);
            container.setDataChanged();
        }
        return count;
    }

    private void setItems(BackpackContainer container) {
        ItemStackHandler handler = container.getItemHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, container.getStackInSlot(i));
        }
    }
}

