/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.util.RendererHelper;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class StorageBoxEntityRenderer
extends SmartBlockEntityRenderer<StorageBoxEntity> {
    public StorageBoxEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void renderFromContraptionContext(MovementContext context, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double distance;
        BlockState state = context.state;
        CompoundTag tag = context.blockEntityData;
        if (tag == null || state == null) {
            return;
        }
        int amount = tag.getInt("StoredAmount");
        int percentUsed = Math.round(tag.getFloat("PercentageUsed"));
        String line1 = Util.formatNumber(amount);
        Object line2 = tag.getBoolean("VoidUpgrade") ? "Void Mode" : percentUsed + "% Used";
        Direction side = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        PoseStack poseStack = matrices.getModelViewProjection();
        poseStack.pushPose();
        poseStack.translate((float)context.localPos.getX() + 0.5f, (float)context.localPos.getY() + 0.5f, (float)context.localPos.getZ() + 0.5f);
        poseStack.mulPose(Axis.YP.rotation(RendererHelper.SIDE_ROT_Y[side.ordinal()]));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        double d = distance = context.position != null ? Math.sqrt(player.distanceToSqr(context.position)) : Math.sqrt(player.distanceToSqr(context.contraption.entity.toGlobalVector(Vec3.atCenterOf((Vec3i)context.localPos), 1.0f)));
        if (distance >= 10.0) {
            poseStack.popPose();
            return;
        }
        int color = RendererHelper.getColorForDistance(distance);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color);
        RendererHelper.renderLine((String)line2, -4.0f, poseStack, buffer, color);
        if (tag.contains("Filter")) {
            ItemStack filterItem;
            ItemStack itemStack = filterItem = tag.getCompound("Filter").isEmpty() ? ItemStack.EMPTY : ItemStack.parseOptional((HolderLookup.Provider)context.contraption.entity.level().registryAccess(), (CompoundTag)tag.getCompound("Filter"));
            if (!filterItem.isEmpty()) {
                RendererHelper.renderItem(mc.getItemRenderer(), filterItem, poseStack, buffer, false);
            }
        }
        poseStack.popPose();
    }

    protected void renderSafe(StorageBoxEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        Screen currentScreen = mc.screen;
        boolean isPonderScene = currentScreen instanceof AbstractSimiScreen;
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)blockEntity, (float)partialTick, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)250, (int)packedOverlay);
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        int amount = blockEntity.getStoredAmount();
        String line1 = Util.formatNumber(amount);
        String line2 = blockEntity.voidUpgrade ? "Void Mode" : blockEntity.getPercentageUsed() + "% Used";
        float distance = (float)Math.sqrt(blockEntity.getBlockPos().distToCenterSqr((Position)player.position()));
        if (distance > 10.0f && !isPonderScene) {
            return;
        }
        if (isPonderScene) {
            distance = 3.0f;
        }
        BlockState blockState = blockEntity.getBlockState();
        Direction side = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(new Matrix4f().rotateYXZ(RendererHelper.SIDE_ROT_Y[side.ordinal()], 0.0f, 0.0f));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        int color = RendererHelper.getColorForDistance(distance);
        RendererHelper.renderLine(line1, 7.0f, poseStack, buffer, color);
        RendererHelper.renderLine(line2, 4.0f, poseStack, buffer, color);
    }
}

