/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container.mounted;

import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedStorage;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class StorageBoxMountedMenu
extends AbstractContainerMenu {
    private final Container container;
    private final CompoundTag nbt;
    private final Player player;
    private final int contraptionId;
    private final BlockPos localPos;
    private final int slotCount;

    public StorageBoxMountedMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(containerId, playerInventory, (Container)new SimpleContainer(buf.readInt()), buf.readInt(), buf.readBlockPos(), buf.readNbt());
    }

    public Container getInventory() {
        return this.container;
    }

    public StorageBoxMountedMenu(int containerId, Inventory playerInventory, Container container, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        super((MenuType)ModMenuTypes.STORAGE_BOX_MOUNTED_MENU.get(), containerId);
        this.nbt = nbt;
        this.container = container;
        this.player = playerInventory.player;
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        SimpleContainerData data = new SimpleContainerData(container.getContainerSize());
        this.slotCount = data.getCount();
        int index = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            this.addSlot(new Slot(container, index, index * 18, 0){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return StorageBoxMountedMenu.this.filterTest(stack);
                }

                public void setChanged() {
                    super.setChanged();
                    StorageBoxMountedMenu.this.setStorageDirty();
                }
            });
            ++index;
        }
        int yOffset = 0;
        int xOffset = 61;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset += 58;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.container.stillValid(pPlayer);
    }

    public SortOrder getSortOrder() {
        return SortOrder.valueOf(this.nbt.getString("SortOrder"));
    }

    public void setSortOrder(SortOrder order) {
        this.nbt.putString("SortOrder", order.name());
        if (this.player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSortOrderPacket(this.getSortOrder()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            this.updateContraptionNbt(tag -> tag.putString("SortOrder", order.name()));
        }
    }

    public int getSlotsSize() {
        return this.slots.size();
    }

    public int getContainerSize() {
        return this.slotCount;
    }

    public Slot getPlayerSlot(int slotIndex) {
        return (Slot)this.slots.get(this.getSlotsSize() - 36 + slotIndex);
    }

    public Slot getHotbarSlot(int slotIndex) {
        return (Slot)this.slots.get(this.getSlotsSize() - 36 + 27 + slotIndex);
    }

    public boolean filterTest(ItemStack stack) {
        ItemStack filterItem = ItemStack.parseOptional((HolderLookup.Provider)this.player.registryAccess(), (CompoundTag)this.nbt.getCompound("Filter"));
        return FilterItemStack.of((ItemStack)filterItem).test(this.player.level(), stack);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int pIndex) {
        Slot srcSlot = (Slot)this.slots.get(pIndex);
        if (!srcSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack srcStack = srcSlot.getItem();
        if (!this.filterTest(srcStack)) {
            return ItemStack.EMPTY;
        }
        ItemStack copyOfSrcStack = srcStack.copy();
        if (pIndex < this.container.getContainerSize() ? !this.moveItemStackTo(srcStack, this.container.getContainerSize(), this.container.getContainerSize() + 36, true) : !this.moveItemStackTo(srcStack, 0, this.container.getContainerSize(), false)) {
            return ItemStack.EMPTY;
        }
        if (srcStack.isEmpty()) {
            srcSlot.set(ItemStack.EMPTY);
        } else {
            srcSlot.setChanged();
        }
        return copyOfSrcStack;
    }

    public void sortStorageItems(int startIndex, int endIndex, SortOrder sortOrder) {
        ServerPlayer sp = (ServerPlayer)this.player;
        HashMap<Util.ItemWithComponent, Integer> itemCompMap = new HashMap<Util.ItemWithComponent, Integer>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = this.getSlot(i).getItem();
            if (stack.isEmpty()) continue;
            DataComponentPatch patch = stack.getComponentsPatch();
            Util.ItemWithComponent key = new Util.ItemWithComponent(stack.getItem(), patch);
            itemCompMap.merge(key, stack.getCount(), Integer::sum);
        }
        ArrayList sortedItems = new ArrayList(itemCompMap.entrySet());
        switch (sortOrder) {
            case MOD: {
                sortedItems.sort(Comparator.comparing(entry -> BuiltInRegistries.ITEM.getKey((Object)((Util.ItemWithComponent)entry.getKey()).item()).toString()).thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).item().getName(new ItemStack((ItemLike)((Util.ItemWithComponent)entry.getKey()).item())).getString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            case NAME: {
                sortedItems.sort(Comparator.comparing(entry -> ((Util.ItemWithComponent)entry.getKey()).item().getName(new ItemStack((ItemLike)((Util.ItemWithComponent)entry.getKey()).item())).getString()).thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).getCustomName()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            default: {
                sortedItems.sort(Map.Entry.comparingByValue().reversed().thenComparing(entry -> ((Util.ItemWithComponent)entry.getKey()).toString()));
            }
        }
        NonNullList compactedList = NonNullList.withSize((int)(endIndex - startIndex), (Object)ItemStack.EMPTY);
        int idx = 0;
        for (Map.Entry entry2 : sortedItems) {
            Util.ItemWithComponent key = (Util.ItemWithComponent)entry2.getKey();
            Item item = key.item();
            DataComponentPatch patch = key.patch();
            int totalCount = (Integer)entry2.getValue();
            int maxStackSize = new ItemStack((ItemLike)item, 1).getMaxStackSize();
            while (totalCount > 0) {
                int stackSize = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (!patch.isEmpty()) {
                    stack.applyComponents(patch);
                }
                compactedList.set(idx, (Object)stack);
                totalCount -= stackSize;
                ++idx;
            }
        }
        for (int i = 0; i < compactedList.size(); ++i) {
            ItemStack itemStack = (ItemStack)compactedList.get(i);
            Slot slot = this.player.containerMenu.getSlot(i + startIndex);
            slot.set(itemStack);
            if (startIndex < this.slotCount) continue;
            sp.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.getStateId(), i + startIndex, itemStack));
        }
    }

    private void updateContraptionNbt(Consumer<CompoundTag> editor) {
        Entity entity = this.player.level().getEntity(this.contraptionId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
        if (info == null) {
            return;
        }
        CompoundTag tag = info.nbt();
        editor.accept(tag);
        contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(info.pos(), info.state(), tag));
        MountedItemStorage storage = (MountedItemStorage)contraption.getStorage().getMountedItems().storages.get((Object)this.localPos);
        if (storage != null && tag != null) {
            ((StorageBoxMountedStorage)storage).setSortOrder(SortOrder.valueOf(tag.getString("SortOrder")));
        }
    }

    private void setStorageDirty() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetMountedStorageDirtyPacket(this.contraptionId, this.localPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

