/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.controller;

import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageController;
import net.fxnt.fxntstorage.storage_network.StorageNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;

public class StorageControllerEntity
extends BlockEntity {
    private int tickCount = 0;
    public StorageNetwork storageNetwork;

    public StorageControllerEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.getStorageNetwork();
    }

    public void getStorageNetwork() {
        this.storageNetwork = new StorageNetwork(this);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.storageNetwork != null ? this.storageNetwork.getItemHandler() : new EmptyItemHandler();
    }

    public void serverTick(Level level, BlockPos blockPos) {
        if (level.isClientSide) {
            return;
        }
        if (this.storageNetwork != null) {
            boolean isConnected;
            this.storageNetwork.tick();
            BlockState blockState = this.getBlockState();
            boolean bl = isConnected = !this.storageNetwork.boxes.isEmpty();
            if ((Boolean)blockState.getValue((Property)StorageController.CONNECTED) != isConnected) {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)StorageController.CONNECTED, (Comparable)Boolean.valueOf(isConnected)));
            }
        }
        if (this.tickCount >= (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            this.tickCount = 0;
        }
        ++this.tickCount;
    }

    public void transferItemsFromPlayer(Player player) {
        CompoundTag pd;
        boolean isDoubleClick;
        ItemStack handItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (handItem.is(Tags.Items.TOOLS_WRENCH)) {
            return;
        }
        long currentTime = player.level().getGameTime();
        boolean bl = isDoubleClick = currentTime - (pd = player.getPersistentData()).getLong("fxntstorage:last_click_time") < 10L && pd.getInt("fxntstorage:last_click_type") == 1;
        if (handItem.isEmpty()) {
            if (isDoubleClick) {
                this.transferAllItemsFromPlayer(player);
                pd.putInt("fxntstorage:last_click_type", 0);
            } else {
                pd.putLong("fxntstorage:last_click_time", currentTime);
                pd.putInt("fxntstorage:last_click_type", 1);
            }
        } else {
            this.doTransferItemsFromPlayer(player, handItem);
            pd.putLong("fxntstorage:last_click_time", currentTime);
            pd.putInt("fxntstorage:last_click_type", 1);
        }
    }

    public void transferAllItemsFromPlayer(Player player) {
        for (int i = 0; i <= player.getInventory().items.size(); ++i) {
            ItemStack slotStack = player.getInventory().getItem(i);
            if (!this.storageNetwork.isItemInNetwork(slotStack)) continue;
            this.doTransferItemsFromPlayer(player, slotStack);
        }
    }

    private void doTransferItemsFromPlayer(Player player, ItemStack srcStack) {
        this.storageNetwork.insertItems(srcStack);
        player.getInventory().setChanged();
    }
}

