/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.controller;

import java.util.Objects;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageControllerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;

public class StorageInterfaceEntity
extends BlockEntity {
    private int tickCount = 0;
    public StorageControllerEntity controller = null;

    public StorageInterfaceEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void setController(StorageControllerEntity controller) {
        if (!this.checkController()) {
            if (this.level != null) {
                this.level.invalidateCapabilities(this.getBlockPos());
            }
            this.controller = controller;
        }
    }

    private boolean checkController() {
        if (this.controller != null) {
            BlockEntity controllerCheck = Objects.requireNonNull(this.getLevel()).getBlockEntity(this.controller.getBlockPos());
            return controllerCheck == this.controller;
        }
        return false;
    }

    public void forgetController() {
        this.controller = null;
    }

    public void serverTick(Level level) {
        if (level.isClientSide) {
            return;
        }
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        if (this.controller != null && !this.checkController()) {
            this.forgetController();
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.controller != null ? this.controller.getItemHandler() : new EmptyItemHandler();
    }
}

