/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.datagen.helper;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.init.ModLootConditionTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModBlockEntitySaveComponents
implements LootItemCondition {
    public static final ModBlockEntitySaveComponents INSTANCE = new ModBlockEntitySaveComponents();
    public static final MapCodec<ModBlockEntitySaveComponents> CODEC = MapCodec.unit((Object)INSTANCE);

    private ModBlockEntitySaveComponents() {
    }

    public LootItemConditionType getType() {
        return ModLootConditionTypes.BLOCK_ENTITY_SAVE_COMPONENTS.get();
    }

    public boolean test(LootContext lootContext) {
        CompoundTag itemsCompound;
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity == null) {
            return false;
        }
        CompoundTag tag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)lootContext.getLevel().registryAccess());
        if (tag.contains("CustomName")) {
            return true;
        }
        if (tag.contains("Items", 10) && (itemsCompound = tag.getCompound("Items")).contains("Items", 9)) {
            ListTag itemList = itemsCompound.getList("Items", 10);
            return !itemList.isEmpty();
        }
        return false;
    }

    public static LootItemCondition.Builder builder() {
        return () -> INSTANCE;
    }
}

