/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.datagen.helper;

import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.controller.StorageController;
import net.fxnt.fxntstorage.controller.StorageInterface;
import net.fxnt.fxntstorage.datagen.helper.ModModelHelper;
import net.fxnt.fxntstorage.passer.PasserBlock;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;

public class ModBlockstateHelper {
    public static NonNullBiConsumer<DataGenContext<Block, StorageBox>, RegistrateBlockstateProvider> storageBox(String name) {
        return (ctx, prov) -> {
            if (!prov.models().existingFileHelper.exists(FXNTStorage.modLoc("block/storage_box_void"), PackType.CLIENT_RESOURCES)) {
                ModModelHelper.storageBoxLight(prov);
            }
            ModModelHelper.storageBox(prov, name);
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            String basePath = "block/" + (String)(name.equals("industrial_iron") ? "" : name + "_");
            BiConsumer<String, Consumer> addDirectionalParts = (modelName, config) -> {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    MultiPartBlockStateBuilder.PartBuilder part = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc(modelName))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageBox.FACING, (Comparable[])new Direction[]{dir});
                    config.accept(part);
                    part.end();
                }
            };
            addDirectionalParts.accept(basePath + "storage_box_base", part -> {});
            for (EnumProperties.StorageUsed state : EnumProperties.StorageUsed.values()) {
                addDirectionalParts.accept("block/storage_box_" + state.getSerializedName(), part -> part.condition(StorageBox.STORAGE_USED, (Comparable[])new EnumProperties.StorageUsed[]{state}));
            }
            addDirectionalParts.accept("block/storage_box_void", part -> part.condition((Property)StorageBox.VOID_UPGRADE, (Comparable[])new Boolean[]{true}));
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, SimpleStorageBox>, RegistrateBlockstateProvider> simpleStorageBox(Block planks) {
        return (ctx, prov) -> ModBlockstateHelper.generateSimpleStorageBox((DataGenContext<Block, SimpleStorageBox>)ctx, prov, planks);
    }

    public static NonNullBiConsumer<DataGenContext<Block, SimpleStorageBox>, RegistrateBlockstateProvider> simpleStorageBox(Supplier<? extends Block> planks) {
        return (ctx, prov) -> ModBlockstateHelper.generateSimpleStorageBox((DataGenContext<Block, SimpleStorageBox>)ctx, prov, (Block)planks.get());
    }

    private static void generateSimpleStorageBox(DataGenContext<Block, SimpleStorageBox> ctx, RegistrateBlockstateProvider prov, Block planks) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)planks).getPath();
        String woodType = path.substring(0, path.indexOf("_planks"));
        ModModelHelper.simpleStorageBox(prov, woodType);
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/" + woodType + "_simple_storage_box_base"))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageBox.FACING, (Comparable[])new Direction[]{Direction.byName((String)dir.getName())}).end();
        }
        for (EnumProperties.StorageUsed state : EnumProperties.StorageUsed.values()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/storage_box_" + state.getSerializedName()))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageBox.FACING, (Comparable[])new Direction[]{Direction.byName((String)dir.getName())}).condition(StorageBox.STORAGE_USED, (Comparable[])new EnumProperties.StorageUsed[]{state}).end();
            }
        }
    }

    public static NonNullBiConsumer<DataGenContext<Block, CasingBlock>, RegistrateBlockstateProvider> storageTrim(String name) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll("block/" + ctx.getName(), FXNTStorage.modLoc("block/casings/" + name + "_casing")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, BackpackBlock>, RegistrateBlockstateProvider> backpack(String name) {
        return (ctx, prov) -> {
            Object type;
            Object object = type = name.equals("industrial_iron") ? "" : name + "_";
            if (!name.equals("industrial_iron")) {
                ModModelHelper.backpack(prov, name);
            }
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/" + (String)type + "backpack"))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageBox.FACING, (Comparable[])new Direction[]{Direction.byName((String)dir.getName())}).end();
            }
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, StorageController>, RegistrateBlockstateProvider> storageController() {
        return (ctx, prov) -> {
            ((BlockModelBuilder)prov.models().cube("storage_controller", FXNTStorage.modLoc("block/storage_controller_top"), FXNTStorage.modLoc("block/storage_controller_top"), FXNTStorage.modLoc("block/storage_controller_front"), FXNTStorage.modLoc("block/storage_controller_side"), FXNTStorage.modLoc("block/storage_controller_side"), FXNTStorage.modLoc("block/storage_controller_side"))).texture("particle", FXNTStorage.modLoc("block/storage_controller_side"));
            ((BlockModelBuilder)prov.models().withExistingParent("storage_controller_connected", FXNTStorage.modLoc("storage_controller"))).texture("north", FXNTStorage.modLoc("block/storage_controller_front_connected"));
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/storage_controller"))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageBox.FACING, (Comparable[])new Direction[]{Direction.byName((String)dir.getName())}).end();
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/storage_controller_connected"))).rotationY(ModBlockstateHelper.getRotationForDirection(dir)).addModel()).condition((Property)StorageController.FACING, (Comparable[])new Direction[]{Direction.byName((String)dir.getName())}).condition((Property)StorageController.CONNECTED, (Comparable[])new Boolean[]{true}).end();
            }
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, StorageInterface>, RegistrateBlockstateProvider> storageInterface() {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().cubeBottomTop("storage_interface", FXNTStorage.modLoc("block/storage_interface_side"), FXNTStorage.modLoc("block/storage_interface_top"), FXNTStorage.modLoc("block/storage_interface_top"))).texture("particle", FXNTStorage.modLoc("block/storage_interface_top")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, PasserBlock>, RegistrateBlockstateProvider> passerBlock(boolean isSmart) {
        return (ctx, prov) -> {
            boolean[] poweredStates;
            boolean[] blArray;
            if (isSmart) {
                ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_powered", prov.modLoc("block/smart_passer_block"))).texture("main", prov.modLoc("block/smart_passer_block_powered"));
            }
            VariantBlockStateBuilder builder = prov.getVariantBuilder((Block)ctx.get());
            if (isSmart) {
                boolean[] blArray2 = new boolean[2];
                blArray2[0] = false;
                blArray = blArray2;
                blArray2[1] = true;
            } else {
                boolean[] blArray3 = new boolean[1];
                blArray = blArray3;
                blArray3[0] = false;
            }
            for (boolean powered : poweredStates = blArray) {
                for (Direction dir : Direction.values()) {
                    String modelName = isSmart ? "block/smart_passer_block" + (powered ? "_powered" : "") : "block/passer_block";
                    ConfiguredModel.Builder model = ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc(modelName)));
                    switch (dir) {
                        case UP: {
                            model.rotationX(180);
                            break;
                        }
                        case SOUTH: {
                            model.rotationX(90);
                            break;
                        }
                        case WEST: {
                            model.rotationX(90).rotationY(90);
                            break;
                        }
                        case NORTH: {
                            model.rotationX(90).rotationY(180);
                            break;
                        }
                        case EAST: {
                            model.rotationX(90).rotationY(270);
                        }
                    }
                    (isSmart ? builder.partialState().with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)) : builder.partialState()).with((Property)BlockStateProperties.FACING, (Comparable)dir).addModels(model.build());
                }
            }
        };
    }

    private static int getRotationForDirection(Direction dir) {
        return (dir.get2DDataValue() * 90 + 180) % 360;
    }
}

