/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.datagen.helper;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Supplier;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.controller.StorageController;
import net.fxnt.fxntstorage.controller.StorageInterface;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.passer.PasserBlock;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class ModRecipeHelper {
    public static NonNullBiConsumer<DataGenContext<Block, StorageBox>, RegistrateRecipeProvider> storageBox(Supplier<? extends Block> supplier) {
        return (ctx, prov) -> {
            Block casing = (Block)supplier.get();
            String path = BuiltInRegistries.BLOCK.getKey((Object)casing).getPath();
            String casingName = casing.equals(AllBlocks.INDUSTRIAL_IRON_BLOCK.get()) ? "" : path.substring(0, path.indexOf("_")).replace("railway", "hardened") + "_";
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('C'), (ItemLike)casing).define(Character.valueOf('D'), (ItemLike)AllBlocks.DISPLAY_BOARD).define(Character.valueOf('V'), (ItemLike)AllBlocks.ITEM_VAULT).pattern("CCC").pattern("CVC").pattern("CDC").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/storage_box/" + casingName + "storage_box"));
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, SimpleStorageBox>, RegistrateRecipeProvider> simpleStorageBox(Block planks) {
        return (ctx, prov) -> ModRecipeHelper.generateSimpleStorageBox((DataGenContext<Block, SimpleStorageBox>)ctx, prov, planks);
    }

    public static NonNullBiConsumer<DataGenContext<Block, SimpleStorageBox>, RegistrateRecipeProvider> simpleStorageBox(Supplier<? extends Block> planks) {
        return (ctx, prov) -> ModRecipeHelper.generateSimpleStorageBox((DataGenContext<Block, SimpleStorageBox>)ctx, prov, (Block)planks.get());
    }

    private static void generateSimpleStorageBox(DataGenContext<Block, SimpleStorageBox> ctx, RegistrateRecipeProvider prov, Block planks) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)planks).getPath();
        String woodType = path.substring(0, path.indexOf("_planks"));
        ResourceLocation planksId = BuiltInRegistries.BLOCK.getKey((Object)planks);
        RegistrateRecipeProvider output = prov;
        if (planksId.getNamespace().equals("vanillabackport")) {
            output = prov.withConditions(new ICondition[]{new ModLoadedCondition("vanillabackport")});
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('A'), (ItemLike)AllItems.ANDESITE_ALLOY).define(Character.valueOf('D'), (ItemLike)AllBlocks.DISPLAY_BOARD).define(Character.valueOf('V'), (ItemLike)AllBlocks.ITEM_VAULT).define(Character.valueOf('W'), (ItemLike)planks).pattern("AWA").pattern("WVW").pattern("ADA").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)output, FXNTStorage.modLoc("crafting_shaped/simple_storage_box/" + woodType + "_simple_storage_box"));
    }

    public static NonNullBiConsumer<DataGenContext<Block, CasingBlock>, RegistrateRecipeProvider> storageTrim(Block planks) {
        return (ctx, prov) -> ModRecipeHelper.genStorageTrim((DataGenContext<Block, CasingBlock>)ctx, prov, planks);
    }

    public static NonNullBiConsumer<DataGenContext<Block, CasingBlock>, RegistrateRecipeProvider> storageTrim(Supplier<? extends Block> planks) {
        return (ctx, prov) -> ModRecipeHelper.genStorageTrim((DataGenContext<Block, CasingBlock>)ctx, prov, (Block)planks.get());
    }

    public static void genStorageTrim(DataGenContext<Block, CasingBlock> ctx, RegistrateRecipeProvider prov, Block planks) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)planks).getPath();
        String woodType = path.substring(0, path.indexOf("_planks"));
        ResourceLocation planksId = BuiltInRegistries.BLOCK.getKey((Object)planks);
        RegistrateRecipeProvider output = prov;
        if (planksId.getNamespace().equals("vanillabackport")) {
            output = prov.withConditions(new ICondition[]{new ModLoadedCondition("vanillabackport")});
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)4).define(Character.valueOf('A'), (ItemLike)AllItems.ANDESITE_ALLOY).define(Character.valueOf('W'), (ItemLike)planks).pattern("AWA").pattern("W W").pattern("AWA").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)output, FXNTStorage.modLoc("crafting_shaped/storage_trim/" + woodType + "_storage_trim"));
    }

    public static NonNullBiConsumer<DataGenContext<Block, PasserBlock>, RegistrateRecipeProvider> passer(boolean isSmart) {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('X'), (ItemLike)(isSmart ? AllBlocks.SMART_CHUTE : AllBlocks.CHUTE)).define(Character.valueOf('Y'), (ItemLike)Items.REDSTONE).define(Character.valueOf('Z'), (ItemLike)Items.HOPPER).pattern("X").pattern("Y").pattern("Z").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/" + ctx.getName()));
    }

    public static NonNullBiConsumer<DataGenContext<Block, BackpackBlock>, RegistrateRecipeProvider> backpack() {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('C'), (ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('V'), (ItemLike)AllBlocks.ITEM_VAULT).pattern("SCS").pattern("LVL").pattern("CCC").group("backpack").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/" + ctx.getName()));
    }

    public static NonNullBiConsumer<DataGenContext<Item, UpgradeItem>, RegistrateRecipeProvider> backpackUpgradeBlock(Supplier<? extends Block> supplier) {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('B'), ModItems.BACKPACK_BLANK_UPGRADE).define(Character.valueOf('R'), (ItemLike)AllBlocks.REDSTONE_LINK).define(Character.valueOf('I'), (ItemLike)AllItems.IRON_SHEET).define(Character.valueOf('X'), (ItemLike)supplier.get()).pattern(" R ").pattern("IBI").pattern(" X ").group("backpack").unlockedBy("has_blank_upgrade", RegistrateRecipeProvider.has(ModItems.BACKPACK_BLANK_UPGRADE)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/backpack_upgrade/" + ctx.getName()));
    }

    public static NonNullBiConsumer<DataGenContext<Item, UpgradeItem>, RegistrateRecipeProvider> backpackUpgradeItem(Supplier<? extends Item> supplier) {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('B'), ModItems.BACKPACK_BLANK_UPGRADE).define(Character.valueOf('R'), (ItemLike)AllBlocks.REDSTONE_LINK).define(Character.valueOf('I'), (ItemLike)AllItems.IRON_SHEET).define(Character.valueOf('X'), (ItemLike)supplier.get()).pattern(" R ").pattern("IBI").pattern(" X ").group("backpack").unlockedBy("has_blank_upgrade", RegistrateRecipeProvider.has(ModItems.BACKPACK_BLANK_UPGRADE)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/backpack_upgrade/" + ctx.getName()));
    }

    public static NonNullBiConsumer<DataGenContext<Block, StorageController>, RegistrateRecipeProvider> storageController() {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('X'), (ItemLike)AllBlocks.REDSTONE_LINK).define(Character.valueOf('Y'), (ItemLike)AllBlocks.BRASS_CASING).define(Character.valueOf('Z'), (ItemLike)AllItems.ELECTRON_TUBE).pattern("X").pattern("Y").pattern("Z").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/" + ctx.getName()));
    }

    public static NonNullBiConsumer<DataGenContext<Block, StorageInterface>, RegistrateRecipeProvider> storageInterface() {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).define(Character.valueOf('X'), (ItemLike)AllBlocks.REDSTONE_LINK).define(Character.valueOf('Y'), (ItemLike)AllBlocks.BRASS_CASING).pattern("X").pattern("Y").group("storage_box").unlockedBy("has_andesite_alloy", RegistrateRecipeProvider.has((ItemLike)AllItems.ANDESITE_ALLOY)).save((RecipeOutput)prov, FXNTStorage.modLoc("crafting_shaped/" + ctx.getName()));
    }
}

