/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.network.handler;

import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackOnBackUpgradeHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedStorage;
import net.fxnt.fxntstorage.network.packet.CrossbowChargedPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFlyingPacket;
import net.fxnt.fxntstorage.network.packet.KeyPressedPacket;
import net.fxnt.fxntstorage.network.packet.PickBlockUpgradePacket;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.network.packet.SortInventoryPacket;
import net.fxnt.fxntstorage.network.packet.SyncClientSettingsPacket;
import net.fxnt.fxntstorage.network.packet.SyncItemStackPacket;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedStorage;
import net.fxnt.fxntstorage.util.EventHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ServerPayloadHandler {
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleCrossbowChargedPacket(CrossbowChargedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> EventHandler.consumeArrowFromBackpack(context.player()));
    }

    public void handleKeyPressedPacket(KeyPressedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            switch (packet.hotKey()) {
                case 0: {
                    JetpackManager.getJetpackHandler((Player)player).flyingOnKeyPress();
                    break;
                }
                case 1: {
                    JetpackManager.getJetpackHandler((Player)player).flyingOnKeyRelease();
                    break;
                }
                case 2: {
                    BackpackHandler.openBackpackFromInventory(player, (byte)1);
                    break;
                }
                case 3: {
                    if (!(player.containerMenu instanceof BackpackMenu)) break;
                    player.closeContainer();
                    break;
                }
                case 4: {
                    AbstractContainerMenu patt0$temp = player.containerMenu;
                    if (!(patt0$temp instanceof BackpackMenu)) break;
                    BackpackMenu backpackMenu = (BackpackMenu)patt0$temp;
                    backpackMenu.ctrlKeyDown = packet.pressed();
                    break;
                }
                case 5: {
                    JetpackHandler jetpackHandler = JetpackManager.getJetpackHandler((Player)player);
                    if (!(jetpackHandler.calculateJetPackFuel((Player)player) > 0.0)) break;
                    jetpackHandler.toggleHover();
                    break;
                }
                case 6: {
                    player.getPersistentData().getCompound("fxntstorageSettings").putBoolean("MineAllBlocks", packet.pressed());
                }
            }
        });
    }

    public void handlePickBlockUpgradePacket(PickBlockUpgradePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            new BackpackOnBackUpgradeHandler((Player)player).applyPickBlockUpgrade(packet.stack());
        });
    }

    public void handlePlayerInputPacket(PlayerInputPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            JetpackManager.getJetpackHandler((Player)player).processPlayerInputPacket(packet.forwardImpulse(), packet.leftImpulse());
        });
    }

    public void handleSortInventoryPacket(SortInventoryPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu menu;
            AbstractContainerMenu patt0$temp;
            ServerPlayer player = (ServerPlayer)context.player();
            if (packet.invType() == 0 && (patt0$temp = player.containerMenu) instanceof BackpackMenu) {
                menu = (BackpackMenu)patt0$temp;
                menu.sortBackpackItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
            }
            if (packet.invType() == 1) {
                AbstractContainerMenu patt2$temp;
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (patt1$temp instanceof StorageBoxMenu) {
                    menu = (StorageBoxMenu)patt1$temp;
                    menu.sortStorageItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
                }
                if ((patt2$temp = player.containerMenu) instanceof StorageBoxMountedMenu) {
                    menu = (StorageBoxMountedMenu)patt2$temp;
                    menu.sortStorageItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
                }
            }
        });
    }

    public void handleSyncClientSettingsPacket(SyncClientSettingsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            CompoundTag settings = packet.settings();
            CompoundTag settingsTag = net.fxnt.fxntstorage.util.Util.getOrCreateSubTag(player.getPersistentData(), "fxntstorageSettings");
            settingsTag.merge(settings);
        });
    }

    public void handleSetSortOrderPacket(SetSortOrderPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2$temp;
            AbstractContainerMenu patt1$temp;
            AbstractContainerMenu menu;
            ServerPlayer player = (ServerPlayer)context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BackpackMenu) {
                menu = (BackpackMenu)patt0$temp;
                menu.container.setSortOrder(packet.sortOrder());
                menu.container.setDataChanged();
            }
            if ((patt1$temp = player.containerMenu) instanceof StorageBoxMenu) {
                menu = (StorageBoxMenu)patt1$temp;
                menu.setSortOrder(packet.sortOrder());
            }
            if ((patt2$temp = player.containerMenu) instanceof StorageBoxMountedMenu) {
                menu = (StorageBoxMountedMenu)patt2$temp;
                menu.setSortOrder(packet.sortOrder());
            }
        });
    }

    public void handleSetMountedStorageDirtyPacket(SetMountedStorageDirtyPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            Entity entity = player.level().getEntity(packet.entityId());
            if (entity instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
                MountedItemStorage storage = (MountedItemStorage)contraptionEntity.getContraption().getStorage().getAllItemStorages().get((Object)packet.localPos());
                if (storage instanceof SimpleStorageBoxMountedStorage) {
                    ((SimpleStorageBoxMountedStorage)storage).markDirty();
                } else if (storage instanceof StorageBoxMountedStorage) {
                    ((StorageBoxMountedStorage)storage).markDirty();
                }
            }
        });
    }

    public void handleTransferRecipePacket(TransferRecipePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            List inputSlots;
            AbstractContainerMenu patt0$temp;
            ServerPlayer player = (ServerPlayer)context.player();
            Level level = player.level();
            Optional optional = level.getRecipeManager().byKey(packet.recipeId());
            if (optional.isEmpty()) {
                FXNTStorage.LOGGER.warn("Recipe not found: {}", (Object)packet.recipeId());
                return;
            }
            Recipe recipe = ((RecipeHolder)optional.get()).value();
            Inventory playerInv = player.getInventory();
            ItemStackHandler itemHandler = null;
            BackpackContainer container = null;
            ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
            if (!backpack.isEmpty()) {
                container = new BackpackContainer(backpack, (Player)player);
                itemHandler = container.getItemHandler();
            }
            if ((patt0$temp = player.containerMenu) instanceof CraftingMenu) {
                CraftingMenu openMenu = (CraftingMenu)patt0$temp;
                inputSlots = openMenu.slots.subList(1, 10);
            } else {
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (patt1$temp instanceof StonecutterMenu) {
                    StonecutterMenu openMenu = (StonecutterMenu)patt1$temp;
                    inputSlots = openMenu.slots.subList(0, 1);
                } else {
                    AbstractContainerMenu patt2$temp = player.containerMenu;
                    if (patt2$temp instanceof InventoryMenu) {
                        InventoryMenu openMenu = (InventoryMenu)patt2$temp;
                        inputSlots = openMenu.slots.subList(1, 5);
                    } else {
                        return;
                    }
                }
            }
            for (Slot slot : inputSlots) {
                ItemStack stack;
                if (!slot.mayPickup((Player)player) || !slot.hasItem() || playerInv.add(stack = slot.remove(slot.getItem().getCount()))) continue;
                player.drop(stack, false);
            }
            List<Ingredient> ingredients = recipe.getIngredients().stream().filter(ingredient -> !ingredient.isEmpty()).toList();
            List<Integer> recipeMap = packet.recipeList();
            int maxCraftable = 1;
            if (packet.maxTransfer()) {
                maxCraftable = this.getMaxCraftableItems(ingredients, playerInv, (IItemHandler)itemHandler);
                if (!FMLEnvironment.production) {
                    player.displayClientMessage((Component)Component.literal((String)("\u00a7a" + maxCraftable + "\u00a7r maximum craftable")), false);
                }
            }
            boolean twoByTwo = false;
            boolean symmetrical = false;
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe sr = (ShapedRecipe)recipe;
                twoByTwo = sr.getHeight() <= 2 && sr.getWidth() <= 2 && player.containerMenu instanceof InventoryMenu;
                symmetrical = Util.isSymmetrical((int)sr.getWidth(), (int)sr.getHeight(), (List)sr.getIngredients());
            }
            int offsetX = 0;
            int offsetY = 0;
            boolean isShaped = recipe instanceof ShapedRecipe;
            boolean doCenter = false;
            if (!twoByTwo && isShaped && symmetrical) {
                ShapedRecipe sr = (ShapedRecipe)recipe;
                offsetX = (3 - sr.getWidth()) / 2;
                offsetY = (3 - sr.getHeight()) / 2;
                doCenter = true;
            }
            for (int ingredientIndex = 0; ingredientIndex < ingredients.size() && ingredientIndex < recipeMap.size(); ++ingredientIndex) {
                ItemStack extracted;
                int extractAmount;
                ItemStack stack;
                int j;
                int slotPosition;
                Ingredient ingredient2;
                block36: {
                    int gridSlotPosition;
                    block35: {
                        ingredient2 = ingredients.get(ingredientIndex);
                        if (ingredient2.isEmpty()) continue;
                        gridSlotPosition = recipeMap.get(ingredientIndex) - 1;
                        if (!twoByTwo) break block35;
                        switch (gridSlotPosition) {
                            case 0: {
                                slotPosition = 0;
                                break block36;
                            }
                            case 1: {
                                slotPosition = 1;
                                break block36;
                            }
                            case 3: {
                                slotPosition = 2;
                                break block36;
                            }
                            case 4: {
                                slotPosition = 3;
                                break block36;
                            }
                        }
                        continue;
                    }
                    if (doCenter) {
                        int x = gridSlotPosition % 3;
                        int y = gridSlotPosition / 3;
                        slotPosition = (y += offsetY) * 3 + (x += offsetX);
                    } else {
                        slotPosition = gridSlotPosition;
                    }
                }
                if (slotPosition < 0 || slotPosition >= inputSlots.size()) continue;
                ItemStack collected = ItemStack.EMPTY;
                int remaining = maxCraftable;
                for (j = 0; j < playerInv.getContainerSize() && remaining > 0; ++j) {
                    stack = playerInv.getItem(j);
                    if (stack.isEmpty() || !ingredient2.test(stack)) continue;
                    extractAmount = Math.min(stack.getCount(), remaining);
                    extracted = stack.split(extractAmount);
                    if (collected.isEmpty()) {
                        collected = extracted.copy();
                    } else {
                        collected.grow(extracted.getCount());
                    }
                    playerInv.setItem(j, stack);
                    remaining -= extracted.getCount();
                }
                if (remaining > 0 && itemHandler != null) {
                    for (j = 0; j < net.fxnt.fxntstorage.util.Util.ITEM_SLOT_END_RANGE && remaining > 0; ++j) {
                        stack = itemHandler.getStackInSlot(j);
                        if (stack.isEmpty() || !ingredient2.test(stack)) continue;
                        extractAmount = Math.min(stack.getCount(), remaining);
                        extracted = stack.split(extractAmount);
                        if (collected.isEmpty()) {
                            collected = extracted.copy();
                        } else {
                            collected.grow(extracted.getCount());
                        }
                        itemHandler.setStackInSlot(j, stack);
                        remaining -= extracted.getCount();
                    }
                }
                if (collected.isEmpty() || collected.getCount() < maxCraftable) {
                    return;
                }
                ((Slot)inputSlots.get(slotPosition)).setByPlayer(collected);
            }
            AbstractContainerMenu handler = player.containerMenu;
            Slot output = handler.getSlot(0);
            if (packet.action() == 1) {
                handler.clicked(output.getContainerSlot(), 0, ClickType.PICKUP, (Player)player);
            } else if (packet.action() == 2) {
                handler.clicked(output.getContainerSlot(), 0, ClickType.QUICK_MOVE, (Player)player);
            }
            player.containerMenu.broadcastChanges();
            if (container != null) {
                container.setDataChanged();
            }
            if (itemHandler != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncItemStackPacket(backpack.getComponents()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    private int getMaxCraftableItems(List<Ingredient> ingredients, Inventory inventory, @Nullable IItemHandler backpack) {
        int maxCrafts = 64;
        HashMap<Ingredient, Integer> ingredientCounts = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ingredientCounts.merge(ingredient, 1, Integer::sum);
        }
        for (Map.Entry entry : ingredientCounts.entrySet()) {
            int craftsForIngredient;
            ItemStack stack;
            int i;
            Ingredient ingredient = (Ingredient)entry.getKey();
            int requiredPerCraft = (Integer)entry.getValue();
            int available = 0;
            int ingredientMaxStackSize = 64;
            for (i = 0; i < inventory.getContainerSize(); ++i) {
                stack = inventory.getItem(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                available += stack.getCount();
                ingredientMaxStackSize = Math.min(ingredientMaxStackSize, stack.getMaxStackSize());
            }
            if (backpack != null) {
                for (i = 0; i < backpack.getSlots(); ++i) {
                    stack = backpack.getStackInSlot(i);
                    if (stack.isEmpty() || !ingredient.test(stack)) continue;
                    available += stack.getCount();
                    ingredientMaxStackSize = Math.min(ingredientMaxStackSize, stack.getMaxStackSize());
                }
            }
            if ((maxCrafts = Math.min(maxCrafts, craftsForIngredient = Math.min(available / requiredPerCraft, ingredientMaxStackSize))) != 0) continue;
            break;
        }
        return maxCrafts;
    }

    public void handleJetpackFlyingPacket(JetpackFlyingPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            JetpackManager.getJetpackHandler((Player)player).processPlayerFlyingPacket(packet.flying(), packet.hovering());
        });
    }
}

