/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.passer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.fxnt.fxntstorage.passer.PasserBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PasserFilteringBox
extends ValueBoxTransform.Sided {
    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)PasserBlock.FACING);
        Direction side = this.getSide();
        float horizontalAngle = AngleHelper.horizontalAngle((Direction)side);
        Vec3 location = Vec3.ZERO;
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> VecHelper.rotateCentered((Vec3)VecHelper.voxelSpace((double)8.0, (double)12.0, (double)12.5), (double)horizontalAngle, (Direction.Axis)Direction.Axis.Y);
            case Direction.UP -> VecHelper.rotateCentered((Vec3)VecHelper.voxelSpace((double)8.0, (double)4.0, (double)12.5), (double)horizontalAngle, (Direction.Axis)Direction.Axis.Y);
            case Direction.NORTH -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UP: {
                        yield VecHelper.voxelSpace((double)8.0, (double)12.5, (double)12.0);
                    }
                    case DOWN: {
                        yield VecHelper.voxelSpace((double)8.0, (double)3.5, (double)12.0);
                    }
                    case EAST: {
                        yield VecHelper.voxelSpace((double)12.5, (double)8.0, (double)12.0);
                    }
                    case WEST: {
                        yield VecHelper.voxelSpace((double)3.5, (double)8.0, (double)12.0);
                    }
                    case NORTH: 
                    case SOUTH: 
                }
                yield location;
            }
            case Direction.SOUTH -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UP: {
                        yield VecHelper.voxelSpace((double)8.0, (double)12.5, (double)4.0);
                    }
                    case DOWN: {
                        yield VecHelper.voxelSpace((double)8.0, (double)3.5, (double)4.0);
                    }
                    case EAST: {
                        yield VecHelper.voxelSpace((double)12.5, (double)8.0, (double)4.0);
                    }
                    case WEST: {
                        yield VecHelper.voxelSpace((double)3.5, (double)8.0, (double)4.0);
                    }
                    case NORTH: 
                    case SOUTH: 
                }
                yield location;
            }
            case Direction.EAST -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UP: {
                        yield VecHelper.voxelSpace((double)4.0, (double)12.5, (double)8.0);
                    }
                    case DOWN: {
                        yield VecHelper.voxelSpace((double)4.0, (double)3.5, (double)8.0);
                    }
                    case NORTH: {
                        yield VecHelper.voxelSpace((double)4.0, (double)8.0, (double)3.5);
                    }
                    case SOUTH: {
                        yield VecHelper.voxelSpace((double)4.0, (double)8.0, (double)12.5);
                    }
                    case EAST: 
                    case WEST: 
                }
                yield location;
            }
            case Direction.WEST -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UP: {
                        yield VecHelper.voxelSpace((double)12.0, (double)12.5, (double)8.0);
                    }
                    case DOWN: {
                        yield VecHelper.voxelSpace((double)12.0, (double)3.5, (double)8.0);
                    }
                    case NORTH: {
                        yield VecHelper.voxelSpace((double)12.0, (double)8.0, (double)3.5);
                    }
                    case SOUTH: {
                        yield VecHelper.voxelSpace((double)12.0, (double)8.0, (double)12.5);
                    }
                    case EAST: 
                    case WEST: 
                }
                yield location;
            }
        };
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        Direction facing = (Direction)state.getValue((Property)PasserBlock.FACING);
        Direction side = this.getSide();
        float yRot = AngleHelper.horizontalAngle((Direction)side) + 180.0f;
        float xRot = side == Direction.UP ? 90.0f : (side == Direction.DOWN ? 270.0f : 0.0f);
        switch (facing) {
            case NORTH: {
                yRot = side == Direction.UP ? 0.0f : yRot;
                break;
            }
            case SOUTH: {
                yRot = side == Direction.DOWN ? 0.0f : yRot;
                break;
            }
            case EAST: {
                yRot = side == Direction.UP ? 270.0f : (side == Direction.DOWN ? 90.0f : yRot);
                break;
            }
            case WEST: {
                yRot = side == Direction.UP ? 90.0f : (side == Direction.DOWN ? 270.0f : yRot);
            }
        }
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
    }

    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = (Direction)state.getValue((Property)PasserBlock.FACING);
        if (facing == Direction.UP || facing == Direction.DOWN) {
            return direction.getAxis().isHorizontal();
        }
        return direction != facing && direction != facing.getOpposite();
    }

    protected Vec3 getSouthLocation() {
        return Vec3.ZERO;
    }
}

