/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage;

import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.utility.CreateLang;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class SimpleStorageBoxEntity
extends BlockEntity
implements MenuProvider,
Nameable,
ThresholdSwitchObservable {
    private int tickCount = 0;
    private Component customName;
    public static final int BASE_CAPACITY = 32;
    public static final int ITEM_STACK_SIZE = 64;
    public int maxItemCapacity = 2048;
    public int storedAmount = 0;
    public boolean voidUpgrade = false;
    public static final int VOID_UPGRADE_SLOT = 1;
    public static final int CAPACITY_UPGRADE_SLOT_START = 2;
    public static final int MAX_CAPACITY_UPGRADES = 9;
    public static final int BASE_SLOT_COUNT = 2;
    public static int SLOT_COUNT = 11;
    public ItemStack filterItem = ItemStack.EMPTY;
    public boolean isPlayerInteraction = false;
    private boolean storageSlotChanged = false;
    private boolean upgradeSlotChanged = false;
    private final ItemStackHandler itemHandler = this.createItemHandler(SLOT_COUNT);
    private final Lazy<IItemHandlerModifiable> lazyItemHandler = Lazy.of(() -> this.itemHandler);

    public SimpleStorageBoxEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    private ItemStackHandler createItemHandler(int slotCount) {
        return new ItemStackHandler(slotCount){

            protected void onContentsChanged(int slot) {
                SimpleStorageBoxEntity.this.setChanged();
                if (slot < 1) {
                    SimpleStorageBoxEntity.this.storageSlotChanged = true;
                }
                if (slot >= 1) {
                    SimpleStorageBoxEntity.this.upgradeSlotChanged = true;
                }
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ItemStack amount = super.insertItem(slot, stack, simulate);
                if (((ItemStack)this.stacks.getFirst()).getCount() >= SimpleStorageBoxEntity.this.maxItemCapacity && SimpleStorageBoxEntity.this.voidUpgrade) {
                    return ItemStack.EMPTY;
                }
                return SimpleStorageBoxEntity.this.voidUpgrade || simulate && amount.getCount() < stack.getCount() ? ItemStack.EMPTY : amount;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (SimpleStorageBoxEntity.this.isPlayerInteraction || slot < 1) {
                    if (amount == 0) {
                        return ItemStack.EMPTY;
                    }
                    this.validateSlotIndex(slot);
                    ItemStack existing = (ItemStack)this.stacks.get(slot);
                    if (existing.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                    int toExtract = Math.min(amount, SimpleStorageBoxEntity.this.maxItemCapacity);
                    if (existing.getCount() <= toExtract) {
                        if (!simulate) {
                            this.stacks.set(slot, (Object)ItemStack.EMPTY);
                            this.onContentsChanged(slot);
                            return existing;
                        }
                        return existing.copy();
                    }
                    if (!simulate) {
                        this.stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
                        this.onContentsChanged(slot);
                    }
                    return existing.copyWithCount(toExtract);
                }
                return ItemStack.EMPTY;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (stack.is(ModTags.Items.STORAGE_BOX_UPGRADE) && !SimpleStorageBoxEntity.this.isPlayerInteraction) {
                    return false;
                }
                if (SimpleStorageBoxEntity.this.filterTest(stack)) {
                    if (slot > 0) {
                        return false;
                    }
                    if (SimpleStorageBoxEntity.this.voidUpgrade) {
                        return true;
                    }
                    return ((ItemStack)this.stacks.getFirst()).getCount() < SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return false;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                if (slot == 0) {
                    return SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return super.getStackLimit(slot, stack);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return SimpleStorageBoxEntity.this.maxItemCapacity;
                }
                return super.getSlotLimit(slot);
            }
        };
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.lazyItemHandler.get();
    }

    public int getCapacityUpgrades() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!this.itemHandler.getStackInSlot(i).is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        return upgradeCount;
    }

    public boolean hasVoidUpgrade() {
        this.voidUpgrade = this.itemHandler.getStackInSlot(1).is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
        return this.voidUpgrade;
    }

    public int getStoredAmount() {
        this.storedAmount = this.itemHandler.getStackInSlot(0).getCount();
        return this.storedAmount;
    }

    public int getMaxItemCapacity() {
        int capacity = 32 << this.getCapacityUpgrades();
        int stackSize = this.filterItem.isEmpty() ? 64 : this.filterItem.getMaxStackSize();
        this.maxItemCapacity = capacity * stackSize;
        return this.maxItemCapacity;
    }

    public void setUpgradeSlotChanged(boolean hasChanged) {
        this.upgradeSlotChanged = hasChanged;
    }

    public Component getName() {
        return this.customName;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.customName != null ? this.customName : this.getBlockState().getBlock().getName();
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setPlayerInteraction(boolean isPlayer) {
        this.isPlayerInteraction = isPlayer;
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.customName = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        this.readInventory((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getStacks()));
    }

    public void readInventory(ItemContainerContents contents) {
        List itemStacks = contents.stream().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemStacks.get(i));
        }
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    public void setChanged() {
        super.setChanged();
        this.storageSlotChanged = true;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("MaxItemCapacity", this.getMaxItemCapacity());
        tag.putInt("StoredAmount", this.getStoredAmount());
        tag.putBoolean("VoidUpgrade", this.hasVoidUpgrade());
        if (!this.filterItem.isEmpty()) {
            tag.put("FilterItem", this.filterItem.copyWithCount(1).saveOptional(registries));
        }
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag itemsTag;
        int oldSize;
        super.loadAdditional(tag, registries);
        this.maxItemCapacity = tag.getInt("MaxItemCapacity");
        this.storedAmount = tag.getInt("StoredAmount");
        this.voidUpgrade = tag.getBoolean("VoidUpgrade");
        CompoundTag filterTag = tag.getCompound("FilterItem");
        ItemStack itemStack = this.filterItem = filterTag.isEmpty() ? ItemStack.EMPTY : ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)filterTag);
        if (tag.contains("CustomName", 8)) {
            this.customName = SimpleStorageBoxEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        if ((oldSize = (itemsTag = tag.getCompound("Items")).getInt("Size")) != SLOT_COUNT) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Simple Storage Box at {}", (Object)this.worldPosition);
            if (oldSize == 0) {
                ListTag existingItems = tag.getList("Items", 10);
                oldSize = tag.getInt("slotCount");
                CompoundTag newTag = new CompoundTag();
                newTag.putInt("Size", oldSize);
                newTag.put("Items", (Tag)existingItems);
                itemsTag = newTag;
                this.maxItemCapacity = tag.getInt("maxItemCapacity");
                this.storedAmount = tag.getInt("storedAmount");
                this.voidUpgrade = tag.getBoolean("voidUpgrade");
            }
            this.migrateSlotItems(itemsTag, registries, oldSize);
        } else {
            this.itemHandler.deserializeNBT(registries, tag.getCompound("Items"));
        }
    }

    private void migrateSlotItems(CompoundTag itemsTag, HolderLookup.Provider registries, int oldSize) {
        ItemStackHandler oldHandler = new ItemStackHandler(oldSize);
        oldHandler.deserializeNBT(registries, itemsTag);
        this.migrateSlotItems(oldHandler);
    }

    private void migrateSlotItems(ItemStackHandler oldHandler) {
        ItemStack slot0 = oldHandler.getStackInSlot(0);
        ItemStack slot1 = oldHandler.getStackInSlot(1);
        if (!slot0.isEmpty() || !slot1.isEmpty()) {
            ItemStack merged = slot0.copy();
            int totalCount = slot0.getCount() + slot1.getCount();
            merged.setCount(Math.min(totalCount, this.maxItemCapacity));
            this.itemHandler.setStackInSlot(0, merged);
        }
        this.itemHandler.setStackInSlot(1, oldHandler.getStackInSlot(3).copy());
        for (int oldSlot = 4; oldSlot <= 12; ++oldSlot) {
            int newSlot = oldSlot - 4 + 2;
            if (newSlot >= this.itemHandler.getSlots()) continue;
            this.itemHandler.setStackInSlot(newSlot, oldHandler.getStackInSlot(oldSlot).copy());
        }
        this.setChanged();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void forceTick() {
        this.tickCount = 999;
    }

    public void serverTick(Level level) {
        if (level.isClientSide) {
            return;
        }
        if (this.upgradeSlotChanged) {
            this.getMaxItemCapacity();
        }
        if (this.storageSlotChanged) {
            this.getStoredAmount();
            ItemStack slot0 = this.itemHandler.getStackInSlot(0);
            if (!slot0.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)slot0, (ItemStack)this.filterItem) && this.filterItem.isEmpty()) {
                this.setFilter(slot0);
            }
        }
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.STORAGE_BOX_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        if (this.storageSlotChanged || this.upgradeSlotChanged) {
            this.updateBlockState(level);
            this.upgradeSlotChanged = false;
            this.storageSlotChanged = false;
        }
    }

    private void updateBlockState(Level level) {
        BlockState currentState = this.getBlockState();
        EnumProperties.StorageUsed status = EnumProperties.StorageUsed.EMPTY;
        if (this.storedAmount >= this.maxItemCapacity) {
            status = EnumProperties.StorageUsed.FULL;
        } else if (this.storedAmount > 0) {
            status = EnumProperties.StorageUsed.HAS_ITEMS;
        }
        BlockState newState = currentState;
        if (currentState.getValue(SimpleStorageBox.STORAGE_USED) != status) {
            newState = (BlockState)newState.setValue(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)status));
        }
        level.setBlock(this.worldPosition, newState, 3);
        level.sendBlockUpdated(this.worldPosition, currentState, newState, 3);
    }

    public void transferToStorage(Player pPlayer, Boolean transferAll) {
        ItemStack itemInHand = pPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemInHand.is(ModTags.Items.STORAGE_BOX_UPGRADE)) {
            if (itemInHand.is((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
                if (!this.hasVoidUpgrade()) {
                    this.itemHandler.setStackInSlot(1, itemInHand.copyWithCount(1));
                    if (!pPlayer.isCreative()) {
                        itemInHand.shrink(1);
                        pPlayer.getInventory().setChanged();
                    }
                } else {
                    ItemStack voidStack = this.itemHandler.getStackInSlot(1);
                    int slot = pPlayer.getInventory().getSlotWithRemainingSpace(voidStack);
                    if (slot > -1) {
                        pPlayer.getInventory().getItem(slot).grow(1);
                        pPlayer.getInventory().setChanged();
                    } else {
                        slot = pPlayer.getInventory().getFreeSlot();
                        if (slot > -1) {
                            pPlayer.getInventory().setItem(slot, voidStack);
                            pPlayer.getInventory().setChanged();
                        } else {
                            pPlayer.drop(voidStack, false);
                        }
                    }
                    this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
                }
            } else if (itemInHand.is((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
                boolean canAddUpgrade = false;
                for (int i = 2; i < 11; ++i) {
                    if (!this.itemHandler.getStackInSlot(i).isEmpty()) continue;
                    this.itemHandler.setStackInSlot(i, itemInHand.copyWithCount(1));
                    canAddUpgrade = true;
                    break;
                }
                if (!pPlayer.isCreative() && canAddUpgrade) {
                    itemInHand.shrink(1);
                    pPlayer.getInventory().setChanged();
                } else if (!canAddUpgrade) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"fxntstorage.storage_box_capacity_upgrade_max"), true);
                }
            }
        }
        if (transferAll.booleanValue()) {
            for (int i = 0; i < pPlayer.getInventory().getContainerSize(); ++i) {
                ItemStack playerStack = pPlayer.getInventory().getItem(i);
                if (playerStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)this.filterItem, (ItemStack)playerStack)) continue;
                ItemStack remainder = this.itemHandler.insertItem(0, playerStack, false);
                pPlayer.getInventory().setItem(i, remainder);
            }
        } else {
            if (itemInHand.isEmpty() || !this.filterTest(itemInHand)) {
                return;
            }
            int availableSpace = this.getMaxItemCapacity() - this.getStoredAmount();
            int srcAmount = itemInHand.getCount();
            if (availableSpace <= 0 && this.hasVoidUpgrade()) {
                itemInHand.shrink(srcAmount);
                return;
            }
            int moveAmount = Math.min(srcAmount, availableSpace);
            if (moveAmount > 0) {
                if (this.getFilterItem().isEmpty()) {
                    this.setFilter(itemInHand);
                }
                ItemStack remainder = this.itemHandler.insertItem(0, itemInHand, false);
                pPlayer.setItemInHand(InteractionHand.MAIN_HAND, remainder);
            }
        }
        this.setChanged();
    }

    public void transferFromStorage(Player pPlayer) {
        ItemStack slot0 = this.itemHandler.getStackInSlot(0);
        if (!slot0.isEmpty()) {
            int maxStack = Math.min(slot0.getMaxStackSize(), slot0.getCount());
            int amountToExtract = pPlayer.isShiftKeyDown() ? maxStack : 1;
            ItemStack extracted = this.itemHandler.extractItem(0, amountToExtract, false);
            if (!extracted.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)extracted);
            }
        }
    }

    public void removeFilter() {
        this.filterItem = ItemStack.EMPTY;
        this.storageSlotChanged = true;
    }

    public void setFilter(ItemStack itemStack) {
        this.filterItem = itemStack.copyWithCount(1);
    }

    public boolean filterTest(ItemStack stack) {
        if (stack.is(ModTags.Items.STORAGE_BOX_ITEM) || stack.is(ModTags.Items.STORAGE_BOX_UPGRADE)) {
            return false;
        }
        return this.filterItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.filterItem);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        if (player.isSpectator()) {
            return null;
        }
        return new SimpleStorageBoxMenu(containerId, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public int getMaxValue() {
        return this.maxItemCapacity;
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        return this.storedAmount;
    }

    public MutableComponent format(int i) {
        return CreateLang.translateDirect((String)"create.gui.threshold_switch.currently", (Object[])new Object[]{i});
    }

    public void applyInventoryToBlock(ItemStackHandler wrapped, ItemStack filterItem) {
        this.setFilter(filterItem);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, wrapped.getStackInSlot(i));
        }
    }
}

