/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.backpack.util.BackpackNetworkHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedMenu;
import net.fxnt.fxntstorage.container.util.StorageBoxNetworkHelper;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fxntstorage", value={Dist.CLIENT})
public class ClientEventHandler {
    private static double lastForwardImpulse = -99.0;
    private static double lastLeftImpulse = -99.0;

    @SubscribeEvent
    public static void onMovementInputUpdate(MovementInputUpdateEvent event) {
        Vec2 movement = event.getInput().getMoveVector();
        float forwardImpulse = movement.y;
        float leftImpulse = movement.x;
        Player player = event.getEntity();
        if ((double)forwardImpulse != lastForwardImpulse || (double)leftImpulse != lastLeftImpulse) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PlayerInputPacket(forwardImpulse, -leftImpulse), (CustomPacketPayload[])new CustomPacketPayload[0]);
            JetpackManager.getJetpackHandler(player).processPlayerInputPacket(forwardImpulse, -leftImpulse);
            lastForwardImpulse = forwardImpulse;
            lastLeftImpulse = leftImpulse;
        }
    }

    @SubscribeEvent
    public static void onMiddleClickBlock(InputEvent.MouseButton.Pre event) {
        if (event.getButton() != 2) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.isCreative() || player.isSpectator() || !player.level().isClientSide || !player.isAlive() || player.isSleeping() || player.isDeadOrDying() || event.getAction() != 1) {
            return;
        }
        if (mc.screen != null) {
            return;
        }
        if (!BackpackHelper.isWearingBackpack((Player)player)) {
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)hitResult).getBlockPos();
            BlockState state = player.level().getBlockState(blockPos);
            ItemStack stack = state.getCloneItemStack(hitResult, (LevelReader)player.level(), blockPos, (Player)player);
            if (!stack.isEmpty()) {
                BackpackNetworkHelper.doPickBlock(stack);
            } else {
                FXNTStorage.LOGGER.debug("No valid clone item for block: {}", (Object)state.getBlock());
            }
        }
    }

    @SubscribeEvent
    public static void onMiddleClickSort(InputEvent.MouseButton.Pre event) {
        block9: {
            AbstractContainerMenu menu;
            AbstractContainerScreen containerScreen;
            LocalPlayer player;
            block11: {
                block10: {
                    if (event.getButton() != 2) {
                        return;
                    }
                    Minecraft mc = Minecraft.getInstance();
                    player = mc.player;
                    if (player == null || player.isSpectator() || !player.level().isClientSide || !player.isAlive() || player.isSleeping() || player.isDeadOrDying()) {
                        return;
                    }
                    if (event.getAction() != 1 || !(player.containerMenu instanceof BackpackMenu) && !(player.containerMenu instanceof StorageBoxMenu) && !(player.containerMenu instanceof StorageBoxMountedMenu)) break block9;
                    event.setCanceled(true);
                    Screen screen = mc.screen;
                    if (!(screen instanceof AbstractContainerScreen)) break block10;
                    containerScreen = (AbstractContainerScreen)screen;
                    if (!(screen instanceof CreativeModeInventoryScreen)) break block11;
                }
                return;
            }
            Slot slot = containerScreen.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof BackpackMenu) {
                menu = (BackpackMenu)abstractContainerMenu;
                BackpackNetworkHelper.sortBackpack(slot.index, menu.getSortOrder());
            }
            if ((abstractContainerMenu = player.containerMenu) instanceof StorageBoxMenu) {
                menu = (StorageBoxMenu)abstractContainerMenu;
                StorageBoxNetworkHelper.sortStorageBox(slot.index, menu.getContainerSize(), menu.getSortOrder());
            }
            if ((abstractContainerMenu = player.containerMenu) instanceof StorageBoxMountedMenu) {
                menu = (StorageBoxMountedMenu)abstractContainerMenu;
                StorageBoxNetworkHelper.sortStorageBox(slot.index, menu.getContainerSize(), menu.getSortOrder());
            }
        }
    }

    @SubscribeEvent
    public static void onServerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            ConfigManager.ClientConfig.sendSettings((Player)player);
            JetpackManager.addPlayer((Player)player);
        }
    }

    @SubscribeEvent
    public static void onClientRespawn(ClientPlayerNetworkEvent.Clone event) {
        JetpackManager.addPlayer((Player)event.getNewPlayer());
    }
}

