/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import net.fxnt.fxntstorage.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;

public class RendererHelper {
    public static final int MAX_DISTANCE = 10;
    public static final int DEFAULT_LIGHT = 250;
    public static final float[] SIDE_ROT_Y = new float[]{0.0f, 0.0f, (float)Math.PI, 0.0f, 4.712389f, 1.5707964f};

    public static void renderLine(String text, float yOffset, PoseStack poseStack, MultiBufferSource buffer, int color) {
        Font font = Minecraft.getInstance().font;
        float zOffset = 15.05f;
        poseStack.pushPose();
        poseStack.translate(0.5f, yOffset / 16.0f, zOffset / 16.0f);
        poseStack.scale(0.015625f, -0.015625f, 1.0f);
        float x = (float)(-font.width(text)) / 2.0f;
        font.drawInBatch(text, x, 0.0f, color, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 250);
        poseStack.popPose();
    }

    public static void renderItem(ItemRenderer itemRenderer, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, boolean voidUpgrade) {
        ClientLevel level = Minecraft.getInstance().level;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.175f, 0.940625f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        BakedModel model = itemRenderer.getModel(stack, null, null, 0);
        boolean flatItem = !model.isGui3d();
        float scale = (flatItem ? 0.25f : 0.5f) + 0.01f;
        float zOffset = (flatItem ? -0.025f : 0.068f) + RendererHelper.customZOffset(stack.getItem());
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, 0.0f, zOffset);
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, 250, OverlayTexture.NO_OVERLAY, poseStack, buffer, (Level)level, 0);
        poseStack.popPose();
        if (voidUpgrade) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.940625f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.3f, -0.2f, 0.0f);
            scale = 0.265625f;
            poseStack.scale(scale, scale, scale);
            ItemStack icon = new ItemStack((ItemLike)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
            itemRenderer.renderStatic(icon, ItemDisplayContext.FIXED, 250, OverlayTexture.NO_OVERLAY, poseStack, buffer, (Level)level, 0);
            poseStack.popPose();
        }
    }

    public static int getColorForDistance(double distance) {
        int START = 255;
        int END = 50;
        double clamped = Math.min(distance, 10.0);
        double factor = clamped / 10.0;
        int val = (int)(255.0 + -205.0 * factor);
        return val << 16 | val << 8 | val;
    }

    private static float customZOffset(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSimpleShaftBlock || block instanceof FenceBlock || block.defaultBlockState().is(BlockTags.BUTTONS) || block == Blocks.END_ROD)) {
            return -0.1f;
        }
        return 0.0f;
    }
}

