/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.pearfection.common.features;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import net.digitalpear.pearfection.common.features.HugeLampearFeature;
import net.digitalpear.pearfection.common.features.HugeLampearFeatureConfig;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6019;

public class EnormousLampearFeature
extends class_3031<HugeLampearFeatureConfig> {
    public class_2350 branchDisallowedDirection = class_2350.field_11036;

    public EnormousLampearFeature(Codec<HugeLampearFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<HugeLampearFeatureConfig> context) {
        int i;
        class_2338 origin = context.method_33655().method_10084();
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        HugeLampearFeatureConfig config = (HugeLampearFeatureConfig)context.method_33656();
        int baseMaxY = config.height.method_35008(random);
        int maxY = origin.method_10264() < world.method_31600() - baseMaxY ? baseMaxY : world.method_31600() - origin.method_10264() - baseMaxY / 2;
        int height = random.method_39332(maxY / 2, maxY);
        int branchChance = 5;
        int foliageChance = 5;
        if (origin.method_10264() <= world.method_31607() + 4 && origin.method_10264() >= world.method_31600() - baseMaxY) {
            return false;
        }
        class_2338 currentPos = origin;
        class_2350 leanDirection = HugeLampearFeature.getRandomHorizontalDirection(random, class_2350.field_11036, class_2350.field_11033);
        HashMap placements = new HashMap();
        class_2338.method_10097((class_2338)origin, (class_2338)origin.method_10069(1, height / 2, 1)).forEach(pos -> {
            if (HugeLampearFeature.isReplaceable(Float.valueOf(config.maxGrowThroughHardness.method_33920(random)), world.method_8320(pos))) {
                placements.put(pos, config.trunkProviders.method_23455(random, pos));
            }
        });
        for (i = 0; i < height / 2; ++i) {
            this.placeTrunkLayer(class_2350.field_11043, class_2350.class_2351.field_11052, currentPos, context, branchChance, height);
            if (currentPos.method_10264() > origin.method_10264() + height / 4 && random.method_43048(100) < foliageChance) {
                currentPos = currentPos.method_10093(leanDirection);
                if (!random.method_43056()) continue;
                this.placeFoliage(world, currentPos.method_10084(), config, 1, 1);
                continue;
            }
            currentPos = currentPos.method_10084();
        }
        this.placeFoliage(world, currentPos.method_10084(), config, 2, 3);
        for (i = 0; i < height / 2; ++i) {
            this.placeTrunkLayer(class_2350.field_11036, leanDirection.method_10166(), currentPos, context, branchChance, height);
            if (random.method_43048(100) < 15) {
                currentPos = currentPos.method_10084();
                if (!random.method_43056()) continue;
                this.placeFoliage(world, currentPos.method_10084(), config, 1, 1);
                continue;
            }
            currentPos = currentPos.method_10093(leanDirection);
        }
        currentPos = currentPos.method_10093(leanDirection);
        this.placeFoliage(world, currentPos, config, 1, 2);
        this.placeTrunkLayer(class_2350.field_11043, class_2350.class_2351.field_11052, currentPos, context, branchChance, height);
        this.placeFoliage(world, currentPos.method_10084(), config, 2, 3);
        for (class_2338 pos2 : class_2338.method_10097((class_2338)origin.method_10069(-2, -1, -2), (class_2338)origin.method_10069(2, -2, 2))) {
            this.placeBlock(config, world, pos2, config.baseBlockProviders.method_23455(random, pos2));
        }
        for (class_2338 pos2 : class_2338.method_10097((class_2338)origin.method_10069(-3, -3, -3), (class_2338)origin.method_10069(3, -7, 3))) {
            this.placeBlock(config, world, pos2, config.baseBlockProviders.method_23455(random, pos2));
        }
        return true;
    }

    public void placeTrunkLayer(class_2350 baseDirection, class_2350.class_2351 rotationAxis, class_2338 currentPos, class_5821<HugeLampearFeatureConfig> context, int branchChance, int height) {
        HugeLampearFeatureConfig config = (HugeLampearFeatureConfig)context.method_33656();
        class_2338 origin = context.method_33655();
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        List<class_2350> directions = List.of(baseDirection, baseDirection.method_35833(rotationAxis), baseDirection.method_35833(rotationAxis).method_35833(rotationAxis), baseDirection.method_35833(rotationAxis).method_35833(rotationAxis).method_35833(rotationAxis));
        class_2680 state = (class_2680)config.trunkProviders.method_23455(random, currentPos).method_47968((class_2769)class_2465.field_11459, (Comparable)rotationAxis);
        this.placeBlock(config, world, currentPos, state);
        for (class_2350 direction1 : directions) {
            class_2338 pos = currentPos.method_10093(direction1);
            this.placeBlock(config, world, pos, state);
            if (currentPos.method_10264() <= origin.method_10264() + height / 4 || random.method_43048(100) >= branchChance) continue;
            this.placeBranch(world, pos, config);
        }
    }

    public void placeBlock(HugeLampearFeatureConfig config, class_5281 world, class_2338 pos, class_2680 state) {
        if (HugeLampearFeature.isReplaceable(Float.valueOf(config.maxGrowThroughHardness.method_33920(world.method_8409())), world.method_8320(pos))) {
            world.method_8652(pos, state, 3);
        }
    }

    public void placeBranch(class_5281 world, class_2338 pos, HugeLampearFeatureConfig config) {
        class_5819 random = world.method_8409();
        class_2350 direction = HugeLampearFeature.getRandomHorizontalDirection(random, class_2350.field_11036, class_2350.field_11033, this.branchDisallowedDirection);
        class_2338 currentPos = pos;
        class_6019 branchLength = class_6019.method_35017((int)3, (int)6);
        for (int i = 0; i < branchLength.method_35008(random); ++i) {
            this.placeBlock(config, world, currentPos, (class_2680)config.trunkProviders.method_23455(random, currentPos).method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()));
            if ((double)random.method_43057() < 0.3) {
                currentPos = currentPos.method_10084();
                this.placeBlock(config, world, currentPos, (class_2680)config.trunkProviders.method_23455(random, currentPos).method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()));
            }
            currentPos = currentPos.method_10093(direction);
        }
        this.placeBigPear(world, currentPos.method_10074(), config);
    }

    public void placeBigPear(class_5281 world, class_2338 pos, HugeLampearFeatureConfig config) {
        class_5819 random = world.method_8409();
        this.placeBlock(config, world, pos, config.trunkProviders.method_23455(random, pos.method_10074()));
        this.placeFoliage(world, pos, config, 1, 1);
        this.placeBlock(config, world, pos.method_10074(), config.baseBlockProviders.method_23455(random, pos.method_10074()));
        for (class_2338 pos1 : class_2338.method_10097((class_2338)pos.method_10087(1).method_10069(-1, 0, -1), (class_2338)pos.method_10087(2).method_10069(1, 0, 1))) {
            this.placeBlock(config, world, pos1, config.baseBlockProviders.method_23455(random, pos1));
        }
    }

    public void placeLeaf(class_5281 world, class_2338 pos, HugeLampearFeatureConfig config) {
        this.placeBlock(config, world, pos, config.foliageProviders.method_23455(world.method_8409(), pos));
    }

    public void placeFoliage(class_5281 world, class_2338 blockPos, HugeLampearFeatureConfig config, int min, int max) {
        class_5819 random = world.method_8409();
        int width = random.method_39332(min, max);
        int y = 1;
        float radius = (float)(width + y + width) * 0.333f + 0.5f;
        for (class_2338 currentBlockPos : class_2338.method_10097((class_2338)blockPos.method_10069(-width, -y, -width), (class_2338)blockPos.method_10069(width, y, width))) {
            if (!(currentBlockPos.method_10262((class_2382)blockPos) <= (double)(radius * radius)) || !world.method_8320(currentBlockPos).method_26215()) continue;
            this.placeLeaf(world, currentBlockPos, config);
        }
        for (class_2338 currentBlockPos : class_2338.method_10097((class_2338)blockPos.method_10069(-width, -y, -width).method_10074(), (class_2338)blockPos.method_10069(width, y, width).method_10074())) {
            if (!world.method_8320(currentBlockPos).method_26215() || !(random.method_43057() < 0.6f)) continue;
            this.placeLeaf(world, currentBlockPos, config);
            if ((double)random.method_43057() < 0.4) {
                for (int i = 0; i < random.method_43048(3); ++i) {
                    if (!world.method_8320(currentBlockPos.method_10087(i)).method_26215()) continue;
                    currentBlockPos = currentBlockPos.method_10087(i);
                    this.placeLeaf(world, currentBlockPos, config);
                }
            }
            if (!(random.method_43057() < config.fruitSpawnChance.method_33920(random))) continue;
            this.placeLeaf(world, currentBlockPos.method_10074(), config);
        }
    }
}

