/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.pearfection.init.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.digitalpear.pearfection.common.blocks.CalleryLeavesBlock;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_11586;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1690;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1822;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2440;
import net.minecraft.class_2446;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4910;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5794;
import net.minecraft.class_6862;
import net.minecraft.class_7264;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import net.minecraft.class_8790;

public class Woodset {
    public static final List<Woodset> WOODSETS = new ArrayList<Woodset>();
    private final List<class_2248> registeredBlocksList = new ArrayList<class_2248>();
    private final List<class_1792> registeredItemsList = new ArrayList<class_1792>();
    private static final List<class_2248> signBlocks = new ArrayList<class_2248>();
    private static final List<class_2248> hangingSignBlocks = new ArrayList<class_2248>();
    private final class_2960 name;
    private final class_3620 sideColor;
    private final class_3620 topColor;
    private class_8177 blockSetType;
    private class_4719 woodType;
    private class_2498 leaveSounds;
    private class_2248 log;
    private class_2248 strippedLog;
    private class_2248 wood;
    private class_2248 strippedWood;
    private class_2248 leaves;
    private class_2248 planks;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 mosaic;
    private class_2248 mosaicStairs;
    private class_2248 mosaicSlab;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 pressurePlate;
    private class_2248 button;
    private class_2248 door;
    private class_2248 trapDoor;
    private class_2248 sign;
    private class_2248 wallSign;
    private class_2248 hangingSign;
    private class_2248 wallHangingSign;
    private class_2248 shelf;
    private class_1792 signItem;
    private class_1792 hangingSignItem;
    private class_1792 boatItem;
    private class_1792 chestBoatItem;
    private class_1299<class_1690> boat;
    private class_1299<class_7264> chestBoat;
    private class_5794.class_5795 blockFamily;
    private final Settings woodsetSettings;

    private void registerWood() {
        this.blockSetType = this.createBlockSetType();
        this.woodType = WoodTypeBuilder.copyOf((class_4719)this.woodsetSettings.woodPreset.woodType).register(this.getNameID(), this.getBlockSetType());
        this.planks = this.createPlanks();
        this.log = this.createLog();
        this.strippedLog = this.createStrippedLog();
        StrippableBlockRegistry.register((class_2248)this.log, (class_2248)this.strippedLog);
        if (this.getWoodPreset() != WoodPreset.BAMBOO) {
            this.wood = this.createWood();
            this.strippedWood = this.createStrippedWood();
            StrippableBlockRegistry.register((class_2248)this.wood, (class_2248)this.strippedWood);
        }
        if (this.woodsetSettings.hasMosaic()) {
            this.mosaic = this.createMosaic();
            this.mosaicStairs = this.createMosaicStairs();
            this.mosaicSlab = this.createMosaicSlab();
        }
        if (this.isOverworldTreeWood()) {
            this.leaves = this.createLeaves();
        }
        this.stairs = this.createStairs();
        this.slab = this.createSlab();
        this.fence = this.createFence();
        this.fenceGate = this.createFenceGate();
        this.pressurePlate = this.createPressurePlate();
        this.button = this.createButton();
        this.door = this.createDoor();
        this.trapDoor = this.createTrapDoor();
        this.sign = this.createSign();
        this.wallSign = this.createWallSign();
        this.hangingSign = this.createHangingSign();
        this.wallHangingSign = this.createWallHangingSign();
        this.shelf = this.createShelf();
        this.signItem = this.createSignItem();
        this.hangingSignItem = this.createHangingSignItem();
        if (this.woodsetSettings.hasBoats) {
            this.boat = this.createBoatEntity();
            this.chestBoat = this.createChestBoatEntity();
            this.boatItem = this.createBoatItem();
            this.chestBoatItem = this.createChestBoatItem();
        }
        this.blockFamily = new class_5794.class_5795(this.planks).method_33484("wooden").method_33487(this.hasPlanks());
        this.blockFamily.method_33493(this.stairs);
        this.blockFamily.method_33492(this.slab);
        if (this.woodsetSettings.hasMosaic()) {
            this.blockFamily.method_45966(this.fence);
            this.blockFamily.method_45967(this.fenceGate);
        } else {
            this.blockFamily.method_33490(this.fence);
            this.blockFamily.method_33491(this.fenceGate);
        }
        this.blockFamily.method_33489(this.door);
        this.blockFamily.method_33496(this.trapDoor);
        this.blockFamily.method_33483(this.sign, this.wallSign);
        this.blockFamily.method_33482(this.button);
        this.blockFamily.method_33494(this.pressurePlate);
        signBlocks.add(this.sign);
        signBlocks.add(this.wallSign);
        hangingSignBlocks.add(this.hangingSign);
        hangingSignBlocks.add(this.wallHangingSign);
        class_2591 signs = class_2591.field_11911;
        signs.addSupportedBlock(this.sign);
        signs.addSupportedBlock(this.wallSign);
        class_2591 hangingSigns = class_2591.field_40330;
        hangingSigns.addSupportedBlock(this.hangingSign);
        hangingSigns.addSupportedBlock(this.wallHangingSign);
        class_2591 shelves = class_2591.field_61437;
        shelves.addSupportedBlock(this.shelf);
        if (this.woodsetSettings.woodPreset != WoodPreset.NETHER) {
            this.registerWoodsetFlammables();
        }
        this.registerFuels();
    }

    public Woodset(class_2960 name, class_3620 sideColor, class_3620 topColor, Settings.Builder settings) {
        this.woodsetSettings = settings.build();
        this.name = name;
        this.sideColor = sideColor;
        this.topColor = topColor;
        this.registerWood();
        WOODSETS.add(this);
    }

    public Woodset(class_2960 name, class_3620 sideColor, class_3620 topColor) {
        this(name, sideColor, topColor, new Settings.Builder());
    }

    private class_5321<class_1792> itemKey(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)this.getNamespace(), (String)id));
    }

    private class_5321<class_2248> blockKey(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)this.getNamespace(), (String)id));
    }

    private class_2248 createBlockWithItem(String blockID, class_4970.class_2251 settings) {
        return this.createBlockWithItem(blockID, class_2248::new, settings);
    }

    private class_2248 createBlockWithItem(String blockID, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = class_2246.method_63053(this.blockKey(blockID), factory, (class_4970.class_2251)settings);
        this.registeredBlocksList.add(block);
        class_1802.method_7989((class_2248)block);
        return block;
    }

    private class_2248 createBlockWithoutItem(String blockID, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = class_2246.method_63053(this.blockKey(blockID), factory, (class_4970.class_2251)settings);
        this.registeredBlocksList.add(block);
        return block;
    }

    public class_1792 createItem(String blockID, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        class_1792 item = class_1802.method_51348(this.itemKey(blockID), factory, (class_1792.class_1793)settings);
        this.registeredItemsList.add(item);
        return item;
    }

    private class_5321<class_1299<?>> entityKey(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)this.getNamespace(), (String)id));
    }

    public <T extends class_1297> class_1299<T> register(String name, class_1299.class_1300<T> type) {
        return this.register(this.entityKey(name), type);
    }

    public <T extends class_1297> class_1299<T> register(class_5321<class_1299<?>> name, class_1299.class_1300<T> type) {
        return (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, name, (Object)type.method_5905(name));
    }

    private static class_1299.class_4049<class_1690> boatFactory(class_1792 item) {
        return (entityType, world) -> new class_1690(entityType, world, () -> item);
    }

    private static class_1299.class_4049<class_7264> chestBoatFactory(class_1792 item) {
        return (entityType, world) -> new class_7264(entityType, world, () -> item);
    }

    private class_4970.class_2251 createLogBlock(class_3620 topMapColor, class_3620 sideMapColor) {
        return class_4970.class_2251.method_9637().method_51520(state -> state.method_11654((class_2769)class_2465.field_11459) == class_2350.class_2351.field_11052 ? topMapColor : sideMapColor).method_9632(2.0f).method_9626(this.getWoodType().comp_1301());
    }

    public Settings getWoodsetSettings() {
        return this.woodsetSettings;
    }

    public static List<class_4719> getAllWoodTypes() {
        if (WOODSETS.isEmpty()) {
            return null;
        }
        ArrayList<class_4719> types = new ArrayList<class_4719>();
        for (Woodset set : WOODSETS) {
            types.add(set.getWoodType());
        }
        return types;
    }

    public class_2960 getNameID() {
        return this.name;
    }

    public String getName() {
        return this.name.method_12832();
    }

    public String getNamespace() {
        return this.name.method_12836();
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    public WoodPreset getWoodPreset() {
        return this.woodsetSettings.woodPreset;
    }

    public class_3620 getSideColor() {
        return this.sideColor;
    }

    public class_3620 getTopColor() {
        return this.topColor;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    public class_2248 getButton() {
        return this.button;
    }

    public class_2248 getFence() {
        return this.fence;
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public class_2248 getSlab() {
        return this.slab;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate;
    }

    public class_2248 getStairs() {
        return this.stairs;
    }

    public class_2248 getDoor() {
        return this.door;
    }

    public class_2248 getHangingSign() {
        return this.hangingSign;
    }

    public class_2248 getWallHangingSign() {
        return this.wallHangingSign;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate;
    }

    public class_2248 getSign() {
        return this.sign;
    }

    public class_2248 getTrapDoor() {
        return this.trapDoor;
    }

    public class_2248 getWallSign() {
        return this.wallSign;
    }

    public class_1792 getHangingSignItem() {
        return this.hangingSignItem;
    }

    public class_1792 getSignItem() {
        return this.signItem;
    }

    public class_2248 getLog() {
        return this.log;
    }

    public class_2248 getStrippedLog() {
        return this.strippedLog;
    }

    public class_2248 getWood() {
        return this.wood;
    }

    public class_2248 getStrippedWood() {
        return this.strippedWood;
    }

    public class_2248 getMosaic() {
        return this.mosaic;
    }

    public class_2248 getMosaicStairs() {
        return this.mosaicStairs;
    }

    public class_2248 getMosaicSlab() {
        return this.mosaicSlab;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public class_1299<class_1690> getBoat() {
        return this.boat;
    }

    public class_1299<class_7264> getChestBoat() {
        return this.chestBoat;
    }

    public class_1792 getBoatItem() {
        return this.boatItem;
    }

    public class_1792 getChestBoatItem() {
        return this.chestBoatItem;
    }

    public List<class_2248> getRegisteredBlocksList() {
        return this.registeredBlocksList;
    }

    public List<class_1792> getRegisteredItemsList() {
        return this.registeredItemsList;
    }

    public static List<class_2248> getAllSigns() {
        return signBlocks;
    }

    public static List<class_2248> getAllHangingSigns() {
        return hangingSignBlocks;
    }

    public class_2248 getShelf() {
        return this.shelf;
    }

    public class_5794 getBlockFamily() {
        return this.blockFamily.method_33481();
    }

    private class_2248 createLog() {
        return this.createBlockWithItem(this.getName() + "_" + this.woodsetSettings.getLogName(), class_2465::new, this.createLogBlock(this.getSideColor(), this.getTopColor()));
    }

    private class_2248 createStrippedLog() {
        return this.createBlockWithItem("stripped_" + this.getName() + "_" + this.woodsetSettings.getLogName(), class_2465::new, this.createLogBlock(this.getSideColor(), this.getTopColor()));
    }

    private class_2248 createWood() {
        return this.createBlockWithItem(this.getName() + "_" + this.woodsetSettings.getWoodName(), class_2465::new, this.createLogBlock(this.getSideColor(), this.getSideColor()));
    }

    private class_2248 createStrippedWood() {
        return this.createBlockWithItem("stripped_" + this.getName() + "_" + this.woodsetSettings.getWoodName(), class_2465::new, this.createLogBlock(this.getTopColor(), this.getTopColor()));
    }

    private class_2248 createLeaves() {
        return this.createBlockWithItem(this.getName() + "_leaves", settings -> new CalleryLeavesBlock(0.01f, (class_4970.class_2251)settings, false), this.createLeavesBlock());
    }

    private class_2248 createPlanks() {
        return this.createBlockWithItem(this.getName() + "_planks", class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createStairs() {
        return this.createBlockWithItem(this.getName() + "_stairs", settings -> new class_2510(this.getBase().method_9564(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createSlab() {
        return this.createBlockWithItem(this.getName() + "_slab", class_2482::new, class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createMosaic() {
        return this.createBlockWithItem(this.getName() + "_mosaic", class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createMosaicStairs() {
        return this.createBlockWithItem(this.getName() + "_mosaic_stairs", settings -> new class_2510(this.getBase().method_9564(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createMosaicSlab() {
        return this.createBlockWithItem(this.getName() + "_mosaic_slab", class_2482::new, class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createFence() {
        return this.createBlockWithItem(this.getName() + "_fence", class_2354::new, class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createFenceGate() {
        return this.createBlockWithItem(this.getName() + "_fence_gate", settings -> new class_2349(this.getWoodType(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createPressurePlate() {
        return this.createBlockWithItem(this.getName() + "_pressure_plate", settings -> new class_2440(this.getBlockSetType(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createButton() {
        return this.createBlockWithItem(this.getName() + "_button", settings -> new class_2269(this.getBlockSetType(), 30, settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createDoor() {
        return this.createBlockWithItem(this.getName() + "_door", settings -> new class_2323(this.getBlockSetType(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createTrapDoor() {
        return this.createBlockWithItem(this.getName() + "_trapdoor", settings -> new class_2533(this.getBlockSetType(), settings), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()));
    }

    private class_2248 createSign() {
        return this.createBlockWithoutItem(this.getName() + "_sign", settings -> new class_2508(this.woodType, settings), class_4970.class_2251.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()));
    }

    private class_2248 createWallSign() {
        return this.createBlockWithoutItem(this.getName() + "_wall_sign", settings -> new class_2551(this.woodType, settings), class_4970.class_2251.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()).method_63502(this.sign.method_26162()));
    }

    private class_2248 createHangingSign() {
        return this.createBlockWithoutItem(this.getName() + "_hanging_sign", settings -> new class_7713(this.woodType, settings), class_4970.class_2251.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()));
    }

    private class_2248 createWallHangingSign() {
        return this.createBlockWithoutItem(this.getName() + "_wall_hanging_sign", settings -> new class_7715(this.woodType, settings), class_4970.class_2251.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()).method_63502(this.hangingSign.method_26162()));
    }

    private class_2248 createShelf() {
        return this.createBlockWithItem(this.getName() + "_shelf", class_11586::new, class_4970.class_2251.method_9630((class_4970)class_2246.field_61366).method_31710(this.topColor));
    }

    private class_1792 createSignItem() {
        return this.createItem(this.getName() + "_sign", settings -> new class_1822(this.getSign(), this.getWallSign(), settings), new class_1792.class_1793().method_7889(16));
    }

    private class_1792 createHangingSignItem() {
        return this.createItem(this.getName() + "_hanging_sign", settings -> new class_7707(this.getHangingSign(), this.getWallHangingSign(), settings), new class_1792.class_1793().method_7889(16));
    }

    private class_1299<class_1690> createBoatEntity() {
        return this.register(this.getName() + "_" + this.woodsetSettings.getBoatName(), class_1299.class_1300.method_5903(Woodset.boatFactory(this.boatItem), (class_1311)class_1311.field_17715).method_63006().method_17687(1.375f, 0.5625f).method_55687(0.5625f).method_27299(10));
    }

    private class_1299<class_7264> createChestBoatEntity() {
        return this.register(this.getName() + "_chest_" + this.woodsetSettings.getBoatName(), class_1299.class_1300.method_5903(Woodset.chestBoatFactory(this.chestBoatItem), (class_1311)class_1311.field_17715).method_63006().method_17687(1.375f, 0.5625f).method_55687(0.5625f).method_27299(10));
    }

    private class_1792 createBoatItem() {
        return this.createItem(this.getName() + "_" + this.woodsetSettings.getBoatName(), settings -> new class_1749(this.boat, settings), new class_1792.class_1793().method_7889(1));
    }

    private class_1792 createChestBoatItem() {
        return this.createItem(this.getName() + "_chest_" + this.woodsetSettings.getBoatName(), settings -> new class_1749(this.chestBoat, settings), new class_1792.class_1793().method_7889(1));
    }

    public void registerFuels() {
        FuelRegistryEvents.BUILD.register((builder, context) -> {
            builder.method_61762((class_1935)this.log, 300);
            builder.method_61762((class_1935)this.strippedLog, 300);
            if (this.woodsetSettings.woodPreset == WoodPreset.BAMBOO) {
                builder.method_61762((class_1935)this.mosaic, 300);
                builder.method_61762((class_1935)this.mosaicSlab, 150);
                builder.method_61762((class_1935)this.mosaicStairs, 300);
            } else {
                builder.method_61762((class_1935)this.wood, 300);
                builder.method_61762((class_1935)this.strippedWood, 300);
            }
            builder.method_61762((class_1935)this.pressurePlate, 300);
            builder.method_61762((class_1935)this.button, 100);
            builder.method_61762((class_1935)this.trapDoor, 300);
            builder.method_61762((class_1935)this.door, 300);
            builder.method_61762((class_1935)this.fence, 300);
            builder.method_61762((class_1935)this.fenceGate, 300);
            builder.method_61762((class_1935)this.signItem, 300);
            builder.method_61762((class_1935)this.hangingSignItem, 800);
            if (this.woodsetSettings.hasBoats()) {
                builder.method_61762((class_1935)this.boatItem, 1200);
                builder.method_61762((class_1935)this.chestBoatItem, 1200);
            }
        });
    }

    public void registerWoodsetFlammables() {
        Woodset.addFlammable(this.getLog(), 5, 5);
        Woodset.addFlammable(this.getStrippedLog(), 5, 5);
        if (this.getWoodPreset() != WoodPreset.BAMBOO) {
            Woodset.addFlammable(this.getWood(), 5, 5);
            Woodset.addFlammable(this.getStrippedWood(), 5, 5);
        }
        if (this.woodsetSettings.hasMosaic()) {
            Woodset.addFlammable(this.getMosaic(), 5, 20);
            Woodset.addFlammable(this.getMosaicStairs(), 5, 20);
            Woodset.addFlammable(this.getMosaicSlab(), 5, 20);
        }
        if (this.isOverworldTreeWood()) {
            Woodset.addFlammable(this.getLeaves(), 30, 60);
        }
        Woodset.addFlammable(this.getPlanks(), 5, 20);
        Woodset.addFlammable(this.getSlab(), 5, 20);
        Woodset.addFlammable(this.getStairs(), 5, 20);
        Woodset.addFlammable(this.getFence(), 5, 20);
        Woodset.addFlammable(this.getFenceGate(), 5, 20);
        Woodset.addFlammable(this.getSign(), 5, 20);
        Woodset.addFlammable(this.getWallSign(), 5, 20);
        Woodset.addFlammable(this.getHangingSign(), 5, 20);
        Woodset.addFlammable(this.getWallHangingSign(), 5, 20);
    }

    public static void addFlammable(class_2248 block, int burn, int spread) {
        FlammableBlockRegistry.getDefaultInstance().add(block, burn, spread);
    }

    public void fullWoodset(class_4910 blockStateModelGenerator) {
        class_4910.class_4912 pool = blockStateModelGenerator.method_25650(this.getPlanks());
        pool.method_33522(this.getBlockFamily());
        if (this.isOverworldTreeWood()) {
            blockStateModelGenerator.method_25641(this.getLeaves());
        }
        if (this.notBambooVariant()) {
            blockStateModelGenerator.method_25676(this.getLog()).method_25730(this.getLog()).method_25728(this.getWood());
            blockStateModelGenerator.method_25676(this.getStrippedLog()).method_25730(this.getStrippedLog()).method_25728(this.getStrippedWood());
        }
        if (this.woodsetSettings.hasMosaic()) {
            blockStateModelGenerator.method_25676(this.getLog()).method_47520(this.getLog());
            blockStateModelGenerator.method_25676(this.getStrippedLog()).method_47520(this.getStrippedLog());
        }
        blockStateModelGenerator.method_46190(this.strippedLog, this.hangingSign, this.wallHangingSign);
        blockStateModelGenerator.method_25537(this.getBoatItem());
        blockStateModelGenerator.method_25537(this.getChestBoatItem());
        blockStateModelGenerator.method_72719(this.getShelf(), this.getStrippedLog());
    }

    private class_2248 getBase() {
        switch (this.getWoodPreset().ordinal()) {
            case 2: {
                return class_2246.field_22126;
            }
            case 3: {
                return class_2246.field_40294;
            }
            case 1: {
                return class_2246.field_42751;
            }
        }
        return class_2246.field_10161;
    }

    private class_2248 getSignBase() {
        switch (this.getWoodPreset().ordinal()) {
            case 2: {
                return class_2246.field_22104;
            }
            case 3: {
                return class_2246.field_40277;
            }
            case 1: {
                return class_2246.field_42735;
            }
        }
        return class_2246.field_10121;
    }

    private class_2248 getHangingSignBase() {
        switch (this.getWoodPreset().ordinal()) {
            case 2: {
                return class_2246.field_40268;
            }
            case 3: {
                return class_2246.field_40271;
            }
            case 1: {
                return class_2246.field_42738;
            }
        }
        return class_2246.field_40262;
    }

    private class_8177 createBlockSetType() {
        return this.getWoodPreset().blockSetType();
    }

    public boolean isOverworldTreeWood() {
        return this.getWoodPreset().isOverworldTree();
    }

    public boolean notBambooVariant() {
        return this.getWoodPreset() != WoodPreset.BAMBOO;
    }

    public class_4970.class_2251 createLeavesBlock() {
        return this.createLeavesBlock(class_3620.field_16004);
    }

    public class_4970.class_2251 createLeavesBlock(class_3620 color) {
        return class_4970.class_2251.method_9637().method_31710(color).method_9632(0.2f).method_9640().method_9626(this.woodsetSettings.leaveSoundGroup).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122);
    }

    public static void addToBuildingTab(class_1792 preceedingItem, Woodset woodset) {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40195).register(entries -> {
            entries.addAfter((class_1935)preceedingItem, new class_1935[]{woodset.getPlanks(), woodset.getStairs(), woodset.getSlab(), woodset.getFence(), woodset.getFenceGate(), woodset.getDoor(), woodset.getTrapDoor(), woodset.getPressurePlate(), woodset.getButton()});
            if (woodset.notBambooVariant()) {
                entries.addAfter((class_1935)preceedingItem, new class_1935[]{woodset.getWood(), woodset.getStrippedWood()});
            }
            if (woodset.getWoodsetSettings().hasMosaic()) {
                entries.addAfter((class_1935)preceedingItem, new class_1935[]{woodset.getMosaic(), woodset.getMosaicStairs(), woodset.getMosaicSlab()});
            }
            entries.addAfter((class_1935)preceedingItem, new class_1935[]{woodset.getLog(), woodset.getStrippedLog()});
        });
    }

    private String hasPlanks() {
        return class_2446.method_32807((class_1935)this.getPlanks());
    }

    public void generateRecipes(class_2446 recipeGenerator, class_7871<class_1792> lookup, class_8790 exporter, class_6862<class_1792> logs) {
        recipeGenerator.method_24477((class_1935)this.getPlanks(), logs, 4);
        recipeGenerator.method_32808((class_1935)this.getStairs(), class_1856.method_8091((class_1935[])new class_1935[]{this.getPlanks()})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.getPlanks())).method_10431(exporter);
        recipeGenerator.method_32814(class_7800.field_40634, (class_1935)this.getSlab(), (class_1935)this.getPlanks());
        recipeGenerator.method_33535(this.getBlockFamily(), class_7699.method_45397());
        if (this.notBambooVariant()) {
            recipeGenerator.method_24476((class_1935)this.getWood(), (class_1935)this.getLog());
            recipeGenerator.method_24476((class_1935)this.getStrippedWood(), (class_1935)this.getStrippedLog());
        }
        if (this.getWoodsetSettings().hasMosaic()) {
            recipeGenerator.method_46212(class_7800.field_40634, (class_1935)this.getMosaic(), (class_1935)this.getSlab());
            recipeGenerator.method_32808((class_1935)this.getMosaicStairs(), class_1856.method_8091((class_1935[])new class_1935[]{this.getPlanks()})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.getMosaic())).method_10431(exporter);
            recipeGenerator.method_32814(class_7800.field_40634, (class_1935)this.getMosaicStairs(), (class_1935)this.getPlanks());
        }
        recipeGenerator.method_33546((class_1935)this.fence, class_1856.method_8091((class_1935[])new class_1935[]{this.planks})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.planks)).method_10431(exporter);
        recipeGenerator.method_33548((class_1935)this.fenceGate, class_1856.method_8091((class_1935[])new class_1935[]{this.planks})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.planks)).method_10431(exporter);
        recipeGenerator.method_33544((class_1935)this.door, class_1856.method_8091((class_1935[])new class_1935[]{this.planks})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.planks)).method_10431(exporter);
        recipeGenerator.method_33553((class_1935)this.trapDoor, class_1856.method_8091((class_1935[])new class_1935[]{this.planks})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.planks)).method_10431(exporter);
        recipeGenerator.method_33555((class_1935)this.signItem, class_1856.method_8091((class_1935[])new class_1935[]{this.planks})).method_33530(this.hasPlanks(), recipeGenerator.method_10426((class_1935)this.planks)).method_10431(exporter);
        recipeGenerator.method_46208((class_1935)this.getHangingSignItem(), (class_1935)this.getStrippedLog());
        recipeGenerator.method_24478((class_1935)this.getBoatItem(), (class_1935)this.getPlanks());
        recipeGenerator.method_42754((class_1935)this.getChestBoatItem(), (class_1935)this.getBoatItem());
        recipeGenerator.method_73067((class_1935)this.getShelf(), (class_1935)this.getStrippedLog());
    }

    public static class Settings {
        private String logName = null;
        private String woodName = null;
        private BoatType boatType = null;
        private boolean hasBoats = true;
        private boolean hasMosaic = false;
        private class_2498 leaveSoundGroup = class_2498.field_11535;
        private WoodPreset woodPreset = WoodPreset.DEFAULT;

        private Settings() {
        }

        public BoatType getBoatType() {
            return this.boatType;
        }

        public class_2498 getLeaveSoundGroup() {
            return this.leaveSoundGroup;
        }

        public String getLogName() {
            return this.logName;
        }

        public String getWoodName() {
            return this.woodName;
        }

        public boolean hasMosaic() {
            return this.hasMosaic;
        }

        public boolean hasBoats() {
            return this.hasBoats;
        }

        public WoodPreset getWoodPreset() {
            return this.woodPreset;
        }

        private String getBoatName() {
            return this.getBoatType() == BoatType.RAFT ? "raft" : "boat";
        }

        public static enum BoatType {
            BOAT,
            RAFT;

        }

        public static class Builder {
            private final Settings settings = new Settings();

            public Settings build() {
                this.settings.boatType = this.getBoatType();
                this.settings.woodName = this.getWoodName();
                this.settings.logName = this.getLogName();
                return this.settings;
            }

            public Builder woodName(String woodName) {
                this.settings.woodName = woodName;
                return this;
            }

            public Builder woodName(boolean hasBoats) {
                this.settings.hasBoats = hasBoats;
                return this;
            }

            public Builder logName(String logName) {
                this.settings.logName = logName;
                return this;
            }

            public Builder setBoatType(BoatType type) {
                this.settings.boatType = type;
                return this;
            }

            public Builder woodPreset(WoodPreset woodPreset) {
                this.settings.woodPreset = woodPreset;
                return this;
            }

            public Builder leaveSoundGroup(class_2498 soundGroup) {
                this.settings.leaveSoundGroup = soundGroup;
                return this;
            }

            public Builder hasMosaic() {
                this.settings.hasMosaic = true;
                return this;
            }

            private String getLogName() {
                if (this.settings.logName != null) {
                    return this.settings.logName;
                }
                switch (this.settings.woodPreset.ordinal()) {
                    case 2: {
                        return "stem";
                    }
                    case 3: {
                        return "block";
                    }
                }
                return "log";
            }

            public BoatType getBoatType() {
                return Objects.requireNonNullElseGet(this.settings.boatType, () -> this.settings.woodPreset == WoodPreset.BAMBOO ? BoatType.RAFT : BoatType.BOAT);
            }

            private String getWoodName() {
                return Objects.requireNonNullElseGet(this.settings.woodName, () -> this.settings.woodPreset == WoodPreset.NETHER ? "hyphae" : "wood");
            }
        }
    }

    public static enum WoodPreset {
        DEFAULT(class_4719.field_21676),
        FANCY(class_4719.field_42837),
        NETHER(class_4719.field_22183),
        BAMBOO(class_4719.field_40350);

        private final class_4719 woodType;

        private WoodPreset(class_4719 type) {
            this.woodType = type;
        }

        public class_4719 getWoodType() {
            return this.woodType;
        }

        boolean isOverworldTree() {
            return this == DEFAULT || this == FANCY;
        }

        public class_8177 blockSetType() {
            return this.woodType.comp_1300();
        }
    }
}

