/*
 * Decompiled with CFR 0.152.
 */
package cc.sirrus.create_train_control.mixin;

import cc.sirrus.create_train_control.Create_train_control;
import cc.sirrus.create_train_control.init.ModSoundEvents;
import cc.sirrus.create_train_control.mixin.LoopsoundInvoker;
import cc.sirrus.create_train_control.utility.CarriageSoundsReflector;
import cc.sirrus.create_train_control.utility.MovingState;
import cc.sirrus.create_train_control.utility.ReflectUtils;
import cc.sirrus.create_train_control.utility.SoundInvokerUtils;
import cc.sirrus.create_train_control.utility.Sounds;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageSounds;
import com.simibubi.create.content.trains.entity.Train;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CarriageSounds.class}, remap=false)
public class CarriageSoundsMixin {
    @Shadow(remap=false)
    LerpedFloat distanceFactor;
    @Shadow(remap=false)
    LerpedFloat speedFactor;
    @Shadow(remap=false)
    LerpedFloat approachFactor;
    @Shadow(remap=false)
    LerpedFloat seatCrossfade;
    @Shadow(remap=false)
    CarriageContraptionEntity entity;
    @Shadow(remap=false)
    int tick;
    @Shadow(remap=false)
    int prevSharedTick;
    @Unique
    private Sounds.LoopingSound vvvf1Sound;
    @Unique
    private Sounds.LoopingSound vvvf2Sound;
    @Unique
    private Sounds.LoopingSound vvvf3Sound;
    @Unique
    private Sounds.LoopingSound vvvf4Sound;
    @Unique
    private Sounds.LoopingSound vvvf5Sound;
    @Unique
    private Sounds.LoopingSound vvvf6Sound;
    @Unique
    private Sounds.LoopingSound vvvf7Sound;
    @Unique
    private Sounds.LoopingSound vvvf8Sound;
    @Unique
    private Sounds.LoopingSound motor1Sound;
    @Unique
    private Sounds.LoopingSound motor2Sound;
    @Unique
    private float[] vvvfVolumes;
    @Unique
    private float speed;
    @Unique
    private float speedLerped;
    @Unique
    private float speedLerpedLast;
    @Unique
    private float accelAvg;
    @Unique
    private MovingState state;
    @Unique
    private Object minecartEsqueSoundObject = null;
    @Unique
    private Object sharedWheelSoundSeatedObject = null;
    @Unique
    private Object sharedWheelSoundObject = null;
    @Unique
    private Object sharedHonkSoundObject = null;
    @Unique
    private Boolean getLoopingsoundsDone = false;

    private void updateLoopingsounds(Object self) throws IllegalAccessException {
        if (this.getLoopingsoundsDone.booleanValue()) {
            return;
        }
        if (this.minecartEsqueSoundObject == null) {
            this.minecartEsqueSoundObject = CarriageSoundsReflector.minecartField.get(self);
        }
        if (this.sharedWheelSoundObject == null) {
            this.sharedWheelSoundObject = CarriageSoundsReflector.sharedWheelField.get(self);
        }
        if (this.sharedWheelSoundSeatedObject == null) {
            this.sharedWheelSoundSeatedObject = CarriageSoundsReflector.sharedWheelSeatedField.get(self);
        }
        if (this.sharedHonkSoundObject == null) {
            this.sharedHonkSoundObject = CarriageSoundsReflector.sharedHonkField.get(self);
        }
        this.getLoopingsoundsDone = true;
    }

    public void finalizeSharedVolume(float volume) {
        float crossfade = this.seatCrossfade.getValue();
        CarriageSoundsMixin self = this;
        float baseVolume = volume;
        ReflectUtils.safeRun("finalizeSharedVolume", () -> {
            this.updateLoopingsounds(self);
            float vol = baseVolume;
            float v0 = (1.0f - crossfade * 0.65f) * vol / 2.0f;
            float v1 = Math.min(vol, Math.max((this.speedFactor.getValue() - 0.25f) / 4.0f + 0.01f, 0.0f));
            vol = Math.min(vol, Math.max((this.speedFactor.getValue() - 0.25f) / 4.0f + 0.01f, 0.0f));
            SoundInvokerUtils.safeInvokeSetVolume(this.minecartEsqueSoundObject, v0);
            SoundInvokerUtils.safeInvokeSetVolume(this.sharedWheelSoundSeatedObject, vol * crossfade);
            SoundInvokerUtils.safeInvokeSetVolume(this.sharedWheelSoundObject, vol * (1.0f - crossfade) * 1.5f);
        });
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void onCtor(CarriageContraptionEntity entity, CallbackInfo ci) {
        this.vvvfVolumes = new float[8];
        this.state = MovingState.Stopped;
        this.speedLerpedLast = 0.0f;
        this.accelAvg = 0.0f;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_ASSIGN", target="Lcom/simibubi/create/content/trains/entity/CarriageSounds;playIfMissing(Lnet/minecraft/client/Minecraft;Lcom/simibubi/create/content/trains/entity/CarriageSounds$LoopingSound;Lnet/minecraft/sounds/SoundEvent;)Lcom/simibubi/create/content/trains/entity/CarriageSounds$LoopingSound;", ordinal=2)}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    private void afterSharedWheelSoundSeated(Carriage.DimensionalCarriageEntity dce, CallbackInfo ci) {
        CarriageSoundsMixin self = this;
        ReflectUtils.safeRun("LoopingSound", () -> {
            AllSoundEvents.SoundEntry continuousSound;
            float sf;
            this.updateLoopingsounds(self);
            Minecraft mc = Minecraft.getInstance();
            this.motor1Sound = Sounds.playIfMissing(mc, this.motor1Sound, (SoundEvent)ModSoundEvents.MOTOR_1.get(), true);
            this.motor2Sound = Sounds.playIfMissing(mc, this.motor2Sound, (SoundEvent)ModSoundEvents.MOTOR_2.get(), true);
            this.vvvf1Sound = Sounds.playIfMissing(mc, this.vvvf1Sound, (SoundEvent)ModSoundEvents.VVVF_1.get(), true);
            this.vvvf2Sound = Sounds.playIfMissing(mc, this.vvvf2Sound, (SoundEvent)ModSoundEvents.VVVF_2.get(), true);
            this.vvvf3Sound = Sounds.playIfMissing(mc, this.vvvf3Sound, (SoundEvent)ModSoundEvents.VVVF_3.get(), true);
            this.vvvf4Sound = Sounds.playIfMissing(mc, this.vvvf4Sound, (SoundEvent)ModSoundEvents.VVVF_4.get(), true);
            this.vvvf5Sound = Sounds.playIfMissing(mc, this.vvvf5Sound, (SoundEvent)ModSoundEvents.VVVF_5.get(), true);
            this.vvvf6Sound = Sounds.playIfMissing(mc, this.vvvf6Sound, (SoundEvent)ModSoundEvents.VVVF_6.get(), true);
            this.vvvf7Sound = Sounds.playIfMissing(mc, this.vvvf7Sound, (SoundEvent)ModSoundEvents.VVVF_7.get(), true);
            this.vvvf8Sound = Sounds.playIfMissing(mc, this.vvvf8Sound, (SoundEvent)ModSoundEvents.VVVF_8.get(), true);
            Entity camEntity = mc.cameraEntity;
            Vec3 cam = camEntity.getEyePosition();
            Vec3 leadingAnchor = dce.leadingAnchor();
            Vec3 trailingAnchor = dce.trailingAnchor();
            Vec3 toBogey1 = leadingAnchor.subtract(cam);
            Vec3 toBogey2 = trailingAnchor.subtract(cam);
            double distance1 = toBogey1.length();
            double distance2 = toBogey2.length();
            Vec3 toCarriage = distance1 > distance2 ? toBogey2 : toBogey1;
            Vec3 soundLocation = cam.add(toCarriage);
            float volume = Math.min(this.distanceFactor.getValue() / 100.0f, this.approachFactor.getValue() / 300.0f + 0.0125f);
            float pitchModifier = (float)(this.entity.getId() * 10 % 13) / 36.0f;
            volume = Math.min(volume, this.distanceFactor.getValue() / 800.0f);
            float pitch = Mth.clamp((float)(this.speedFactor.getValue() * 2.0f + 0.25f), (float)0.75f, (float)1.95f) - pitchModifier;
            float pitch2 = Mth.clamp((float)(this.speedFactor.getValue() * 2.0f), (float)0.75f, (float)1.25f) - pitchModifier;
            Train train = this.entity.getCarriage().train;
            SoundInvokerUtils.safeInvokeSetPitch((LoopsoundInvoker)this.minecartEsqueSoundObject, pitch * 1.5f);
            this.speedLerped = this.speedFactor.getValue();
            float acc = this.speedLerped - this.speedLerpedLast;
            this.accelAvg = this.accelAvg * 0.5f + acc * 0.5f;
            this.speedLerpedLast = this.speedLerped;
            float tacc = train.acceleration();
            if (Math.abs(this.accelAvg) < tacc / 3.0f) {
                if ((double)this.speedLerped < 0.01 && this.state != MovingState.Stopped) {
                    this.speed = 0.0f;
                    this.state = MovingState.Stopped;
                } else if (this.state == MovingState.Accelerating) {
                    this.speed = this.speedLerped;
                    this.state = MovingState.Cruising;
                }
            } else if (this.state != MovingState.Accelerating) {
                this.speed = this.speedLerped;
                this.state = MovingState.Accelerating;
            } else {
                this.speed = this.accelAvg < 0.0f ? (this.speed -= tacc) : (this.speed += tacc);
                if (this.speed < 0.0f) {
                    this.speed = 0.0f;
                    this.state = MovingState.Stopped;
                }
            }
            if (this.tick % 32 == 0) {
                Create_train_control.LOGGER.info("[CARRIAGE] Current speed {}, accel avg {}, tacc {}, state {}", new Object[]{Float.valueOf(this.speed), Float.valueOf(this.accelAvg), Float.valueOf(tacc), this.state});
            }
            if ((sf = this.speed * 20.0f * 3.6f) > 0.1f) {
                float attenFactor = Math.min(1.0f, Math.max((sf *= 1.2f) / 50.0f * -1.0f + 1.8f, 0.1f));
                float motorVolume = volume * Math.min(1.0f, Math.max((sf - 8.0f) / 8.0f, 0.0f)) * attenFactor * 0.8f;
                if (sf < 32.0f) {
                    this.motor1Sound.setVolume(motorVolume);
                    this.motor2Sound.setVolume(0.0f);
                    this.motor1Sound.setPitch(sf / 16.0f);
                } else {
                    this.motor1Sound.setVolume(0.0f);
                    this.motor2Sound.setVolume(motorVolume);
                    this.motor2Sound.setPitch(sf / 64.0f);
                }
                float vvvfVolume = volume * Math.min(1.0f, sf / 6.0f) * attenFactor * 0.7f;
                for (int i = 0; i < this.vvvfVolumes.length; ++i) {
                    this.vvvfVolumes[i] = 0.0f;
                }
                if (sf < 11.0f) {
                    this.vvvfVolumes[0] = vvvfVolume;
                } else if (sf < 27.0f) {
                    this.vvvfVolumes[1] = vvvfVolume;
                    this.vvvf2Sound.setPitch(sf / 20.0f);
                } else if (sf < 36.0f) {
                    this.vvvfVolumes[2] = vvvfVolume;
                    this.vvvf3Sound.setPitch(sf / 30.0f);
                } else if (sf < 52.0f) {
                    this.vvvfVolumes[3] = vvvfVolume;
                    this.vvvf4Sound.setPitch(sf / 46.0f);
                } else if (sf < 57.0f) {
                    this.vvvfVolumes[4] = vvvfVolume;
                    this.vvvf5Sound.setPitch(sf / 54.0f);
                } else if (sf < 64.0f) {
                    this.vvvfVolumes[5] = vvvfVolume;
                    this.vvvf6Sound.setPitch(sf / 60.0f);
                } else if (sf < 70.0f) {
                    this.vvvfVolumes[6] = vvvfVolume;
                    this.vvvf7Sound.setPitch(sf / 67.0f);
                } else {
                    this.vvvfVolumes[7] = vvvfVolume;
                    this.vvvf8Sound.setPitch(sf / 80.0f);
                }
                this.vvvf1Sound.setVolume(this.vvvfVolumes[0]);
                this.vvvf2Sound.setVolume(this.vvvfVolumes[1]);
                this.vvvf3Sound.setVolume(this.vvvfVolumes[2]);
                this.vvvf4Sound.setVolume(this.vvvfVolumes[3]);
                this.vvvf5Sound.setVolume(this.vvvfVolumes[4]);
                this.vvvf6Sound.setVolume(this.vvvfVolumes[5]);
                this.vvvf7Sound.setVolume(this.vvvfVolumes[6]);
                this.vvvf8Sound.setVolume(this.vvvfVolumes[7]);
            } else {
                this.motor1Sound.setVolume(0.0f);
                this.motor2Sound.setVolume(0.0f);
                this.vvvf1Sound.setVolume(0.0f);
                this.vvvf2Sound.setVolume(0.0f);
                this.vvvf3Sound.setVolume(0.0f);
                this.vvvf4Sound.setVolume(0.0f);
                this.vvvf5Sound.setVolume(0.0f);
                this.vvvf6Sound.setVolume(0.0f);
                this.vvvf7Sound.setVolume(0.0f);
                this.vvvf8Sound.setVolume(0.0f);
            }
            volume = Math.min(volume, this.distanceFactor.getValue() / 1000.0f);
            for (Carriage carriage : train.carriages) {
                CarriageContraptionEntity mainEntity;
                Carriage.DimensionalCarriageEntity mainDCE = carriage.getDimensionalIfPresent(this.entity.level().dimension());
                if (mainDCE == null || (mainEntity = (CarriageContraptionEntity)mainDCE.entity.get()) == null) continue;
                if (mainEntity.sounds == null) {
                    mainEntity.sounds = new CarriageSounds(mainEntity);
                }
                mainEntity.sounds.submitSharedSoundVolume(soundLocation, volume);
                if (carriage == this.entity.getCarriage()) break;
                this.finalizeSharedVolume(0.0f);
                return;
            }
            SoundInvokerUtils.safeInvokeSetPitch(this.sharedWheelSoundObject, pitch2);
            SoundInvokerUtils.safeInvokeSetPitch(this.sharedWheelSoundSeatedObject, pitch2);
            if (train.honkTicks == 0) {
                if (this.sharedHonkSoundObject != null) {
                    SoundInvokerUtils.safeInvokeStopSound(this.sharedHonkSoundObject);
                    this.sharedHonkSoundObject = null;
                }
                return;
            }
            --train.honkTicks;
            train.determineHonk(this.entity.level());
            if (train.lowHonk == null) {
                return;
            }
            boolean low = train.lowHonk;
            float honkPitch = (float)Math.pow(2.0, (double)train.honkPitch / 12.0);
            AllSoundEvents.SoundEntry endSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL_END : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW_END;
            AllSoundEvents.SoundEntry soundEntry = continuousSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW;
            if (train.honkTicks == 5) {
                endSound.playAt((Level)mc.level, soundLocation, 1.0f, honkPitch, false);
            }
            if (train.honkTicks == 19) {
                endSound.playAt((Level)mc.level, soundLocation, 0.5f, honkPitch, false);
            }
            this.sharedHonkSoundObject = Sounds.playIfMissing(mc, (Sounds.LoopingSound)((Object)((Object)this.sharedHonkSoundObject)), continuousSound.getMainEvent());
            SoundInvokerUtils.safeInvokeSetLocation(this.sharedHonkSoundObject, soundLocation);
            float fadeout = Mth.clamp((float)((float)(3 - train.honkTicks) / 3.0f), (float)0.0f, (float)1.0f);
            float fadein = Mth.clamp((float)((float)(train.honkTicks - 17) / 3.0f), (float)0.0f, (float)1.0f);
            SoundInvokerUtils.safeInvokeSetVolume(this.sharedHonkSoundObject, 1.0f - fadeout - fadein);
            SoundInvokerUtils.safeInvokeSetPitch(this.sharedHonkSoundObject, honkPitch);
        });
    }

    @Inject(method={"stop"}, at={@At(value="TAIL")}, remap=false)
    public void afterStop(CallbackInfo ci) {
        if (this.vvvf1Sound != null) {
            this.vvvf1Sound.stopSound();
        }
        if (this.vvvf2Sound != null) {
            this.vvvf2Sound.stopSound();
        }
        if (this.vvvf3Sound != null) {
            this.vvvf3Sound.stopSound();
        }
        if (this.vvvf4Sound != null) {
            this.vvvf4Sound.stopSound();
        }
        if (this.vvvf5Sound != null) {
            this.vvvf5Sound.stopSound();
        }
        if (this.vvvf6Sound != null) {
            this.vvvf6Sound.stopSound();
        }
        if (this.vvvf7Sound != null) {
            this.vvvf7Sound.stopSound();
        }
        if (this.vvvf8Sound != null) {
            this.vvvf8Sound.stopSound();
        }
        if (this.motor1Sound != null) {
            this.motor1Sound.stopSound();
        }
        if (this.motor2Sound != null) {
            this.motor2Sound.stopSound();
        }
    }
}

