/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall;

import com.mojang.brigadier.CommandDispatcher;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.IStone;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.nest.RabbitBurrowBlock;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.OverlayNF;
import frostnox.nightfall.client.gui.screen.container.BarrelScreen;
import frostnox.nightfall.client.gui.screen.container.CauldronScreen;
import frostnox.nightfall.client.gui.screen.container.ChestScreen;
import frostnox.nightfall.client.gui.screen.container.CrucibleScreen;
import frostnox.nightfall.client.gui.screen.container.SimpleContainerScreen;
import frostnox.nightfall.client.gui.screen.container.TieredAnvilScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryPuzzleScreen;
import frostnox.nightfall.client.model.AnimatedItemModel;
import frostnox.nightfall.client.model.ModelRegistryNF;
import frostnox.nightfall.client.particle.ColoredWaterDropParticle;
import frostnox.nightfall.client.particle.EssenceParticle;
import frostnox.nightfall.client.particle.FadingCloudParticle;
import frostnox.nightfall.client.particle.FadingGlowingParticle;
import frostnox.nightfall.client.particle.FadingParticle;
import frostnox.nightfall.client.particle.FlameParticleNF;
import frostnox.nightfall.client.particle.FloatingParticle;
import frostnox.nightfall.client.particle.FragmentParticle;
import frostnox.nightfall.client.particle.LeafParticle;
import frostnox.nightfall.client.particle.RainParticle;
import frostnox.nightfall.client.particle.SkaraParticle;
import frostnox.nightfall.client.particle.SnowParticle;
import frostnox.nightfall.client.particle.SparkParticle;
import frostnox.nightfall.client.render.ContinentalEffects;
import frostnox.nightfall.client.render.RenderTypeNF;
import frostnox.nightfall.client.render.blockentity.BowlRenderer;
import frostnox.nightfall.client.render.blockentity.CampfireRendererNF;
import frostnox.nightfall.client.render.blockentity.CauldronRenderer;
import frostnox.nightfall.client.render.blockentity.ChestRendererNF;
import frostnox.nightfall.client.render.blockentity.ItemFrameRenderer;
import frostnox.nightfall.client.render.blockentity.ItemMoldRenderer;
import frostnox.nightfall.client.render.blockentity.RackRenderer;
import frostnox.nightfall.client.render.blockentity.ShelfRenderer;
import frostnox.nightfall.client.render.blockentity.SignRendererNF;
import frostnox.nightfall.client.render.blockentity.TieredAnvilRenderer;
import frostnox.nightfall.client.render.entity.ArmorStandDummyRenderer;
import frostnox.nightfall.client.render.entity.ArrowRendererNF;
import frostnox.nightfall.client.render.entity.BoatRendererNF;
import frostnox.nightfall.client.render.entity.CockatriceRenderer;
import frostnox.nightfall.client.render.entity.CreeperRenderer;
import frostnox.nightfall.client.render.entity.DeerRenderer;
import frostnox.nightfall.client.render.entity.DrakefowlBabyRenderer;
import frostnox.nightfall.client.render.entity.DrakefowlRenderer;
import frostnox.nightfall.client.render.entity.DregRenderer;
import frostnox.nightfall.client.render.entity.EctoplasmRenderer;
import frostnox.nightfall.client.render.entity.EntitySpriteRenderer;
import frostnox.nightfall.client.render.entity.HuskRenderer;
import frostnox.nightfall.client.render.entity.JellyfishRenderer;
import frostnox.nightfall.client.render.entity.MovingBlockRenderer;
import frostnox.nightfall.client.render.entity.NameTagRenderer;
import frostnox.nightfall.client.render.entity.OlmurRenderer;
import frostnox.nightfall.client.render.entity.PitDevilRenderer;
import frostnox.nightfall.client.render.entity.RabbitRenderer;
import frostnox.nightfall.client.render.entity.RockwormRenderer;
import frostnox.nightfall.client.render.entity.RopeKnotRenderer;
import frostnox.nightfall.client.render.entity.ScorpionRenderer;
import frostnox.nightfall.client.render.entity.SkeletonRenderer;
import frostnox.nightfall.client.render.entity.SpiderRenderer;
import frostnox.nightfall.client.render.entity.ThrownWeaponRenderer;
import frostnox.nightfall.client.render.entity.TrollRenderer;
import frostnox.nightfall.data.ActionTagsProvider;
import frostnox.nightfall.data.BiomeTagsProviderNF;
import frostnox.nightfall.data.BlockStateProviderNF;
import frostnox.nightfall.data.BlockTagsProviderNF;
import frostnox.nightfall.data.EntityTypeTagsProviderNF;
import frostnox.nightfall.data.FluidTagsProviderNF;
import frostnox.nightfall.data.ItemModelProviderNF;
import frostnox.nightfall.data.ItemTagsProviderNF;
import frostnox.nightfall.data.LanguageProviderNF;
import frostnox.nightfall.data.LootTableProviderNF;
import frostnox.nightfall.data.RecipeProviderNF;
import frostnox.nightfall.data.SpawnGroupTagsProvider;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.TextureProviderNF;
import frostnox.nightfall.data.extensible.TransformTypeNF;
import frostnox.nightfall.data.recipe.BarrelRecipe;
import frostnox.nightfall.data.recipe.BowlCrushingRecipe;
import frostnox.nightfall.data.recipe.BuildingRecipe;
import frostnox.nightfall.data.recipe.CampfireRecipe;
import frostnox.nightfall.data.recipe.CauldronRecipe;
import frostnox.nightfall.data.recipe.CraftingRecipeNF;
import frostnox.nightfall.data.recipe.CrucibleRecipe;
import frostnox.nightfall.data.recipe.FurnaceRecipe;
import frostnox.nightfall.data.recipe.HeldToolRecipe;
import frostnox.nightfall.data.recipe.TieredAnvilRecipe;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.PuzzleContainer;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.entity.entity.ambient.JellyfishEntity;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.entity.entity.animal.DrakefowlBabyEntity;
import frostnox.nightfall.entity.entity.animal.DrakefowlEntity;
import frostnox.nightfall.entity.entity.animal.RabbitEntity;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.entity.entity.monster.CreeperEntity;
import frostnox.nightfall.entity.entity.monster.DregEntity;
import frostnox.nightfall.entity.entity.monster.EctoplasmEntity;
import frostnox.nightfall.entity.entity.monster.HuskEntity;
import frostnox.nightfall.entity.entity.monster.OlmurEntity;
import frostnox.nightfall.entity.entity.monster.PitDevilEntity;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import frostnox.nightfall.entity.entity.monster.ScorpionEntity;
import frostnox.nightfall.entity.entity.monster.SkaraSwarmEntity;
import frostnox.nightfall.entity.entity.monster.SkeletonEntity;
import frostnox.nightfall.entity.entity.monster.SpiderEntity;
import frostnox.nightfall.entity.entity.monster.TrollEntity;
import frostnox.nightfall.entity.entity.projectile.FireSpitEntity;
import frostnox.nightfall.item.IArmament;
import frostnox.nightfall.item.IDye;
import frostnox.nightfall.item.IStyle;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.item.BowItemNF;
import frostnox.nightfall.item.item.ProjectileLauncherItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.command.EntryCommand;
import frostnox.nightfall.network.command.GodModeCommand;
import frostnox.nightfall.network.command.InfoCommand;
import frostnox.nightfall.network.command.KnowledgeCommand;
import frostnox.nightfall.network.command.ReselectAttributesCommand;
import frostnox.nightfall.network.command.SeasonCommand;
import frostnox.nightfall.network.command.TimeCommandNF;
import frostnox.nightfall.network.command.WeatherCommandNF;
import frostnox.nightfall.network.command.argument.EntryArgument;
import frostnox.nightfall.network.command.argument.KnowledgeArgument;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.SpawnGroupsNF;
import frostnox.nightfall.registry.WorldConditionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.BiomesNF;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ContainersNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.FeaturesNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.registry.forge.StructuresNF;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.registry.vanilla.LootItemConditionTypesNF;
import frostnox.nightfall.registry.vanilla.LootItemFunctionTypesNF;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.world.ContinentalWorldType;
import frostnox.nightfall.world.FlatWorldType;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.biome.ContinentalBiomeSource;
import frostnox.nightfall.world.condition.WorldCondition;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.FlatChunkGenerator;
import frostnox.nightfall.world.inventory.PlayerInventoryContainer;
import frostnox.nightfall.world.inventory.StorageContainer;
import frostnox.nightfall.world.spawngroup.SpawnGroup;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="nightfall")
public class Nightfall {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "nightfall";
    public static boolean isRubidiumLoaded;
    public static IEventBus MOD_EVENT_BUS;

    public Nightfall() {
        MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        isRubidiumLoaded = ModList.get().isLoaded("rubidium");
        ActionsNF.register();
        AttributesNF.register();
        BiomesNF.register();
        BlockEntitiesNF.register();
        BlocksNF.register();
        ContainersNF.register();
        DataSerializersNF.register();
        EffectsNF.register();
        EntriesNF.register();
        KnowledgeNF.register();
        EntitiesNF.register();
        FluidsNF.register();
        ItemsNF.register();
        ParticleTypesNF.register();
        SoundsNF.register();
        SpawnGroupsNF.register();
        StructuresNF.register();
        WorldConditionsNF.register();
    }

    @SubscribeEvent
    public static void onNewRegistryEvent(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setType(Action.class).setName(RegistriesNF.ACTIONS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving().hasTags());
        event.create(new RegistryBuilder().setType(Entry.class).setName(RegistriesNF.ENTRIES_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(Knowledge.class).setName(RegistriesNF.KNOWLEDGE_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(WorldCondition.class).setName(RegistriesNF.WORLD_CONDITIONS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(SpawnGroup.class).setName(RegistriesNF.SPAWN_GROUPS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving().hasTags());
        event.create(new RegistryBuilder().setType(IArmament.Entry.class).setName(RegistriesNF.ARMAMENTS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(IDye.Entry.class).setName(RegistriesNF.DYES_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(IMetal.Entry.class).setName(RegistriesNF.METALS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(ISoil.Entry.class).setName(RegistriesNF.SOILS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(IStone.Entry.class).setName(RegistriesNF.STONES_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(IStyle.Entry.class).setName(RegistriesNF.STYLES_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(ITieredArmorMaterial.Entry.class).setName(RegistriesNF.TIERED_ARMOR_MATERIALS_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
        event.create(new RegistryBuilder().setType(ITree.Entry.class).setName(RegistriesNF.TREES_KEY.m_135782_()).setMaxID(0x7FFFFFFE).disableSync().disableSaving());
    }

    @SubscribeEvent
    public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
        NetworkHandler.register();
        event.enqueueWork(() -> {
            ArgumentTypes.m_121601_((String)"nightfall:entry", EntryArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(EntryArgument::id));
            ArgumentTypes.m_121601_((String)"nightfall:knowledge", KnowledgeArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(KnowledgeArgument::id));
            Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"continental"), ContinentalBiomeSource.CODEC);
            Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"continental"), ContinentalChunkGenerator.CODEC);
            Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"flat"), FlatChunkGenerator.CODEC);
            ActionsNF.init();
            FluidsNF.init();
            PlayerActionSet.init();
        });
    }

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientEngine.get().dataExcludedInit();
            ClientRegistry.registerKeyBinding((KeyMapping)ClientEngine.get().keyDash);
            ClientRegistry.registerKeyBinding((KeyMapping)ClientEngine.get().keyOffhand);
            ClientRegistry.registerKeyBinding((KeyMapping)ClientEngine.get().keyEncyclopedia);
            ClientRegistry.registerKeyBinding((KeyMapping)ClientEngine.get().keyModify);
            WorldPreset.f_101508_.clear();
            DimensionSpecialEffects.f_108857_.put((Object)ContinentalWorldType.LOCATION, (Object)new ContinentalEffects(672.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false));
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.BARREL.get()), BarrelScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.CAULDRON.get()), CauldronScreen::new);
            final ResourceLocation pot = ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"textures/gui/screen/pot.png");
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.POT.get()), (menu, inv, title) -> new SimpleContainerScreen<StorageContainer>(menu, inv, title){

                @Override
                public ResourceLocation getTexture() {
                    return pot;
                }

                @Override
                protected ResourceLocation getInventoryTexture() {
                    return INVENTORY_TERRACOTTA_TEXTURE;
                }
            });
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.CHEST_9x3.get()), ChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.CHEST_9x6.get()), ChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.CRUCIBLE.get()), CrucibleScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.TIERED_ANVIL.get()), TieredAnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ContainersNF.ENCYCLOPEDIA_PUZZLE.get()), EntryPuzzleScreen::new);
            ItemPropertyFunction slingSwinging = (item, level, user, seed) -> {
                if (user != null && ActionTracker.isPresent((Entity)user)) {
                    InteractionHand hand;
                    IActionTracker capA = ActionTracker.get((Entity)user);
                    if (user instanceof Player) {
                        Player player = (Player)user;
                        v0 = PlayerData.get(player).getActiveHand();
                    } else {
                        v0 = hand = InteractionHand.MAIN_HAND;
                    }
                    if (user.m_21120_(hand) == item && capA.getAction().is(TagsNF.SLING_ACTION)) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            };
            ItemProperties.register((Item)((Item)ItemsNF.SLING.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"swinging"), (ItemPropertyFunction)slingSwinging);
            ItemProperties.register((Item)((Item)ItemsNF.SLING_REINFORCED.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"swinging"), (ItemPropertyFunction)slingSwinging);
            ItemPropertyFunction bowPull = (item, level, user, seed) -> {
                if (user != null && ActionTracker.isPresent((Entity)user)) {
                    IActionTracker capA = ActionTracker.get((Entity)user);
                    if (user instanceof Player) {
                        Player player = (Player)user;
                        InteractionHand hand = PlayerData.get(player).getActiveHand();
                        if (user.m_21120_(hand) == item && capA.getAction().is(TagsNF.BOW_ACTION) && capA.isCharging()) {
                            return capA.getProgress(1.0f);
                        }
                    } else {
                        Action action = capA.getAction();
                        if (user.m_21205_() == item && action.is(TagsNF.BOW_ACTION) && capA.getState() == action.getChargeState() - 1) {
                            return capA.getProgress(1.0f);
                        }
                    }
                }
                return 0.0f;
            };
            ItemPropertyFunction bowAmmo = (item, level, user, seed) -> ProjectileLauncherItem.getAmmoByte(item);
            for (RegistryObject<BowItemNF> bow : Stream.concat(ItemsNF.BOWS.values().stream(), Stream.of(ItemsNF.TWISTED_BOW)).toList()) {
                ItemProperties.register((Item)((Item)bow.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"pull"), (ItemPropertyFunction)bowPull);
                ItemProperties.register((Item)((Item)bow.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"ammo"), (ItemPropertyFunction)bowAmmo);
            }
        });
        ArrayList<Object> cutout = new ArrayList<Object>();
        ArrayList<Object> cutoutMipped = new ArrayList<Object>();
        ArrayList<RegistryObject<RabbitBurrowBlock>> translucent = new ArrayList<RegistryObject<RabbitBurrowBlock>>();
        cutoutMipped.addAll(BlocksNF.getCoveredSoils());
        for (Tree type : Tree.values()) {
            cutoutMipped.addAll(List.of(BlocksNF.LEAVES.get(type)));
            cutout.addAll(List.of(BlocksNF.TREE_SEEDS.get(type), BlocksNF.PLANK_TRAPDOORS.get(type), BlocksNF.PLANK_HATCHES.get(type), BlocksNF.PLANK_DOORS.get(type), BlocksNF.PLANK_LADDERS.get(type), BlocksNF.CHAIRS.get(type)));
        }
        cutout.addAll(BlocksNF.FRUIT_LEAVES.values());
        cutout.addAll(BlocksNF.BRANCHES.values());
        cutoutMipped.addAll(List.of(BlocksNF.FRAZIL, BlocksNF.SEA_FRAZIL));
        cutout.addAll(List.of(BlocksNF.SHORT_GRASS, BlocksNF.GRASS, BlocksNF.TALL_GRASS, BlocksNF.SMALL_FERN, BlocksNF.FERN, BlocksNF.LARGE_FERN, BlocksNF.VINES, BlocksNF.GLASS_BLOCK, BlocksNF.GLASS_SLAB, BlocksNF.GLASS_SIDING, BlocksNF.CRUCIBLE, BlocksNF.TORCH, BlocksNF.TORCH_UNLIT, BlocksNF.WALL_TORCH, BlocksNF.WALL_TORCH_UNLIT, BlocksNF.CAMPFIRE, BlocksNF.DEAD_CROP, BlocksNF.DEAD_PLANT, BlocksNF.POTATOES, BlocksNF.CARROTS, BlocksNF.FLAX, BlocksNF.YARROW, BlocksNF.BERRY_BUSH, BlocksNF.WARDING_EFFIGY, BlocksNF.DEAD_BUSH, BlocksNF.FIRE, BlocksNF.SPIDER_WEB));
        cutout.addAll(BlocksNF.LANTERNS.values());
        cutout.addAll(BlocksNF.LANTERNS_UNLIT.values());
        translucent.addAll(List.of(BlocksNF.MOON_ESSENCE, BlocksNF.ICE, BlocksNF.RABBIT_BURROW));
        for (RegistryObject registryObject : cutout) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject registryObject : cutoutMipped) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110457_());
        }
        for (RegistryObject registryObject : translucent) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110466_());
        }
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsNF.WATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsNF.WATER_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsNF.SEAWATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsNF.SEAWATER_FLOWING.get()), (RenderType)RenderType.m_110466_());
        OverlayNF.register();
        TransformTypeNF.init();
    }

    @SubscribeEvent
    public static void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new ActionTagsProvider(gen, MODID, helper));
            gen.m_123914_((DataProvider)new BiomeTagsProviderNF(gen, MODID, helper));
            BlockTagsProviderNF blockTagsProvider = new BlockTagsProviderNF(gen, MODID, helper);
            gen.m_123914_((DataProvider)blockTagsProvider);
            gen.m_123914_((DataProvider)new EntityTypeTagsProviderNF(gen, MODID, helper));
            gen.m_123914_((DataProvider)new ItemTagsProviderNF(gen, blockTagsProvider, MODID, helper));
            gen.m_123914_((DataProvider)new FluidTagsProviderNF(gen, MODID, helper));
            gen.m_123914_((DataProvider)new LootTableProviderNF(gen));
            gen.m_123914_((DataProvider)new RecipeProviderNF(gen));
            gen.m_123914_((DataProvider)new SpawnGroupTagsProvider(gen, MODID, helper));
        }
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new TextureProviderNF(gen, MODID, helper));
            gen.m_123914_((DataProvider)new BlockStateProviderNF(gen, MODID, helper));
            gen.m_123914_((DataProvider)new ItemModelProviderNF(gen, MODID, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new LanguageProviderNF(gen, MODID, "en_us"));
        }
    }

    @SubscribeEvent
    public static void onRegisterBlockEvent(RegistryEvent.Register<Block> event) {
        GameEventsNF.register();
        LootItemConditionTypesNF.register();
        LootItemFunctionTypesNF.register();
        PlacementModifierTypesNF.register();
    }

    @SubscribeEvent
    public static void onRegisterFeatureEvent(RegistryEvent.Register<Feature<?>> event) {
        FeaturesNF.registerEvent(event);
        StructuresNF.registerEvent();
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializerEvent(RegistryEvent.Register<RecipeSerializer<?>> event) {
        event.getRegistry().register(BowlCrushingRecipe.SERIALIZER);
        event.getRegistry().register(HeldToolRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)CraftingRecipeNF.SERIALIZER);
        event.getRegistry().register(CauldronRecipe.SERIALIZER);
        event.getRegistry().register(CrucibleRecipe.SERIALIZER);
        event.getRegistry().register(FurnaceRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)TieredAnvilRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)BuildingRecipe.SERIALIZER);
        event.getRegistry().register(CampfireRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)BarrelRecipe.SERIALIZER);
    }

    @SubscribeEvent
    public static void onRegisterWorldTypeEvent(RegistryEvent.Register<ForgeWorldPreset> event) {
        event.getRegistry().register((IForgeRegistryEntry)new ContinentalWorldType());
        event.getRegistry().register((IForgeRegistryEntry)new FlatWorldType());
    }

    @SubscribeEvent
    public static void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        event.register(IPlayerData.class);
        event.register(IActionTracker.class);
        event.register(IChunkData.class);
        event.register(ILevelData.class);
    }

    @SubscribeEvent
    public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntitiesNF.RABBIT.get(), RabbitEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.DEER.get(), DeerEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get(), DrakefowlEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.DRAKEFOWL_HEN.get(), DrakefowlEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.DRAKEFOWL_CHICK.get(), DrakefowlBabyEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.HUSK.get(), HuskEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.SKELETON.get(), SkeletonEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.DREG.get(), DregEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.CREEPER.get(), CreeperEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.COCKATRICE.get(), CockatriceEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.SPIDER.get(), SpiderEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.ROCKWORM.get(), RockwormEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.PIT_DEVIL.get(), PitDevilEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.ECTOPLASM_LARGE.get(), EctoplasmEntity.getLargeAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.ECTOPLASM_MEDIUM.get(), EctoplasmEntity.getMediumAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.ECTOPLASM_SMALL.get(), EctoplasmEntity.getSmallAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.SCORPION.get(), ScorpionEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.SKARA_SWARM.get(), SkaraSwarmEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.TROLL.get(), TrollEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.OLMUR.get(), OlmurEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.JELLYFISH.get(), JellyfishEntity.getAttributeMap().m_22265_());
        event.put((EntityType)EntitiesNF.ARMOR_STAND.get(), LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22265_());
    }

    @SubscribeEvent
    public static void onEntityAttributeModificationEvent(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.INVENTORY_CAPACITY.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.ACTION_SPEED.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.STAMINA_REDUCTION.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.ENDURANCE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.WILLPOWER.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.STRENGTH.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.PERCEPTION.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.STRIKING_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.SLASHING_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.PIERCING_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.FIRE_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.FROST_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.ELECTRIC_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.WITHER_DEFENSE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.POISE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.BLEEDING_RESISTANCE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributesNF.POISON_RESISTANCE.get());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Config {
        public static ForgeConfigSpec COMMON_CONFIG;
        public static ForgeConfigSpec CLIENT_CONFIG;
        public static final ForgeConfigSpec.BooleanValue DISPLAY_CONTROLS_MESSAGE;

        static {
            ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
            clientBuilder.comment("Client Settings").push("client");
            DISPLAY_CONTROLS_MESSAGE = clientBuilder.comment("If true, displays the command to show controls upon joining a world").define("displayControlsMessage", true);
            clientBuilder.pop();
            CLIENT_CONFIG = clientBuilder.build();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeRegistryEvents {
        @SubscribeEvent
        public static void onRegisterCommandsEvent(RegisterCommandsEvent event) {
            EntryCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            GodModeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            InfoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            KnowledgeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ReselectAttributesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            SeasonCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            TimeCommandNF.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            WeatherCommandNF.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientRegistryEvents {
        @SubscribeEvent
        public static void onRegisterClientReloadListenersEvent(RegisterClientReloadListenersEvent event) {
            ClientEngine.registerClientReloadListeners(event);
        }

        @SubscribeEvent
        public static void onBlockColorHandlerEvent(ColorHandlerEvent.Block event) {
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> {
                if (tintIndex == 1) {
                    if (level != null && pos != null && LevelData.isPresent((Level)Minecraft.m_91087_().f_91073_)) {
                        LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_46745_(pos);
                        IChunkData capC = ChunkData.get(chunk);
                        return ClientEngine.get().getGrassColor(capC.getTemperature(pos), capC.getHumidity(pos));
                    }
                    return ClientEngine.get().getGrassColor(0.8f, 0.4f);
                }
                return Color.WHITE.getRGB();
            }, new Block[]{(Block)BlocksNF.COVERED_SILT.get((Object)SoilCover.GRASS).get(), (Block)BlocksNF.COVERED_DIRT.get((Object)SoilCover.GRASS).get(), (Block)BlocksNF.COVERED_LOAM.get((Object)SoilCover.GRASS).get()});
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> {
                if (tintIndex == 0) {
                    if (level != null && pos != null && LevelData.isPresent((Level)Minecraft.m_91087_().f_91073_)) {
                        LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_46745_(pos);
                        IChunkData capC = ChunkData.get(chunk);
                        return ClientEngine.get().getGrassColor(capC.getTemperature(pos), capC.getHumidity(pos));
                    }
                    return ClientEngine.get().getGrassColor(0.8f, 0.4f);
                }
                return Color.WHITE.getRGB();
            }, new Block[]{(Block)BlocksNF.SHORT_GRASS.get(), (Block)BlocksNF.GRASS.get(), (Block)BlocksNF.TALL_GRASS.get(), (Block)BlocksNF.SMALL_FERN.get(), (Block)BlocksNF.FERN.get(), (Block)BlocksNF.LARGE_FERN.get(), (Block)BlocksNF.VINES.get()});
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> {
                if (tintIndex == 1) {
                    if (level != null && pos != null && LevelData.isPresent((Level)Minecraft.m_91087_().f_91073_)) {
                        LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_46745_(pos);
                        IChunkData capC = ChunkData.get(chunk);
                        return ClientEngine.get().getForestColor(capC.getTemperature(pos));
                    }
                    return ClientEngine.get().getForestColor(0.5f);
                }
                return Color.WHITE.getRGB();
            }, new Block[]{(Block)BlocksNF.COVERED_SILT.get((Object)SoilCover.FOREST).get(), (Block)BlocksNF.COVERED_DIRT.get((Object)SoilCover.FOREST).get(), (Block)BlocksNF.COVERED_LOAM.get((Object)SoilCover.FOREST).get()});
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> {
                if (tintIndex == 1) {
                    if (level != null && pos != null && LevelData.isPresent((Level)Minecraft.m_91087_().f_91073_)) {
                        LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_46745_(pos);
                        IChunkData capC = ChunkData.get(chunk);
                        return ClientEngine.get().getLichenColor(capC.getHumidity(pos) * 3.0f);
                    }
                    return ClientEngine.get().getLichenColor(0.5f);
                }
                return Color.WHITE.getRGB();
            }, new Block[]{(Block)BlocksNF.COVERED_SILT.get((Object)SoilCover.LICHEN).get(), (Block)BlocksNF.COVERED_DIRT.get((Object)SoilCover.LICHEN).get(), (Block)BlocksNF.COVERED_LOAM.get((Object)SoilCover.LICHEN).get()});
            for (Tree type : Tree.values()) {
                if (!type.isDeciduous()) continue;
                event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> ClientEngine.get().getLeavesColor(type, Season.getNormalizedProgress((Level)Minecraft.m_91087_().f_91073_)), new Block[]{(Block)BlocksNF.LEAVES.get(type).get(), (Block)BlocksNF.TREE_SEEDS.get(type).get()});
            }
            for (Tree type : BlocksNF.FRUIT_LEAVES.keySet()) {
                if (!type.isDeciduous()) continue;
                event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> tintIndex == 0 ? ClientEngine.get().getLeavesColor(type, Season.getNormalizedProgress((Level)Minecraft.m_91087_().f_91073_)) : Color.WHITE.getRGB(), new Block[]{(Block)BlocksNF.FRUIT_LEAVES.get(type).get()});
            }
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) : -1, new Block[]{(Block)BlocksNF.WATER.get()});
        }

        @SubscribeEvent
        public static void onItemColorHandlerEvent(ColorHandlerEvent.Item event) {
            ArrayList<Block> coloredBlockItems = new ArrayList<Block>();
            coloredBlockItems.addAll(BlocksNF.COVERED_SILT.values().stream().filter(block -> ((CoveredSoilBlock)block.get()).soilCover != SoilCover.MOSS).map(RegistryObject::get).toList());
            coloredBlockItems.addAll(BlocksNF.COVERED_DIRT.values().stream().filter(block -> ((CoveredSoilBlock)block.get()).soilCover != SoilCover.MOSS).map(RegistryObject::get).toList());
            coloredBlockItems.addAll(BlocksNF.COVERED_LOAM.values().stream().filter(block -> ((CoveredSoilBlock)block.get()).soilCover != SoilCover.MOSS).map(RegistryObject::get).toList());
            coloredBlockItems.addAll(BlocksNF.LEAVES.values().stream().map(RegistryObject::get).toList());
            coloredBlockItems.addAll(BlocksNF.FRUIT_LEAVES.values().stream().map(RegistryObject::get).toList());
            coloredBlockItems.addAll(List.of((Block)BlocksNF.SHORT_GRASS.get(), (Block)BlocksNF.GRASS.get(), (Block)BlocksNF.TALL_GRASS.get(), (Block)BlocksNF.SMALL_FERN.get(), (Block)BlocksNF.FERN.get(), (Block)BlocksNF.LARGE_FERN.get(), (Block)BlocksNF.VINES.get()));
            event.getItemColors().m_92689_((stack, layer) -> {
                BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                return event.getBlockColors().m_92577_(blockstate, null, null, layer);
            }, (ItemLike[])coloredBlockItems.toArray(ItemLike[]::new));
            List<Item> dyeableItems = Stream.of(ItemsNF.ITEMS.getEntries()).flatMap(Collection::stream).map(RegistryObject::get).filter(item -> item instanceof DyeableLeatherItem).toList();
            event.getItemColors().m_92689_((stack, layer) -> layer > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), (ItemLike[])dyeableItems.toArray(ItemLike[]::new));
        }

        @SubscribeEvent
        public static void onModelRegistryEvent(ModelRegistryEvent event) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)"animated-item"), (IModelLoader)AnimatedItemModel.Loader.INSTANCE);
        }

        @SubscribeEvent
        public static void onRegisterLayerDefinitionsEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
            ModelRegistryNF.init(event);
        }

        @SubscribeEvent
        public static void onEntityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntitiesNF.RABBIT.get(), RabbitRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.DEER.get(), DeerRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get(), DrakefowlRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.DRAKEFOWL_HEN.get(), DrakefowlRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.DRAKEFOWL_CHICK.get(), DrakefowlBabyRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.HUSK.get(), HuskRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.SKELETON.get(), SkeletonRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.DREG.get(), DregRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.CREEPER.get(), CreeperRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.COCKATRICE.get(), CockatriceRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.SPIDER.get(), SpiderRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.ROCKWORM.get(), RockwormRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.PIT_DEVIL.get(), PitDevilRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.ECTOPLASM_LARGE.get(), context -> new EctoplasmRenderer(context, 0.75f, ModelRegistryNF.ECTOPLASM_LARGE_INNER, ModelRegistryNF.ECTOPLASM_LARGE_OUTER_INNER, ModelRegistryNF.ECTOPLASM_LARGE_OUTER));
            event.registerEntityRenderer((EntityType)EntitiesNF.ECTOPLASM_MEDIUM.get(), context -> new EctoplasmRenderer(context, 0.5f, ModelRegistryNF.ECTOPLASM_MEDIUM_INNER, ModelRegistryNF.ECTOPLASM_MEDIUM_OUTER_INNER, ModelRegistryNF.ECTOPLASM_MEDIUM_OUTER));
            event.registerEntityRenderer((EntityType)EntitiesNF.ECTOPLASM_SMALL.get(), context -> new EctoplasmRenderer(context, 0.2f, ModelRegistryNF.ECTOPLASM_SMALL_INNER, ModelRegistryNF.ECTOPLASM_SMALL_OUTER_INNER, ModelRegistryNF.ECTOPLASM_SMALL_OUTER));
            event.registerEntityRenderer((EntityType)EntitiesNF.SCORPION.get(), ScorpionRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.SKARA_SWARM.get(), NameTagRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.TROLL.get(), TrollRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.OLMUR.get(), OlmurRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.JELLYFISH.get(), JellyfishRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.ARMOR_STAND.get(), ArmorStandDummyRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.BOAT.get(), BoatRendererNF::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.SEAT.get(), NoopRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.ROPE_KNOT.get(), RopeKnotRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.MOVING_BLOCK.get(), MovingBlockRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.THROWN_ROCK.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.ARROW.get(), ArrowRendererNF::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.THROWN_WEAPON.get(), ThrownWeaponRenderer::new);
            event.registerEntityRenderer((EntityType)EntitiesNF.POISON_SPIT.get(), NoopRenderer::new);
            final ResourceLocation FIRE_SPIT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)"textures/entity/projectile/fire_spit.png");
            event.registerEntityRenderer((EntityType)EntitiesNF.FIRE_SPIT.get(), context -> new EntitySpriteRenderer<FireSpitEntity>(context, 0.25f, 0.0f, 0.0f){

                protected int getBlockLightLevel(FireSpitEntity pEntity, BlockPos pPos) {
                    return 15;
                }

                public ResourceLocation getTextureLocation(FireSpitEntity pEntity) {
                    return FIRE_SPIT_TEXTURE;
                }
            });
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.ANVIL.get(), TieredAnvilRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.BOWL.get(), BowlRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.CAULDRON.get(), CauldronRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.CAMPFIRE.get(), CampfireRendererNF::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.CHEST.get(), ChestRendererNF::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.SIGN.get(), SignRendererNF::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.ITEM_FRAME.get(), ItemFrameRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.RACK.get(), RackRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.SHELF.get(), ShelfRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntitiesNF.ITEM_MOLD.get(), ItemMoldRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterShadersEvent(RegisterShadersEvent event) throws IOException {
            RenderTypeNF.registerShaders(event);
        }

        @SubscribeEvent
        public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
            ChestRendererNF.stitchChestTextures(event);
            SignRendererNF.stitchSignTextures(event);
            if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
                event.addSprite(KnowledgeNF.KNOWLEDGE_TEXTURE);
                event.addSprite(KnowledgeNF.UNKNOWN_KNOWLEDGE_TEXTURE);
                event.addSprite(WorldConditionsNF.SATISFIED_CONDITION_TEXTURE);
                event.addSprite(WorldConditionsNF.UNSATISFIED_CONDITION_TEXTURE);
                event.addSprite(FluidsNF.METAL_STILL);
                event.addSprite(FluidsNF.METAL_FLOW);
                event.addSprite(FluidsNF.METAL_SOLID);
                event.addSprite(PlayerInventoryContainer.EMPTY_ACCESSORY_SLOT_FACE);
                event.addSprite(PlayerInventoryContainer.EMPTY_ACCESSORY_SLOT_NECK);
                event.addSprite(PlayerInventoryContainer.EMPTY_ACCESSORY_SLOT_WAIST);
                event.addSprite(PlayerInventoryContainer.EMPTY_RECIPE_SEARCH_SLOT);
                event.addSprite(PuzzleContainer.UNKNOWN_ITEM);
                event.addSprite(PuzzleContainer.FAILURE);
                event.addSprite(PuzzleContainer.SUCCESS);
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.MEAT_STEW.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.VEGETABLE_STEW.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.HEARTY_STEW.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.SUSPICIOUS_STEW.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.BOILED_EGG.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.SOUFFLE.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.SOUFFLE.getId().m_135815_() + "_side")));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.FRUIT_SOUFFLE.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.FRUIT_SOUFFLE.getId().m_135815_() + "_side")));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.SAVORY_SOUFFLE.getId().m_135815_())));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)("block/" + ItemsNF.SAVORY_SOUFFLE.getId().m_135815_() + "_side")));
                event.addSprite(ResourceLocation.fromNamespaceAndPath((String)Nightfall.MODID, (String)"block/terracotta_darkened"));
            }
        }

        @SubscribeEvent
        public static void onParticleFactoryRegisterEvent(ParticleFactoryRegisterEvent event) {
            ParticleEngine engine = Minecraft.m_91087_().f_91061_;
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_BIRCH.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_CAEDTAR.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_IRONWOOD.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_JUNGLE.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_MAPLE.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_OAK.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LEAF_WILLOW.get(), LeafParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FLAME_RED.get(), FlameParticleNF.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FLAME_ORANGE.get(), FlameParticleNF.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FLAME_YELLOW.get(), FlameParticleNF.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FLAME_WHITE.get(), FlameParticleNF.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FLAME_BLUE.get(), FlameParticleNF.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SPARK_RED.get(), SparkParticle.RedProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SPARK_ORANGE.get(), SparkParticle.OrangeProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SPARK_YELLOW.get(), SparkParticle.YellowProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SPARK_WHITE.get(), SparkParticle.WhiteProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SPARK_BLUE.get(), SparkParticle.BlueProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.ESSENCE.get(), EssenceParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.ESSENCE_MOON.get(), EssenceParticle.MoonProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.BLOOD_RED.get(), FadingParticle.RedProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.BLOOD_DARK_RED.get(), FadingParticle.DarkRedProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.BLOOD_PALE_BLUE.get(), FadingParticle.PaleBlueProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.BLOOD_GREEN.get(), FadingParticle.GreenProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.ECTOPLASM.get(), FadingGlowingParticle.EctoplasmProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FRAGMENT_BONE.get(), FragmentParticle.BoneProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FRAGMENT_CREEPER.get(), FragmentParticle.CreeperProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.POISON_SPIT.get(), FadingParticle.PoisonSpitProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.DRIPPING_WATER.get(), WaterHangProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FALLING_WATER.get(), WaterFallProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.DRIPPING_LAVA.get(), LavaHangProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FALLING_LAVA.get(), LavaFallProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.LANDING_LAVA.get(), LavaLandProvider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.POISON.get(), FloatingParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.RAIN.get(), RainParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.RAIN_SPLASH.get(), ColoredWaterDropParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SNOW.get(), SnowParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.FADING_CLOUD.get(), FadingCloudParticle.Provider::new);
            engine.m_107378_((ParticleType)ParticleTypesNF.SKARA.get(), SkaraParticle.Provider::new);
        }

        public static class LavaHangProvider
        implements ParticleProvider<SimpleParticleType> {
            protected final SpriteSet sprite;

            public LavaHangProvider(SpriteSet pSprites) {
                this.sprite = pSprites;
            }

            public Particle createParticle(SimpleParticleType pType, ClientLevel level, double x, double pY, double z, double xSpeed, double pYSpeed, double zSpeed) {
                DripParticle.CoolingDripHangParticle dripparticle = new DripParticle.CoolingDripHangParticle(level, x, pY, z, (Fluid)FluidsNF.LAVA.get(), (ParticleOptions)ParticleTypesNF.FALLING_LAVA.get());
                dripparticle.m_108335_(this.sprite);
                return dripparticle;
            }
        }

        public static class LavaFallProvider
        implements ParticleProvider<SimpleParticleType> {
            protected final SpriteSet sprite;

            public LavaFallProvider(SpriteSet pSprites) {
                this.sprite = pSprites;
            }

            public Particle createParticle(SimpleParticleType pType, ClientLevel level, double x, double pY, double z, double xSpeed, double pYSpeed, double zSpeed) {
                DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, pY, z, (Fluid)FluidsNF.LAVA.get(), (ParticleOptions)ParticleTypesNF.LANDING_LAVA.get());
                dripparticle.m_107253_(0.839f, 0.153f, 0.047f);
                dripparticle.m_108335_(this.sprite);
                return dripparticle;
            }
        }

        public static class LavaLandProvider
        implements ParticleProvider<SimpleParticleType> {
            protected final SpriteSet sprite;

            public LavaLandProvider(SpriteSet pSprites) {
                this.sprite = pSprites;
            }

            public Particle createParticle(SimpleParticleType pType, ClientLevel level, double x, double pY, double z, double xSpeed, double pYSpeed, double zSpeed) {
                DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, pY, z, (Fluid)FluidsNF.LAVA.get());
                dripparticle.m_107253_(0.839f, 0.153f, 0.047f);
                dripparticle.m_108335_(this.sprite);
                return dripparticle;
            }
        }

        public static class WaterHangProvider
        implements ParticleProvider<SimpleParticleType> {
            protected final SpriteSet sprite;

            public WaterHangProvider(SpriteSet pSprites) {
                this.sprite = pSprites;
            }

            public Particle createParticle(SimpleParticleType pType, ClientLevel level, double x, double pY, double z, double xSpeed, double pYSpeed, double zSpeed) {
                DripParticle.DripHangParticle dripparticle = new DripParticle.DripHangParticle(level, x, pY, z, (Fluid)FluidsNF.WATER.get(), (ParticleOptions)ParticleTypesNF.FALLING_WATER.get());
                dripparticle.m_107253_(0.333f, 0.486f, 0.561f);
                dripparticle.m_108335_(this.sprite);
                return dripparticle;
            }
        }

        public static class WaterFallProvider
        implements ParticleProvider<SimpleParticleType> {
            protected final SpriteSet sprite;

            public WaterFallProvider(SpriteSet pSprites) {
                this.sprite = pSprites;
            }

            public Particle createParticle(SimpleParticleType pType, ClientLevel level, double x, double pY, double z, double xSpeed, double pYSpeed, double zSpeed) {
                DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, pY, z, (Fluid)FluidsNF.WATER.get(), (ParticleOptions)ParticleTypes.f_123769_);
                dripparticle.m_107253_(0.333f, 0.486f, 0.561f);
                dripparticle.m_108335_(this.sprite);
                return dripparticle;
            }
        }
    }
}

