/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class Action
extends ForgeRegistryEntry<Action> {
    public static final int DEFAULT_DURATION = 2;
    public static final int CHARGE_MAX = 32768;
    private final int[] duration;
    private final boolean interruptible;
    private final boolean looping;
    private final boolean freeze;
    private final boolean sprinting;
    private final boolean crawling;
    private final boolean special;
    private final int chainState;
    private final int chargeState;
    public final Set<ResourceLocation> linkedActions = new HashSet<ResourceLocation>();
    private final RegistryObject<? extends Action> from;
    private final RegistryObject<? extends Action> to;
    private final RegistryObject<? extends Action> conditionalTo;
    private final Function<LivingEntity, Boolean> conditionalFunction;
    private final Supplier<SoundEvent> sound;
    private final Supplier<SoundEvent> extraSound;
    public final TagKey<Block> harvestableBlocks;
    private final float knockback;
    private final Impact impact;

    public Action(int ... duration) {
        this.chainState = -1;
        this.from = ActionsNF.EMPTY;
        this.to = ActionsNF.EMPTY;
        this.conditionalTo = ActionsNF.EMPTY;
        this.conditionalFunction = null;
        this.chargeState = -1;
        this.interruptible = false;
        this.looping = false;
        this.freeze = false;
        this.sprinting = false;
        this.crawling = false;
        this.special = false;
        this.duration = duration;
        this.sound = () -> null;
        this.extraSound = () -> null;
        this.harvestableBlocks = null;
        this.knockback = 0.0f;
        this.impact = Impact.NONE;
    }

    public Action(Properties properties, int ... duration) {
        this.chainState = properties.chainState;
        this.from = properties.from;
        this.to = properties.to;
        this.conditionalTo = properties.conditionalTo;
        this.conditionalFunction = properties.conditionalFunction;
        this.chargeState = properties.chargeState;
        this.interruptible = properties.interruptible;
        this.looping = properties.looping;
        this.freeze = properties.freeze;
        this.sprinting = properties.sprinting;
        this.crawling = properties.crawling;
        this.special = properties.special;
        this.duration = duration;
        this.sound = properties.sound;
        this.extraSound = properties.extraSound;
        this.harvestableBlocks = properties.harvestableBlocks;
        this.knockback = properties.knockback;
        this.impact = properties.impact;
    }

    public boolean equals(Object object) {
        if (object instanceof Action) {
            Action action = (Action)((Object)object);
            return action.getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    public String toString() {
        if (this.getRegistryName() == null) {
            return super.toString();
        }
        return this.getRegistryName().m_135815_();
    }

    public void init() {
        this.addToSet(this.from);
        this.addToSet(this.to);
        this.addToSet(this.conditionalTo);
    }

    private void addToSet(RegistryObject<? extends Action> object) {
        if (object.getId().equals((Object)ActionsNF.EMPTY.getId()) || this.linkedActions.contains(object.getId())) {
            return;
        }
        this.linkedActions.add(object.getId());
        Action action = (Action)((Object)object.get());
        if (!ActionsNF.isEmpty(action.chainsFrom().getId())) {
            this.addToSet(action.chainsFrom());
        }
        if (!ActionsNF.isEmpty(action.chainsTo().getId())) {
            this.addToSet(action.chainsTo());
        }
        if (!ActionsNF.isEmpty(action.conditionalChainsTo().getId())) {
            this.addToSet(action.conditionalChainsTo());
        }
    }

    public boolean is(TagKey<Action> tag) {
        return ActionsNF.isTagged(this, tag);
    }

    public boolean isEmpty() {
        return ActionsNF.isEmpty(this.getRegistryName());
    }

    public boolean canStart(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (capA.isInactive()) {
            return true;
        }
        if (capA.isStunned()) {
            return false;
        }
        Action action = capA.getAction();
        if (this.isActionEqualOrLinked(capA.getActionID())) {
            if (capA.getState() == action.getTotalStates() - 1 && capA.getFrame() >= capA.getDuration() - 3) {
                return true;
            }
            if (action.hasAnyChain() && (capA.getState() == action.getChainState() || capA.getState() == action.getChainState() - 1 && capA.getFrame() >= capA.getDuration() - 3)) {
                return true;
            }
            return capA.getState() == action.getChargeState() || capA.getState() == action.getChargeState() - 1 && capA.getFrame() >= capA.getDuration() - 3;
        }
        return capA.getState() == action.getTotalStates() - 1 && capA.getFrame() >= capA.getDuration() - 3;
    }

    public boolean canContinueCharging(LivingEntity user) {
        return true;
    }

    public boolean isStateDamaging(int state) {
        return false;
    }

    public boolean isDamaging(IActionTracker capA) {
        return this.isStateDamaging(capA.getState());
    }

    public int getBlockHitFrame(int state, LivingEntity user) {
        return Math.max(1, this.getDuration(state, user) / 2 + (this.getDuration(state, user) % 2 == 0 ? 0 : 1));
    }

    public double getMaxDistToStart(LivingEntity user) {
        return 1000.0;
    }

    public boolean canHarvest() {
        return this.harvestableBlocks != null;
    }

    public boolean canHarvest(BlockState state) {
        if (this.harvestableBlocks == null) {
            return false;
        }
        return state.m_204336_(this.harvestableBlocks);
    }

    public float getKnockback() {
        return this.knockback;
    }

    public Impact getImpact(@Nullable IActionTracker capA) {
        if (capA == null) {
            return this.impact;
        }
        return this.isChargeable() && capA.isFullyCharged() ? this.impact.increase() : this.impact;
    }

    public int getDuration(int state, LivingEntity user) {
        if (state < 0 || state >= this.duration.length) {
            Nightfall.LOGGER.warn("Action " + this.getRegistryName() + " failed to find state " + state + " on getDuration.");
            return 1;
        }
        int finalDuration = (int)((float)this.duration[state] * ActionTracker.get((Entity)user).getSpeedMultiplier());
        if (this.duration[state] % 2 != finalDuration % 2) {
            ++finalDuration;
        }
        return Mth.m_14045_((int)finalDuration, (int)1, (int)9999);
    }

    public int[] getDurationArray() {
        return (int[])this.duration.clone();
    }

    public int getTotalStates() {
        return this.duration.length;
    }

    public int getRequiredCharge(LivingEntity user) {
        return this.chargeState == -1 ? 0 : this.duration[this.chargeState] / 2;
    }

    public int getMaxCharge() {
        return this.chargeState == -1 ? -1 : this.duration[this.chargeState];
    }

    public int getChargeTimeout() {
        return this.getMaxCharge() * 3;
    }

    public boolean hasChargeZoom() {
        return true;
    }

    public float getChargeProgress(int charge, float chargePartial) {
        return charge > this.getMaxCharge() ? 1.0f : Math.min(1.0f, AnimationUtil.interpolate(Math.max(0, charge - 1), charge, chargePartial) / (float)this.getMaxCharge());
    }

    public int getChargeState() {
        return this.chargeState;
    }

    public boolean isChargeable() {
        return this.getMaxCharge() > 0 && this.chargeState < this.getTotalStates();
    }

    public int getChainState() {
        return this.chainState;
    }

    public boolean hasDefaultChain() {
        return this.chainState > -1 && this.chainState < this.getTotalStates() && this.to != null;
    }

    public boolean hasConditionalChain() {
        return this.chainState > -1 && this.chainState < this.getTotalStates() && this.conditionalTo != null && this.conditionalFunction != null;
    }

    public boolean hasAnyChain() {
        return this.hasDefaultChain() || this.hasConditionalChain();
    }

    public boolean isConditionalChainSatisfied(LivingEntity user) {
        return this.hasConditionalChain() && this.conditionalFunction.apply(user) != false;
    }

    public RegistryObject<? extends Action> getChain(LivingEntity user) {
        if (this.isConditionalChainSatisfied(user)) {
            return this.conditionalChainsTo();
        }
        return this.chainsTo();
    }

    public RegistryObject<? extends Action> chainsTo() {
        return this.to;
    }

    public RegistryObject<? extends Action> conditionalChainsTo() {
        return this.conditionalTo;
    }

    public RegistryObject<? extends Action> chainsFrom() {
        return this.from;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    public boolean isIdle() {
        return this.looping;
    }

    public boolean shouldFreeze() {
        return this.freeze;
    }

    public Supplier<SoundEvent> getSound() {
        return this.sound;
    }

    public Supplier<SoundEvent> getExtraSound() {
        return this.extraSound;
    }

    public boolean allowSprinting() {
        return this.sprinting;
    }

    public boolean allowCrawling() {
        return this.crawling;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean allowStaminaRegen(int state) {
        return true;
    }

    public boolean allowDodging(int state) {
        return true;
    }

    public boolean allowFlag(int state, Goal.Flag flag) {
        return true;
    }

    public boolean isActionEqualOrLinked(ResourceLocation id) {
        if (id.equals((Object)this.getRegistryName())) {
            return true;
        }
        return this.linkedActions.contains(id);
    }

    public void transformModel(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        Player player;
        this.transformModelFull(state, frame, duration, charge, pitch, user, data, mCalc);
        if (user instanceof Player && PlayerData.get(player = (Player)user).getActiveHand() == InteractionHand.OFF_HAND) {
            for (AnimationData d : data.values()) {
                d.mirrorAcrossY();
            }
            mCalc.scale(1.0f, -1.0f, -1.0f);
        }
    }

    private void transformModelFull(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        block5: {
            Action last;
            block6: {
                if (state != 0 || ActionsNF.isEmpty(this.chainsFrom().getId())) break block5;
                last = (Action)((Object)this.chainsFrom().get());
                if (!(last instanceof Attack)) break block6;
                Attack lastAttack = (Attack)last;
                if (!data.keySet().containsAll(lastAttack.modelKeys)) break block5;
            }
            last.transformModelFull(last.getChainState(), 2, 2, charge, last.getPitch(user, mCalc.partialTicks), user, data, mCalc);
        }
        if (state != 0) {
            this.transformModelFull(state - 1, 2, 2, charge, pitch, user, data, mCalc);
        }
        for (AnimationData d : data.values()) {
            d.resetLengths(duration, Easing.inOutSine);
        }
        mCalc.resetLength(duration, Easing.inOutSine);
        this.transformModelSingle(state, frame, duration, charge, pitch, user, data, mCalc);
    }

    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
    }

    public void transformLayer(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        if (state == 0 && !ActionsNF.isEmpty(this.chainsFrom().getId())) {
            Action last = (Action)((Object)this.chainsFrom().get());
            last.transformLayer(last.getChainState(), 2, 2, charge, user, data);
        }
        if (state != 0) {
            this.transformLayer(state - 1, 2, 2, charge, user, data);
        }
        data.resetLengths(duration, Easing.inOutSine);
        this.transformLayerSingle(state, frame, duration, charge, user, data);
    }

    protected void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
    }

    public float getPitch(LivingEntity user, float partialTicks) {
        return user.m_5686_(partialTicks);
    }

    public float getMaxXRot(int state) {
        return 32768.0f;
    }

    public float getMaxYRot(int state) {
        return 32768.0f;
    }

    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        return new ObjectArrayList();
    }

    public void onAttackInput(Player player) {
    }

    public void onUseInput(Player player) {
    }

    public void onStart(LivingEntity user) {
    }

    public void onEnd(LivingEntity user) {
    }

    public void onChainStart(LivingEntity user) {
    }

    public void onChargeRelease(LivingEntity user) {
    }

    public void onTick(LivingEntity user) {
    }

    public float onAttackReceived(LivingEntity user, DamageTypeSource source, float damage) {
        return damage;
    }

    public float onDamageReceived(LivingEntity user, DamageTypeSource source, float damage) {
        return damage;
    }

    public static class Properties {
        private int chargeState = -1;
        private int chainState = -1;
        private RegistryObject<? extends Action> from = ActionsNF.EMPTY;
        private RegistryObject<? extends Action> to = ActionsNF.EMPTY;
        private RegistryObject<? extends Action> conditionalTo = ActionsNF.EMPTY;
        private Function<LivingEntity, Boolean> conditionalFunction;
        private boolean interruptible = false;
        private boolean looping = false;
        private boolean freeze = false;
        private boolean sprinting = false;
        private boolean crawling = false;
        private boolean special = false;
        private Supplier<SoundEvent> sound = () -> null;
        private Supplier<SoundEvent> extraSound = () -> null;
        private TagKey<Block> harvestableBlocks;
        private float knockback;
        private Impact impact;

        public Properties setImpact(Impact impact) {
            this.impact = impact;
            return this;
        }

        public Properties setKnockback(float knockback) {
            this.knockback = knockback;
            return this;
        }

        public Properties setSound(Supplier<SoundEvent> sound) {
            this.sound = sound;
            return this;
        }

        public Properties setExtraSound(Supplier<SoundEvent> sound) {
            this.extraSound = sound;
            return this;
        }

        public Properties setInterruptible() {
            this.interruptible = true;
            return this;
        }

        public Properties setIdle() {
            this.looping = true;
            return this;
        }

        public Properties setFreeze() {
            this.freeze = true;
            return this;
        }

        public Properties setSprinting() {
            this.sprinting = true;
            return this;
        }

        public Properties setCrawling() {
            this.crawling = true;
            return this;
        }

        public Properties setSpecial() {
            this.special = true;
            return this;
        }

        public Properties setChainState(int state) {
            if (state < 0) {
                Nightfall.LOGGER.error("Tried to set Action chain state to negative value.");
            }
            this.chainState = state;
            return this;
        }

        public Properties setChargeState(int state) {
            if (state < 0) {
                Nightfall.LOGGER.error("Tried to set Action charge state to negative value.");
            }
            this.chargeState = state;
            return this;
        }

        public Properties setChainFrom(RegistryObject<? extends Action> id) {
            this.from = id;
            return this;
        }

        public Properties setChainTo(RegistryObject<? extends Action> id) {
            this.to = id;
            return this;
        }

        public Properties setConditionalChainTo(RegistryObject<? extends Action> id) {
            this.conditionalTo = id;
            return this;
        }

        public Properties setConditionalChainFunction(Function<LivingEntity, Boolean> conditionalFunction) {
            this.conditionalFunction = conditionalFunction;
            return this;
        }

        public Properties setHarvestable(TagKey<Block> harvestable) {
            this.harvestableBlocks = harvestable;
            return this;
        }
    }
}

