/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.item.ImpactSoundType;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;

public abstract class Attack
extends Action {
    protected static final EnumMap<EntityPart, AnimationData> EMPTY_MAP = new EnumMap(EntityPart.class);
    protected final float damage;
    protected final DamageType[] damageType;
    protected final HurtSphere hurtSpheres;
    protected final AttackEffect[] effects;
    protected final int maxTargets;
    protected final int stunDuration;
    protected final Set<EntityPart> modelKeys;

    public Attack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(duration);
        this.damageType = damageType;
        this.damage = damage;
        this.hurtSpheres = hurtSpheres;
        this.maxTargets = maxTargets;
        this.effects = effects;
        this.stunDuration = stunDuration;
        this.modelKeys = this.getDefaultAnimationData().keySet();
    }

    public Attack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(properties, duration);
        this.damageType = damageType;
        this.damage = damage;
        this.hurtSpheres = hurtSpheres;
        this.maxTargets = maxTargets;
        this.effects = effects;
        this.stunDuration = stunDuration;
        this.modelKeys = this.getDefaultAnimationData().keySet();
    }

    @Override
    public boolean isDamaging(IActionTracker capA) {
        return super.isDamaging(capA) && capA.getFrame() >= this.getDamageStartFrame(capA.getState()) && capA.getFrame() <= this.getDamageEndFrame(capA.getState(), capA.getEntity());
    }

    public Vector3f getTranslation(LivingEntity user) {
        return Vector3f.f_176763_;
    }

    public Vector3f getOffset(LivingEntity user) {
        return Vector3f.f_176763_;
    }

    public ImpactSoundType getImpactSoundType(LivingEntity user) {
        return this.getDamageTypes(user)[0].getImpactSoundType();
    }

    public int getDamageStartFrame(int state) {
        return 1;
    }

    public int getDamageEndFrame(int state, LivingEntity user) {
        return this.getDuration(state, user);
    }

    public String getName(LivingEntity user) {
        return this.getDamageTypes(user)[0].toString();
    }

    public float getDamage(LivingEntity user) {
        return this.damage;
    }

    public DamageType[] getDamageTypes(LivingEntity user) {
        return this.damageType;
    }

    public HurtSphere getHurtSpheres(LivingEntity user) {
        return this.hurtSpheres;
    }

    public int getMaxTargets() {
        return this.maxTargets;
    }

    public int getAttacksPerTick() {
        return 1;
    }

    public AttackEffect[] getEffects(LivingEntity user) {
        return this.effects == null ? null : (AttackEffect[])this.effects.clone();
    }

    public int getStunDuration() {
        return this.stunDuration;
    }

    public float onDamageDealtPre(LivingEntity user, LivingEntity target, float damage) {
        return damage;
    }

    public float onDamageDealtPost(LivingEntity user, LivingEntity target, float damage) {
        return damage;
    }

    protected abstract EnumMap<EntityPart, AnimationData> getDefaultAnimationData();

    public EnumMap<EntityPart, AnimationData> getAnimationData(LivingEntity user, IActionTracker capA) {
        EnumMap<EntityPart, AnimationData> map = this.getDefaultAnimationData();
        for (AnimationData data : map.values()) {
            data.update(capA.getFrame(), capA.getDuration(), user.f_19853_.m_5776_() ? ClientEngine.get().getPartialTick() : 1.0f);
        }
        return map;
    }
}

