/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action;

import frostnox.nightfall.item.ImpactSoundType;

public enum DamageType {
    STRIKING("striking", ImpactSoundType.STRIKE),
    SLASHING("slashing", ImpactSoundType.SLASH),
    PIERCING("piercing", ImpactSoundType.PIERCE),
    FIRE("fire", ImpactSoundType.SILENT),
    FROST("frost", ImpactSoundType.SILENT),
    ELECTRIC("electric", ImpactSoundType.SILENT),
    WITHER("wither", ImpactSoundType.SILENT),
    ABSOLUTE("absolute", ImpactSoundType.SILENT);

    public static final DamageType[] STANDARD_TYPES;
    private final String name;
    private final ImpactSoundType soundType;
    private final DamageType[] array;

    private DamageType(String name, ImpactSoundType soundType) {
        this.name = name;
        this.soundType = soundType;
        this.array = new DamageType[]{this};
    }

    public String toString() {
        return this.name;
    }

    public boolean isDefensible() {
        return this != WITHER && this != ABSOLUTE;
    }

    public boolean isPhysical() {
        return this == STRIKING || this == SLASHING || this == PIERCING;
    }

    public boolean isElemental() {
        return this == FIRE || this == FROST || this == ELECTRIC;
    }

    public DamageType[] asArray() {
        return this.array;
    }

    public ImpactSoundType getImpactSoundType() {
        return this.soundType;
    }

    static {
        STANDARD_TYPES = new DamageType[]{STRIKING, SLASHING, PIERCING, FIRE, FROST, ELECTRIC};
    }
}

