/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action;

import com.mojang.math.Vector3d;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.item.ImpactSoundType;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.data.Vec3f;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;

public class DamageTypeSource
extends DamageSource {
    public static final DamageTypeSource IN_FIRE = new DamageTypeSource("inFire", DamageType.FIRE).fromBlock();
    public static final DamageTypeSource LIGHTNING_BOLT = new DamageTypeSource("lightningBolt", DamageType.ELECTRIC);
    public static final DamageTypeSource ON_FIRE = new DamageTypeSource("onFire", DamageType.FIRE).setDoT().setSound(() -> SoundEvents.f_12273_);
    public static final DamageTypeSource LAVA = new DamageTypeSource("lava", DamageType.FIRE).fromBlock();
    public static final DamageTypeSource HOT_FLOOR = new DamageTypeSource("hotFloor", DamageType.FIRE).fromBlock();
    public static final DamageTypeSource IN_WALL = new DamageTypeSource("inWall", DamageType.ABSOLUTE).fromBlock();
    public static final DamageTypeSource CRAMMING = new DamageTypeSource("cramming", DamageType.ABSOLUTE).fromBlock();
    public static final DamageTypeSource DROWN = new DamageTypeSource("drown", DamageType.ABSOLUTE);
    public static final DamageTypeSource STARVE = new DamageTypeSource("starve", DamageType.ABSOLUTE);
    public static final DamageTypeSource CACTUS = new DamageTypeSource("cactus", DamageType.PIERCING).fromBlock();
    public static final DamageTypeSource FALL = new DamageTypeSource("fall", DamageType.ABSOLUTE);
    public static final DamageTypeSource FLY_INTO_WALL = new DamageTypeSource("flyIntoWall", DamageType.ABSOLUTE);
    public static final DamageTypeSource OUT_OF_WORLD = new DamageTypeSource("outOfWorld", DamageType.ABSOLUTE);
    public static final DamageTypeSource GENERIC = new DamageTypeSource("generic", DamageType.ABSOLUTE);
    public static final DamageTypeSource MAGIC = new DamageTypeSource("magic", DamageType.ABSOLUTE);
    public static final DamageTypeSource WITHER_DOT = new DamageTypeSource("wither_dot", DamageType.WITHER).setDoT();
    public static final DamageTypeSource ANVIL = new DamageTypeSource("anvil", DamageType.STRIKING);
    public static final DamageTypeSource FALLING_BLOCK = new DamageTypeSource("fallingBlock", DamageType.STRIKING);
    public static final DamageTypeSource DRAGON_BREATH = new DamageTypeSource("dragonBreath", DamageType.ABSOLUTE).fromBlock();
    public static final DamageTypeSource DRY_OUT = new DamageTypeSource("dryout", DamageType.ABSOLUTE).setDoT();
    public static final DamageTypeSource SWEET_BERRY_BUSH = new DamageTypeSource("sweetBerryBush", DamageType.PIERCING).fromBlock();
    public static final DamageTypeSource UPROOTED = new DamageTypeSource("uprooted", DamageType.ABSOLUTE);
    public static final DamageTypeSource PHYSICAL = new DamageTypeSource("physical", DamageType.STRIKING, DamageType.SLASHING, DamageType.PIERCING);
    public static final DamageTypeSource EXPLOSION = (DamageTypeSource)new DamageTypeSource("explosion", DamageType.STRIKING).m_19375_();
    public static final DamageTypeSource BLEEDING = new DamageTypeSource("bleeding", DamageType.ABSOLUTE).setDoT().setSound((Supplier<SoundEvent>)SoundsNF.BLEEDING_HIT);
    public static final DamageTypeSource POISON = new DamageTypeSource("poison", DamageType.ABSOLUTE).setDoT().setSound((Supplier<SoundEvent>)SoundsNF.POISON_HIT);
    public final DamageType[] types;
    private final Entity entity;
    private final Entity owner;
    @Nullable
    private final HitData hitData;
    private Supplier<Attack> attack = () -> (Attack)((Object)((Object)ActionsNF.EMPTY.get()));
    private boolean fromBlock = false;
    private boolean isDoT = false;
    private Supplier<SoundEvent> sound = () -> null;
    @Nullable
    private ImpactSoundType impactSoundType = null;
    private int stunDuration = 0;
    @Nullable
    private Impact impact = null;
    @Nullable
    private AttackEffect[] effects = null;

    public DamageTypeSource(String id) {
        this(id, null, null, (HitData)null, DamageType.ABSOLUTE);
    }

    public DamageTypeSource(String id, DamageType ... types) {
        this(id, (Entity)null, (Entity)null, (HitData)null, types);
    }

    public DamageTypeSource(String id, Entity entity, DamageType ... types) {
        this(id, entity, (Entity)null, (HitData)null, types);
    }

    public DamageTypeSource(String id, Entity entity, HitData hitData, DamageType ... types) {
        this(id, entity, null, hitData, types);
    }

    public DamageTypeSource(String id, Entity entity, Entity owner, DamageType ... types) {
        this(id, entity, owner, (HitData)null, types);
    }

    public DamageTypeSource(String id, Entity entity, Entity owner, HitData hitData, DamageType ... types) {
        super(id);
        this.types = types;
        this.entity = entity;
        this.owner = owner;
        this.hitData = hitData;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasHitCoords() {
        return this.hitData != null && this.hitData.x != Float.MAX_VALUE;
    }

    public boolean isFromBlock() {
        return this.fromBlock;
    }

    public boolean isDoT() {
        return this.isDoT;
    }

    public SoundEvent getSound() {
        return this.sound.get();
    }

    @Nullable
    public ImpactSoundType getImpactSoundType() {
        return this.impactSoundType;
    }

    @Nullable
    public AttackEffect[] getEffects() {
        return this.effects;
    }

    public Attack getAttack() {
        return this.attack.get();
    }

    public int getStunDuration() {
        if (this.stunDuration > 0) {
            return this.stunDuration;
        }
        return this.getAttack().getStunDuration();
    }

    public Impact getImpact() {
        if (this.impact != null) {
            return this.impact;
        }
        return this.getAttack().getImpact(this.m_7639_() != null && ActionTracker.isPresent(this.m_7639_()) ? ActionTracker.get(this.m_7639_()) : null);
    }

    public Entity m_7639_() {
        return this.entity;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public Vec3f getKnockbackVec() {
        return this.hitData != null ? this.hitData.force : Vec3f.ZERO;
    }

    public Vector3d getHitCoords() {
        return this.hitData != null ? new Vector3d((double)this.hitData.x, (double)this.hitData.y, (double)this.hitData.z) : new Vector3d(0.0, 0.0, 0.0);
    }

    public int getHitBoxIndex() {
        return this.hitData != null ? this.hitData.boxIndex : -1;
    }

    public boolean isOnlyType(DamageType type) {
        return this.types.length == 1 && this.types[0] == type;
    }

    public boolean isType(DamageType type) {
        for (DamageType t : this.types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public DamageTypeSource fromBlock() {
        this.fromBlock = true;
        return this;
    }

    public DamageTypeSource setDoT() {
        this.isDoT = true;
        return this;
    }

    public DamageTypeSource setSound(Supplier<SoundEvent> sound) {
        this.sound = sound;
        return this;
    }

    public DamageTypeSource setImpactSoundType(ImpactSoundType type, Entity target) {
        this.impactSoundType = type;
        this.sound = this.impactSoundType.getImpactSound(target);
        return this;
    }

    public DamageTypeSource setStun(int stunDuration) {
        this.stunDuration = stunDuration;
        return this;
    }

    public DamageTypeSource setImpact(Impact impact) {
        this.impact = impact;
        return this;
    }

    public DamageTypeSource setEffects(AttackEffect ... effects) {
        this.effects = effects;
        return this;
    }

    public DamageTypeSource setAttack(Attack attack) {
        this.attack = () -> attack;
        return this;
    }

    public void tryArmorSoundConversion() {
        if (this.impactSoundType != null && this.impactSoundType.getArmorSound().get() != null) {
            this.sound = this.impactSoundType.getArmorSound();
        }
    }

    public static DamageTypeSource createFallingSource(DamageType type) {
        return new DamageTypeSource("fallingBlock", type);
    }

    public static DamageTypeSource createEntitySource(LivingEntity entity, DamageType ... type) {
        return new DamageTypeSource(type[0].toString(), (Entity)entity, type);
    }

    public static DamageTypeSource createEntitySource(LivingEntity entity, String name, DamageType ... type) {
        return new DamageTypeSource(name, (Entity)entity, type);
    }

    public static DamageTypeSource createExplosionSource(@Nullable LivingEntity pLivingEntity) {
        return (DamageTypeSource)(pLivingEntity != null ? new DamageTypeSource("explosion.entity", (Entity)pLivingEntity, DamageType.STRIKING).m_19375_() : new DamageTypeSource("explosion", DamageType.STRIKING).m_19375_());
    }

    public static DamageTypeSource createPlayerSource(Player user, DamageType type, HitData hitData) {
        return new DamageTypeSource(type.toString(), (Entity)user, hitData, type);
    }

    public static DamageTypeSource createAttackSource(LivingEntity user, Attack attack, HitData hitData) {
        return new DamageTypeSource(attack.getName(user), (Entity)user, hitData, attack.getDamageTypes(user)).setAttack(attack);
    }

    public static DamageTypeSource createIndirectSource(Entity source, DamageType[] type, @Nullable Entity pIndirectEntity, HitData hitData) {
        return (DamageTypeSource)new DamageTypeSource(type[0].toString(), source, pIndirectEntity, hitData, type).m_19366_();
    }

    public static DamageTypeSource createProjectileSource(Entity source, DamageType[] type, @Nullable Entity pIndirectEntity, HitData hitData) {
        return (DamageTypeSource)new DamageTypeSource("projectile", source, pIndirectEntity, hitData, type).m_19366_();
    }

    public static DamageTypeSource createProjectileAttackSource(Entity pSource, DamageType[] type, Attack attack, @Nullable Entity pIndirectEntity, HitData hitData) {
        return (DamageTypeSource)new DamageTypeSource(type[0].toString(), pSource, pIndirectEntity, hitData, type).setAttack(attack).m_19366_();
    }

    public Component m_6157_(LivingEntity killedEntity) {
        if (this.hasEntity() && !this.hasOwner()) {
            ItemStack itemstack = this.entity instanceof LivingEntity ? ((LivingEntity)this.entity).m_21205_() : ItemStack.f_41583_;
            String s = "death.attack." + this.f_19326_;
            return !itemstack.m_41619_() && itemstack.m_41788_() ? new TranslatableComponent(s + ".item", new Object[]{killedEntity.m_5446_(), this.entity.m_5446_(), itemstack.m_41611_()}) : new TranslatableComponent(s, new Object[]{killedEntity.m_5446_(), this.entity.m_5446_()});
        }
        if (this.hasEntity() && this.hasOwner()) {
            Component itextcomponent = this.owner == null ? this.entity.m_5446_() : this.owner.m_5446_();
            ItemStack itemstack = this.owner instanceof LivingEntity ? ((LivingEntity)this.owner).m_21205_() : ItemStack.f_41583_;
            String s = "death.attack." + this.f_19326_;
            String s1 = s + ".item";
            return !itemstack.m_41619_() && itemstack.m_41788_() ? new TranslatableComponent(s1, new Object[]{killedEntity.m_5446_(), itextcomponent, itemstack.m_41611_()}) : new TranslatableComponent(s, new Object[]{killedEntity.m_5446_(), itextcomponent});
        }
        LivingEntity livingentity = killedEntity.m_21232_();
        String s = "death.attack." + this.f_19326_;
        String s1 = s + ".player";
        return livingentity != null ? new TranslatableComponent(s1, new Object[]{killedEntity.m_5446_(), livingentity.m_5446_()}) : new TranslatableComponent(s, new Object[]{killedEntity.m_5446_()});
    }

    public static DamageTypeSource convertFromVanilla(DamageSource source) {
        switch (source.m_19385_()) {
            case "inFire": {
                return IN_FIRE;
            }
            case "lightningBolt": {
                return LIGHTNING_BOLT;
            }
            case "onFire": {
                return ON_FIRE;
            }
            case "lava": {
                return LAVA;
            }
            case "hotFloor": {
                return HOT_FLOOR;
            }
            case "inWall": {
                return IN_WALL;
            }
            case "cramming": {
                return CRAMMING;
            }
            case "drown": {
                return DROWN;
            }
            case "starve": {
                return STARVE;
            }
            case "cactus": {
                return CACTUS;
            }
            case "fall": {
                return FALL;
            }
            case "flyIntoWall": {
                return FLY_INTO_WALL;
            }
            case "outOfWorld": {
                return OUT_OF_WORLD;
            }
            case "generic": {
                return GENERIC;
            }
            case "magic": {
                return MAGIC;
            }
            case "wither": {
                return WITHER_DOT;
            }
            case "anvil": {
                return ANVIL;
            }
            case "fallingBlock": {
                return FALLING_BLOCK;
            }
            case "dragonBreath": {
                return DRAGON_BREATH;
            }
            case "dryout": {
                return DRY_OUT;
            }
            case "sweetBerryBush": {
                return SWEET_BERRY_BUSH;
            }
            case "sting": {
                return new DamageTypeSource("sting", source.m_7639_(), DamageType.PIERCING);
            }
            case "mob": {
                return new DamageTypeSource("mob", source.m_7639_(), source.m_7640_(), DamageType.ABSOLUTE);
            }
            case "player": {
                DamageType type = DamageType.STRIKING;
                ItemStack stack = ((Player)source.m_7639_()).m_21205_();
                if (stack.m_41720_() instanceof SwordItem) {
                    type = DamageType.SLASHING;
                } else if (stack.m_41720_() instanceof TridentItem) {
                    type = DamageType.PIERCING;
                }
                return new DamageTypeSource("player", source.m_7639_(), type);
            }
            case "arrow": {
                return new DamageTypeSource("arrow", source.m_7639_(), source.m_7640_(), DamageType.PIERCING);
            }
            case "trident": {
                return new DamageTypeSource("trident", source.m_7639_(), source.m_7640_(), DamageType.PIERCING);
            }
            case "fireworks": {
                return new DamageTypeSource("fireworks", source.m_7639_(), source.m_7640_(), DamageType.STRIKING);
            }
            case "fireball": {
                return new DamageTypeSource("fireball", source.m_7639_(), source.m_7640_(), DamageType.FIRE);
            }
            case "witherSkull": {
                return new DamageTypeSource("witherSkull", source.m_7639_(), source.m_7640_(), DamageType.WITHER);
            }
            case "thrown": {
                return new DamageTypeSource("thrown", source.m_7639_(), source.m_7640_(), DamageType.ABSOLUTE);
            }
            case "indirectMagic": {
                return new DamageTypeSource("indirectMagic", source.m_7639_(), source.m_7640_(), DamageType.ABSOLUTE);
            }
            case "thorns": {
                return new DamageTypeSource("thorns", source.m_7639_(), source.m_7640_(), DamageType.ABSOLUTE);
            }
            case "explosion.player": 
            case "explosion": {
                return EXPLOSION;
            }
        }
        return PHYSICAL;
    }
}

