/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import frostnox.nightfall.util.math.BoundingSphere;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.Quat;

public class HurtSphere {
    public static final HurtSphere NONE = new HurtSphere(0.0, 0, 0.0, 0.0, 0.0);
    public static final HurtSphere HAMMER = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.1875), new BoundingSphere(0.0, 0.3125, 0.0, 0.1875), new BoundingSphere(0.0, 0.5, 0.0, 0.1875), new BoundingSphere(0.0, 0.65625, 0.0, 0.28125));
    public static final HurtSphere SWORD = new HurtSphere(0.25, 4, 0.0, 0.3, 0.0, 0.0, 0.125, 0.0);
    public static final HurtSphere SABRE = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.25), new BoundingSphere(-0.0625, 0.425, 0.0, 0.25), new BoundingSphere(-0.0625, 0.725, 0.0, 0.25), new BoundingSphere(0.0, 1.025, 0.0, 0.25));
    public static final HurtSphere FLINT_DAGGER = new HurtSphere(0.25, 3, 0.0, 0.18, 0.0, 0.0, 0.125, 0.0);
    public static final HurtSphere CHISEL = new HurtSphere(0.24, 3, 0.0, 0.24, 0.0, 0.0, 0.125, 0.0);
    public static final HurtSphere DAGGER = new HurtSphere(0.25, 3, 0.0, 0.25, 0.0, 0.0, 0.125, 0.0);
    public static final HurtSphere SPEAR = new HurtSphere(0.22, 5, 0.0, 0.27, 0.0, 0.0, 0.125, 0.0);
    public static final HurtSphere CLUB = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.2), new BoundingSphere(0.0, 0.375, 0.0, 0.25), new BoundingSphere(0.0, 0.65625, 0.0, 0.33));
    public static final HurtSphere MACE = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.345, 0.0, 0.22), new BoundingSphere(0.0, 0.565, 0.0, 0.22), new BoundingSphere(0.0, 0.8125, 0.0, 0.27));
    public static final HurtSphere AXE = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.375, 0.0, 0.22), new BoundingSphere(-0.0625, 0.6875, 0.0, 0.27));
    public static final HurtSphere SHOVEL = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.34375, 0.0, 0.22), new BoundingSphere(0.0, 0.5625, 0.0, 0.22), new BoundingSphere(0.0, 0.84375, 0.0, 0.27));
    public static final HurtSphere PICKAXE = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.345, 0.0, 0.22), new BoundingSphere(0.0, 0.6875, 0.0, 0.25), new BoundingSphere(0.21875, 0.625, 0.0, 0.21), new BoundingSphere(-0.21875, 0.625, 0.0, 0.21));
    public static final HurtSphere SICKLE = new HurtSphere(new BoundingSphere(-0.015625, 0.125, 0.0, 0.25), new BoundingSphere(-0.078125, 0.425, 0.0, 0.25), new BoundingSphere(-0.109375, 0.725, 0.0, 0.225), new BoundingSphere(-0.171875, 0.9624999999999999, 0.0, 0.2));
    public static final HurtSphere ADZE = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.345, 0.0, 0.22), new BoundingSphere(0.0, 0.6875, 0.0, 0.24), new BoundingSphere(-0.125, 0.59375, 0.0, 0.2));
    public static final HurtSphere MAUL = new HurtSphere(new BoundingSphere(0.0, 0.125, 0.0, 0.22), new BoundingSphere(0.0, 0.375, 0.0, 0.22), new BoundingSphere(-0.125, 0.6875, 0.0, 0.285));
    public static final HurtSphere SHIELD = new HurtSphere(0.3, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere HUSK_ARM = new HurtSphere(0.3, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere SKELETON_ARM = new HurtSphere(0.2, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere COCKATRICE_BITE = new HurtSphere(0.25, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere COCKATRICE_CLAW = new HurtSphere(0.35, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere SPIDER_BITE = new HurtSphere(0.25, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere ROCKWORM_BITE = new HurtSphere(0.4, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere PIT_DEVIL_BITE = new HurtSphere(0.3, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere ECTOPLASM_CLUB = new HurtSphere(0.3125, 1, 0.0, 0.0, 0.0);
    public static final HurtSphere DRAKEFOWL_CLAW = new HurtSphere(0.3, 1, 0.0, 0.0, 0.0);
    public static final ImmutableMap<HurtSphere, HurtSphere> WEAPONS_TP;
    private final BoundingSphere[] spheres;

    protected static void addTP(ImmutableMap.Builder<HurtSphere, HurtSphere> builder, HurtSphere hurtSphere) {
        builder.put((Object)hurtSphere, (Object)HurtSphere.transformTP(hurtSphere));
    }

    private static HurtSphere transformTP(HurtSphere hurtSphere) {
        BoundingSphere[] spheres;
        for (BoundingSphere sphere : spheres = hurtSphere.getSpheres()) {
            sphere.translate(0.0, -0.125, 0.0);
        }
        Mat4f matrix = new Mat4f(new Quat(-90.0f, Vector3f.f_122225_, true));
        matrix.multiply(new Quat(-90.0f, Vector3f.f_122223_, true));
        for (BoundingSphere sphere : spheres) {
            sphere.transform(matrix);
        }
        return new HurtSphere(spheres);
    }

    public HurtSphere(BoundingSphere ... spheres) {
        this.spheres = spheres;
    }

    public HurtSphere(double radius, int amount, double xSpacing, double ySpacing, double zSpacing) {
        this(radius, amount, xSpacing, ySpacing, zSpacing, 0.0, 0.0, 0.0);
    }

    public HurtSphere(double radius, int amount, double xSpacing, double ySpacing, double zSpacing, double xShift, double yShift, double zShift) {
        this.spheres = new BoundingSphere[amount];
        for (int i = 0; i < amount; ++i) {
            this.spheres[i] = new BoundingSphere(xSpacing * (double)i, ySpacing * (double)i, zSpacing * (double)i, radius);
            this.spheres[i].translate(xShift, yShift, zShift);
        }
    }

    public HurtSphere(double radius, int amount, double xSpacing, double ySpacing, double zSpacing, BoundingSphere ... extraSpheres) {
        this(radius, amount, xSpacing, ySpacing, zSpacing, 0.0, 0.0, 0.0, extraSpheres);
    }

    public HurtSphere(double radius, int amount, double xSpacing, double ySpacing, double zSpacing, double xShift, double yShift, double zShift, BoundingSphere ... extraSpheres) {
        int i;
        this.spheres = new BoundingSphere[amount + extraSpheres.length];
        for (i = 0; i < amount; ++i) {
            this.spheres[i] = new BoundingSphere(xSpacing * (double)i, ySpacing * (double)i, zSpacing * (double)i, radius);
            this.spheres[i].translate(xShift, yShift, zShift);
        }
        for (i = amount; i < amount + extraSpheres.length; ++i) {
            this.spheres[i] = extraSpheres[i - amount];
        }
    }

    public BoundingSphere[] getSpheres() {
        BoundingSphere[] spheres = new BoundingSphere[this.spheres.length];
        for (int i = 0; i < this.spheres.length; ++i) {
            spheres[i] = new BoundingSphere(this.spheres[i]);
        }
        return spheres;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, ADZE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, AXE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, CLUB);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, CHISEL);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, DAGGER);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, FLINT_DAGGER);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, HAMMER);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, MACE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, PICKAXE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, SABRE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, SICKLE);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, SHOVEL);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, SPEAR);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, SWORD);
        HurtSphere.addTP((ImmutableMap.Builder<HurtSphere, HurtSphere>)builder, MAUL);
        WEAPONS_TP = builder.build();
    }
}

