/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.animal.TamableAnimalEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class CollapseAction
extends Action {
    public CollapseAction(int[] duration) {
        super(duration);
    }

    public CollapseAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public int getChargeTimeout() {
        return 1200;
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }

    @Override
    public boolean allowFlag(int state, Goal.Flag flag) {
        return false;
    }

    @Override
    public void onTick(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (capA.getState() == this.getChargeState() && capA.getFrame() == 1 && user instanceof TamableAnimalEntity) {
            TamableAnimalEntity animal = (TamableAnimalEntity)user;
            animal.tamable = true;
        }
    }

    @Override
    public void onStart(LivingEntity user) {
        ((ActionableEntity)user).getNavigator().m_26573_();
    }

    @Override
    public void onEnd(LivingEntity user) {
        if (user instanceof TamableAnimalEntity) {
            TamableAnimalEntity animal = (TamableAnimalEntity)user;
            animal.tamable = false;
        }
        user.m_5634_(user.m_21233_() / 10.0f);
    }
}

