/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.item.IWeaponItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public abstract class NPCAttack
extends Attack {
    public NPCAttack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public NPCAttack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    public InteractionHand getHand() {
        return InteractionHand.MAIN_HAND;
    }

    protected boolean hasWeapon(LivingEntity user) {
        return user.m_21120_(this.getHand()).m_41720_() instanceof IWeaponItem;
    }

    @Override
    public float getDamage(LivingEntity user) {
        Item item = user.m_21120_(this.getHand()).m_41720_();
        if (item instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            return weapon.getBaseDamage() + super.getDamage(user);
        }
        return super.getDamage(user);
    }

    @Override
    public AttackEffect[] getEffects(LivingEntity user) {
        Item item;
        AttackEffect[] effects = super.getEffects(user);
        AttackEffect weaponEffect = null;
        if (user != null && (item = user.m_21120_(this.getHand()).m_41720_()) instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            weaponEffect = weapon.getBaseAttackEffect();
        }
        if (effects == null) {
            return new AttackEffect[]{weaponEffect};
        }
        if (weaponEffect == null) {
            return effects;
        }
        AttackEffect[] newEffects = new AttackEffect[effects.length + 1];
        for (int i = 0; i < effects.length; ++i) {
            newEffects[i] = effects[i];
        }
        newEffects[effects.length] = weaponEffect;
        return newEffects;
    }

    @Override
    public DamageType[] getDamageTypes(LivingEntity user) {
        Item item = user.m_21120_(this.getHand()).m_41720_();
        if (item instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            return weapon.getDefaultDamageTypes();
        }
        return super.getDamageTypes(user);
    }

    @Override
    public HurtSphere getHurtSpheres(LivingEntity user) {
        Item item = user.m_21120_(this.getHand()).m_41720_();
        if (item instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            return weapon.getNPCHurtSpheres();
        }
        return super.getHurtSpheres(user);
    }
}

