/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.cockatrice;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class CockatriceBite
extends NPCAttack {
    public CockatriceBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public CockatriceBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 2.0;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return CockatriceEntity.getHeadAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                neck.rCalc.extend(70.0f + pitch, 0.0f, 0.0f);
                head.rCalc.extend(-70.0f + pitch, 0.0f, 0.0f);
                head.tCalc.add(0.0f, 1.0f, 0.0f);
                break;
            }
            case 1: {
                neck.rCalc.add(20.0f, 0.0f, 0.0f, Easing.outQuart);
                head.rCalc.add(-pitch / 2.0f, 10.0f, 0.0f, Easing.outQuart);
                head.tCalc.add(0.0f, -1.5f, 0.0f, Easing.outQuart);
                break;
            }
            case 2: {
                head.toDefault();
                neck.toDefaultRotation();
            }
        }
        if (data.size() != 3) {
            AnimationData tail = data.get((Object)EntityPart.TAIL);
            AnimationData wingRight = data.get((Object)EntityPart.WING_RIGHT);
            AnimationData wingLeft = data.get((Object)EntityPart.WING_LEFT);
            switch (state) {
                case 0: {
                    tail.rCalc.add(10.0f, 0.0f, 0.0f);
                    wingRight.rCalc.add(8.0f, 0.0f, 8.0f);
                    wingLeft.rCalc.add(8.0f, 0.0f, -8.0f);
                    break;
                }
                case 1: {
                    tail.rCalc.freeze();
                    wingRight.rCalc.add(-8.0f, 0.0f, -12.5f, Easing.outQuart);
                    wingLeft.rCalc.add(-8.0f, 0.0f, 12.5f, Easing.outQuart);
                    break;
                }
                case 2: {
                    tail.toDefaultRotation();
                    wingRight.toDefaultRotation();
                    wingLeft.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 1.21875f, 0.3125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.09375f, 0.1875f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)(user.m_5686_(partialTicks) + 10.0f), (float)-90.0f, (float)90.0f);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (capA.getState() == 0 && capA.getFrame() == capA.getDuration() - 1) {
                CombatUtil.addMovementTowardsTarget(0.5, 1.0, mob);
            }
        }
    }

    @Override
    public String getName(LivingEntity user) {
        return "bite";
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == 1) {
            return 20.0f;
        }
        return super.getMaxXRot(state);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 20.0f;
            case 1 -> 0.0f;
            default -> 30.0f;
        };
    }
}

