/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.cockatrice;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class CockatriceClaw
extends NPCAttack {
    public CockatriceClaw(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public CockatriceClaw(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 1.75;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return EMPTY_MAP;
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (!capA.isStunned()) {
                if (capA.getFrame() == this.getDuration(0, user) - 2 && capA.getState() == 0) {
                    CombatUtil.addMovementTowardsTarget(1.0, 1.0, mob);
                }
                if (capA.getState() == 0 && capA.getFrame() == 1) {
                    user.m_5496_((SoundEvent)SoundsNF.COCKATRICE_FLAP.get(), 1.0f, 1.0f + user.f_19853_.f_46441_.nextFloat(-0.03f, 0.03f));
                }
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (!data.isEmpty()) {
            AnimationData body = data.get((Object)EntityPart.BODY);
            AnimationData neck = data.get((Object)EntityPart.NECK);
            AnimationData head = data.get((Object)EntityPart.HEAD);
            AnimationData tail = data.get((Object)EntityPart.TAIL);
            AnimationData wingRight = data.get((Object)EntityPart.WING_RIGHT);
            AnimationData wingLeft = data.get((Object)EntityPart.WING_LEFT);
            AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    body.tCalc.add(0.0f, -1.5f, 0.0f);
                    body.rCalc.extend(-50.0f, 0.0f, 0.0f);
                    neck.rCalc.extend(75.0f, 0.0f, 0.0f);
                    head.rCalc.extend(-25.0f, 0.0f, 0.0f);
                    legRight.tCalc.add(0.0f, -1.5f, -3.0f);
                    legRight.rCalc.extend(-95.0f, 0.0f, 0.0f, Easing.outCubic);
                    legLeft.tCalc.add(0.0f, -1.5f, -3.0f);
                    legLeft.rCalc.extend(-95.0f, 0.0f, 0.0f, Easing.outCubic);
                    wingLeft.rCalc.extend(-15.0f, 0.0f, 50.0f, Easing.outCubic);
                    wingLeft.rCalc.length /= 2;
                    wingRight.rCalc.extend(-15.0f, 0.0f, -50.0f, Easing.outCubic);
                    wingRight.rCalc.length /= 2;
                    if (frame > duration / 2) {
                        wingLeft.rCalc.resetLength(duration);
                        wingLeft.rCalc.offset = duration / 2;
                        wingLeft.rCalc.add(0.0f, 0.0f, -100.0f, Easing.outCubic);
                        wingRight.rCalc.resetLength(duration);
                        wingRight.rCalc.offset = duration / 2;
                        wingRight.rCalc.add(0.0f, 0.0f, 100.0f, Easing.outCubic);
                    }
                    tail.rCalc.extend(35.0f, 0.0f, 0.0f);
                    break;
                }
                case 1: {
                    body.tCalc.freeze();
                    body.rCalc.add(10.0f, 0.0f, 0.0f, Easing.outQuart);
                    neck.rCalc.add(-10.0f, 0.0f, 0.0f, Easing.outQuart);
                    head.rCalc.freeze();
                    legRight.tCalc.freeze();
                    legRight.rCalc.add(90.0f, 0.0f, 0.0f, Easing.outQuart);
                    legLeft.tCalc.freeze();
                    legLeft.rCalc.add(90.0f, 0.0f, 0.0f, Easing.outCubic);
                    wingLeft.rCalc.add(0.0f, 0.0f, 100.0f, Easing.outCubic);
                    wingRight.rCalc.add(0.0f, 0.0f, -100.0f, Easing.outCubic);
                    tail.rCalc.freeze();
                    break;
                }
                case 2: {
                    body.toDefault();
                    head.toDefaultRotation();
                    neck.toDefaultRotation();
                    legRight.toDefault();
                    legLeft.toDefault();
                    wingRight.toDefaultRotation();
                    wingLeft.toDefaultRotation();
                    tail.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 0.75f, 0.5625f);
    }

    @Override
    public String getName(LivingEntity user) {
        return "maul";
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == 1) {
            return 10.0f;
        }
        return super.getMaxXRot(state);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 20.0f;
            case 1 -> 0.0f;
            default -> 30.0f;
        };
    }
}

