/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.cockatrice;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.projectile.PoisonSpitEntity;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CockatriceSpit
extends Action {
    public CockatriceSpit(int[] duration) {
        super(duration);
    }

    public CockatriceSpit(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 20.0;
    }

    @Override
    public void onTick(LivingEntity user) {
        super.onTick(user);
        IActionTracker capA = ActionTracker.get((Entity)user);
        Level level = user.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (capA.getState() == 1 && capA.getFrame() == 2 && !capA.isStunned()) {
                ActionableEntity entity = (ActionableEntity)user;
                PoisonSpitEntity spit = new PoisonSpitEntity((Level)level2, user);
                BlockPos targetPos = entity.getTargetPos();
                if (targetPos != null) {
                    double z;
                    double y;
                    double x;
                    LivingEntity target = entity.m_5448_();
                    if (target != null) {
                        x = target.m_20185_();
                        y = target.m_20227_(0.33333333);
                        z = target.m_20189_();
                    } else {
                        x = (double)targetPos.m_123341_() + 0.5;
                        y = targetPos.m_123342_();
                        z = (double)targetPos.m_123343_() + 0.5;
                    }
                    double d0 = x - user.m_20185_();
                    double d1 = y - spit.m_20186_();
                    double d2 = z - user.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2) * 0.2;
                    spit.m_6686_(d0, d1 + d3, d2, 1.5f, 0.5f);
                } else {
                    spit.m_37251_((Entity)user, entity.m_146909_(), entity.m_5675_(1.0f), 0.0f, 1.5f, 0.5f);
                }
                level2.m_7967_((Entity)spit);
                user.m_5496_(this.getSound().get(), 1.0f, 1.0f);
                user.m_146850_(GameEventsNF.ACTION_SOUND);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        AnimationData tail = data.get((Object)EntityPart.TAIL);
        AnimationData wingRight = data.get((Object)EntityPart.WING_RIGHT);
        AnimationData wingLeft = data.get((Object)EntityPart.WING_LEFT);
        switch (state) {
            case 0: {
                neck.rCalc.add(-15.0f, 0.0f, 0.0f);
                head.rCalc.add(-15.0f, 0.0f, 0.0f);
                head.tCalc.add(0.0f, 1.0f, 0.0f);
                tail.rCalc.add(10.0f, 0.0f, 0.0f);
                wingRight.rCalc.add(8.0f, 0.0f, 8.0f);
                wingLeft.rCalc.add(8.0f, 0.0f, -8.0f);
                break;
            }
            case 1: {
                neck.rCalc.add(20.0f, 0.0f, 0.0f, Easing.outQuart);
                head.rCalc.add(15.0f, 0.0f, 0.0f, Easing.outQuart);
                head.tCalc.add(0.0f, -1.5f, 0.0f, Easing.outQuart);
                tail.rCalc.freeze();
                wingRight.rCalc.add(-8.0f, 0.0f, -12.5f, Easing.outQuart);
                wingLeft.rCalc.add(-8.0f, 0.0f, 12.5f, Easing.outQuart);
                break;
            }
            case 2: {
                head.toDefault();
                neck.toDefaultRotation();
                tail.toDefaultRotation();
                wingRight.toDefaultRotation();
                wingLeft.toDefaultRotation();
            }
        }
    }
}

