/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.deer;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DeerGraze
extends Action {
    public DeerGraze(int[] duration) {
        super(duration);
    }

    public DeerGraze(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_) {
            ((DeerEntity)user).addSatiety(1);
        }
    }

    @Override
    public int getChargeTimeout() {
        return 800;
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }

    @Override
    public boolean canContinueCharging(LivingEntity user) {
        return ((DeerEntity)user).sprintTime == 0;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                head.rCalc.add(-35.0f, 0.0f, 0.0f);
                neck.rCalc.extend(140.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                float f = (charge > 0.0f ? (float)(ActionTracker.get((Entity)user).getCharge() - 2) + ActionTracker.get((Entity)user).getChargePartial() : (float)(frame - 1) + head.rCalc.partialTicks) * 0.4f;
                head.rCalc.add(Mth.m_14089_((float)f) * 2.0f, 0.0f, 0.0f);
                neck.rCalc.add(Mth.m_14031_((float)f) * 2.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                head.toDefaultRotation();
                neck.toDefaultRotation();
            }
        }
    }
}

