/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.drakefowl;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class DrakefowlClaw
extends NPCAttack {
    public DrakefowlClaw(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public DrakefowlClaw(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 1.0;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return EMPTY_MAP;
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (!capA.isStunned() && capA.getFrame() == this.getDuration(0, user) - 2 && capA.getState() == 0) {
                CombatUtil.addMovementTowardsTarget(1.0, 1.0, mob);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (!data.isEmpty()) {
            AnimationData body = data.get((Object)EntityPart.BODY);
            AnimationData neck = data.get((Object)EntityPart.NECK);
            AnimationData head = data.get((Object)EntityPart.HEAD);
            AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    body.tCalc.add(0.0f, -2.0f, 0.0f);
                    body.rCalc.extend(-45.0f, 0.0f, 0.0f);
                    neck.rCalc.extend(70.0f, 0.0f, 0.0f);
                    head.rCalc.extend(-20.0f, 0.0f, 0.0f);
                    legRight.tCalc.add(0.0f, -3.5f, -3.0f);
                    legRight.rCalc.extend(-115.0f, 0.0f, 0.0f, Easing.outCubic);
                    legLeft.tCalc.add(0.0f, -3.5f, -3.0f);
                    legLeft.rCalc.extend(-115.0f, 0.0f, 0.0f, Easing.outCubic);
                    break;
                }
                case 1: {
                    body.tCalc.freeze();
                    body.rCalc.add(10.0f, 0.0f, 0.0f, Easing.outQuart);
                    neck.rCalc.add(-10.0f, 0.0f, 0.0f, Easing.outQuart);
                    head.rCalc.freeze();
                    legRight.tCalc.add(0.0f, 1.5f, 1.5f, Easing.outQuart);
                    legRight.rCalc.add(95.0f, 0.0f, 0.0f, Easing.outQuart);
                    legLeft.tCalc.add(0.0f, 1.5f, 1.5f, Easing.outCubic);
                    legLeft.rCalc.add(95.0f, 0.0f, 0.0f, Easing.outCubic);
                    break;
                }
                case 2: {
                    body.toDefault();
                    head.toDefaultRotation();
                    neck.toDefaultRotation();
                    legRight.toDefault();
                    legLeft.toDefault();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 0.375f, 0.25f);
    }

    @Override
    public String getName(LivingEntity user) {
        return "claw";
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == 1) {
            return 10.0f;
        }
        return super.getMaxXRot(state);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 20.0f;
            case 1 -> 0.0f;
            default -> 30.0f;
        };
    }
}

