/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.drakefowl;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.npc.CollapseAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DrakefowlCollapse
extends CollapseAction {
    public DrakefowlCollapse(int[] duration) {
        super(duration);
    }

    public DrakefowlCollapse(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
        AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
        switch (state) {
            case 0: {
                body.tCalc.extend(0.0f, 22.0f, 0.0f, Easing.outCubic);
                legRight.rCalc.extend(-90.0f, 35.0f, 0.0f, Easing.outCubic);
                legRight.tCalc.add(0.0f, 4.0f, 0.0f, Easing.outCubic);
                legLeft.rCalc.extend(-90.0f, -35.0f, 0.0f, Easing.outCubic);
                legLeft.tCalc.add(0.0f, 4.0f, 0.0f, Easing.outCubic);
                head.rCalc.extend(-110.0f, 30 * (((ActionableEntity)user).getSynchedRandom() % 2 == 0 ? 1 : -1), 0.0f, Easing.outCubic);
                neck.tCalc.extend(0.0f, -1.0f, -3.0f, Easing.outCubic);
                neck.rCalc.extend(120.0f, 0.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 1: {
                legRight.rCalc.freeze();
                legRight.tCalc.freeze();
                legLeft.rCalc.freeze();
                legLeft.tCalc.freeze();
                float f = (charge > 0.0f ? (float)(ActionTracker.get((Entity)user).getCharge() - 2) + ActionTracker.get((Entity)user).getChargePartial() : (float)(frame - 1) + head.rCalc.partialTicks) * 0.3f;
                neck.rCalc.freeze();
                head.rCalc.freeze();
                body.tCalc.add(0.0f, Mth.m_14089_((float)f) * 0.08f, 0.0f);
                neck.tCalc.add(0.0f, -Mth.m_14089_((float)f) * 0.04f, 0.0f);
                break;
            }
            case 2: {
                body.toDefaultTranslation();
                legRight.toDefault();
                legLeft.toDefault();
                head.toDefault();
                neck.toDefault();
            }
        }
    }
}

