/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.dreg;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.block.block.MoonEssenceBlock;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.monster.DregEntity;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluids;

public class DregBuild
extends Action {
    public DregBuild(int[] duration) {
        super(duration);
    }

    public DregBuild(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void onTick(LivingEntity user) {
        Level level = user.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DregEntity dreg = (DregEntity)user;
            IActionTracker capA = dreg.getActionTracker();
            if (capA.getState() == 1 && capA.getFrame() == capA.getDuration() / 2) {
                ReversePath path = dreg.getBuildPath();
                if (path != null) {
                    boolean built = false;
                    for (int i = path.getSize() - 1; i >= 0; --i) {
                        Node node = path.getNode(i);
                        if (node.type == NodeType.BUILDABLE_WALKABLE) {
                            if (built) break;
                            BlockPos pos = node.getBlockPos().m_7495_();
                            if (level2.m_8055_(pos).m_60722_(Fluids.f_76191_)) {
                                SoundType soundType = ((MoonEssenceBlock)((Object)BlocksNF.MOON_ESSENCE.get())).m_49966_().m_60827_();
                                level2.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                                level2.m_7731_(pos, ((MoonEssenceBlock)((Object)BlocksNF.MOON_ESSENCE.get())).m_49966_(), 3);
                                dreg.addEssence(-10.0f);
                                built = true;
                            }
                        }
                        if (i != 0) continue;
                        dreg.buildDone = true;
                    }
                } else {
                    dreg.buildDone = true;
                }
            }
        }
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 5.0;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
        AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                rightHand.rCalc.extend(-135.0f, 20.0f, 0.0f, Easing.outSine);
                leftHand.rCalc.extend(-135.0f, -20.0f, 0.0f, Easing.outSine);
                head.rCalc.extend(-55.0f, 0.0f, 0.0f, Easing.outSine);
                break;
            }
            case 1: {
                rightArm.toDefaultRotation();
                leftArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftHand.toDefaultRotation();
                head.toDefaultRotation();
                break;
            }
            case 2: {
                rightArm.toDefaultRotation();
                leftArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftHand.toDefaultRotation();
                head.toDefaultRotation();
            }
        }
    }
}

