/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.dreg;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.npc.MoveSpeedAction;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.DregEntity;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;

public class DregChannel
extends MoveSpeedAction {
    public DregChannel(int[] duration) {
        super(-0.15f, duration);
    }

    public DregChannel(Action.Properties properties, int ... duration) {
        super(properties, -0.15f, duration);
    }

    @Override
    public void onTick(LivingEntity user) {
        DregEntity dreg;
        IActionTracker capA;
        if (user.f_19853_.f_46443_ && (capA = (dreg = (DregEntity)user).getActionTracker()).getState() == 1 && dreg.ally != null) {
            user.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE_MOON.get(), dreg.ally.m_20208_(0.5), dreg.ally.m_20187_(), dreg.ally.m_20262_(0.5), (dreg.m_21187_().nextDouble() - 0.5) * 2.0, -dreg.m_21187_().nextDouble(), (dreg.m_21187_().nextDouble() - 0.5) * 2.0);
        }
    }

    @Override
    public int getChargeTimeout() {
        return 32768;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 10.0;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
        AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                rightHand.rCalc.extend(-135.0f, 20.0f, 0.0f, Easing.outSine);
                leftHand.rCalc.extend(-135.0f, -20.0f, 0.0f, Easing.outSine);
                head.rCalc.extend(-55.0f, 0.0f, 0.0f, Easing.outSine);
                break;
            }
            case 1: {
                rightArm.rCalc.freeze();
                leftArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                leftHand.rCalc.freeze();
                head.rCalc.freeze();
                break;
            }
            case 2: {
                rightArm.toDefaultRotation();
                leftArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftHand.toDefaultRotation();
                head.toDefaultRotation();
            }
        }
    }
}

