/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.dreg;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.world.entity.LivingEntity;

public class DregCower
extends Action {
    public DregCower(int[] duration) {
        super(duration);
    }

    public DregCower(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public int getChargeTimeout() {
        return 32768;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
        AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                rightHand.rCalc.extend(-140.0f, -30.0f, 0.0f, Easing.outCubic);
                leftHand.rCalc.extend(-140.0f, 30.0f, 0.0f, Easing.outCubic);
                head.rCalc.extend(20.0f, 0.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 1: {
                rightArm.rCalc.freeze();
                leftArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                leftHand.rCalc.freeze();
                head.rCalc.freeze();
                break;
            }
            case 2: {
                rightArm.toDefaultRotation();
                leftArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftHand.toDefaultRotation();
                head.toDefaultRotation();
            }
        }
    }
}

