/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.ectoplasm;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.EctoplasmEntity;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class EctoplasmClubLarge
extends NPCAttack {
    public EctoplasmClubLarge(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public EctoplasmClubLarge(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 1.75;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return EctoplasmEntity.getClubAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData club = data.get((Object)EntityPart.HAND_RIGHT);
        switch (state) {
            case 0: {
                club.rCalc.add(-20.0f + (pitch < 0.0f ? pitch : 0.0f), 0.0f, 0.0f);
                club.tCalc.extend(club.dTranslation.m_122239_(), -1.0f + (pitch < 0.0f ? pitch * 0.2f : 0.0f), club.dTranslation.m_122269_());
                break;
            }
            case 1: {
                club.rCalc.add(160.0f, 0.0f, 0.0f, Easing.outQuart);
                club.tCalc.add(0.0f, 3.0f, -5.0f, Easing.outQuart);
                break;
            }
            case 2: {
                club.toDefault();
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0625f, 0.6875f, 0.53125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.8125f, 0.0f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-90.0f, (float)90.0f);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 45.0f;
            case 1 -> 10.0f;
            default -> 45.0f;
        };
    }
}

